/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sdcard;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import org.tizen.ecp.sdcard.SDCardAttachHelper;
import org.tizen.ecp.utils.LogUtil;

public class SDCardController
implements Initializable {
    Logger logger = LogUtil.getECPLogger(SDCardController.class).getLogger();
    @FXML
    private ComboBox<String> fxComboBox;
    private ObservableList<String> sdcardComboData = FXCollections.observableArrayList();
    @FXML
    private Button attachButton;
    @FXML
    private Button detachButton;
    private boolean isAttached = false;

    @FXML
    public void onAttachButtonClicked(ActionEvent actionEvent) {
        this.startAttachTask();
        this.disableAllWidgets();
    }

    public void disableAllWidgets() {
        this.logger.info("disable all buttons and combobox");
        this.attachButton.setDisable(true);
        this.detachButton.setDisable(true);
        this.fxComboBox.setDisable(true);
    }

    public void mntButtonClick() {
        this.attachButton.setDisable(true);
        this.detachButton.setDisable(false);
        this.fxComboBox.setDisable(true);
    }

    public void umntButtonClick() {
        this.attachButton.setDisable(false);
        this.detachButton.setDisable(true);
        this.fxComboBox.setDisable(false);
    }

    public boolean sendMessage(String string) {
        return SDCardAttachHelper.getInstance().sendSDcard(string);
    }

    public void startAttachTask() {
        this.sendMessage("1\n" + (String)this.fxComboBox.getValue() + "\n");
    }

    public synchronized void startDetachTask() {
        this.sendMessage("0\n" + (String)this.fxComboBox.getValue() + "\n");
    }

    @FXML
    public void onDetachButtonClicked(ActionEvent actionEvent) {
        this.startDetachTask();
        this.disableAllWidgets();
        this.mntButtonClick();
    }

    public void setComboValue(String string) {
        this.fxComboBox.setValue((Object)string);
    }

    public String getComboValue() {
        return (String)this.fxComboBox.getValue();
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.sdcardComboData.add((Object)"sdcard_4G.img");
        this.sdcardComboData.add((Object)"sdcard_8G.img");
        this.sdcardComboData.add((Object)"sdcard_16G.img");
        this.sdcardComboData.add((Object)"sdcard_32G.img");
        this.fxComboBox.setItems(this.sdcardComboData);
        this.setComboValue("sdcard_4G.img");
        this.detachButton.setDisable(true);
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void setAttached(boolean bl) {
        this.isAttached = bl;
    }
}

