/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.location.LocationInjector;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class LocationCoordinateCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    double latitude;
    @Argument(required=true, index=1)
    double longitude;
    @Argument(required=true, index=2)
    double altitude;
    @Argument(required=true, index=3)
    double accuracy;

    public void printHelp() {
        super.printHelp();
    }

    private boolean checkValues(double d, double d2, double d3, double d4) {
        int n = -90;
        int n2 = 90;
        int n3 = -180;
        int n4 = 180;
        int n5 = -300;
        int n6 = 100000;
        int n7 = 100000;
        boolean bl = false;
        if (d > (double)n2 || d < (double)n) {
            return false;
        }
        if (d2 > (double)n4 || d2 < (double)n3) {
            return false;
        }
        if (d3 > (double)n6 || d3 < (double)n5) {
            return false;
        }
        return !(d4 > (double)n7) && !(d4 < (double)bl);
    }

    public LocationCoordinateCLI() {
        this.messageType = this.TYPE_SENSOR = DeviceMessages.getString("LocationCoordinateCLI.0");
    }

    public int execute() {
        if (!this.checkValues(this.latitude, this.longitude, this.altitude, this.accuracy)) {
            OutputUtil.printError((String)DeviceMessages.getString("LocationCoordinateCLI.1"));
            return 25;
        }
        if (!LocationInjector.getInstance().setMode("2", true)) {
            OutputUtil.printFail();
            return 128;
        }
        LocationInjector.getInstance().injectLocation(this.latitude, this.longitude, this.altitude, this.accuracy);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 120);
        OutputUtil.printOK();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
    }
}

