/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCMimeTypeList;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.string.ApplicationConstants;
import org.tizen.ecp.utils.LogUtil;

public class NFCUtil {
    private static Logger logger = LogUtil.getECPLogger(NFCUtil.class).getLogger();

    public static List<NDEFRecord> makeNDEFMessage(String string) {
        if (string.endsWith(StringResources.NEW_LINE)) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split(",");
        int n = Integer.valueOf(stringArray[1]);
        ArrayList<NDEFRecord> arrayList = new ArrayList<NDEFRecord>();
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[2 + 4 * i];
            NDEFFormat nDEFFormat = null;
            for (NDEFFormat nDEFFormat2 : NDEFFormat.values()) {
                if (!String.valueOf(nDEFFormat2.getFormat()).equals(string2)) continue;
                nDEFFormat = nDEFFormat2;
                break;
            }
            if (nDEFFormat == null) continue;
            arrayList.add(new NDEFRecord(nDEFFormat, stringArray[3 + 4 * i], stringArray[4 + 4 * i], stringArray[5 + 4 * i]));
        }
        return arrayList;
    }

    public static void checkInvalidCharacters(String string) throws NFCEventException {
        for (char c : string.toCharArray()) {
            if (c == '\n') {
                throw new NFCEventException(NFCErrorString.InvalidCharNewLine);
            }
            if (c == ',') {
                throw new NFCEventException(NFCErrorString.InvalidChar);
            }
            if (c < '\u0080') continue;
            throw new NFCEventException(NFCErrorString.InvalidCharAscii);
        }
    }

    public static String checkFileType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(n + 1);
            NFCMimeTypeList nFCMimeTypeList = NFCMimeTypeList.getInstance();
            string2 = nFCMimeTypeList.findMimeType(string3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileSize(String string) throws NFCEventException {
        String string2;
        int n;
        StringBuilder stringBuilder;
        block11: {
            String string3 = "du " + string;
            stringBuilder = new StringBuilder();
            MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

                public void processNewLines(String[] stringArray) {
                    stringBuilder.append(stringArray[0]);
                }
            };
            String string4 = "";
            try {
                SDBHelperUtil.getInstance().executeShellCommand(string3, (IShellOutputReceiver)multiLineReceiver);
            }
            catch (SDBNotExistException sDBNotExistException) {
                logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
                string4 = sDBNotExistException.getMessage();
                return (boolean)string4;
            }
            catch (SDBCommandRejectedException sDBCommandRejectedException) {
                logger.info("SDBCommandRejectedException: " + sDBCommandRejectedException.getMessage());
                string4 = NFCErrorString.CheckVconfException + ApplicationConstants.EMULATOR_NOT_READY;
                return (boolean)string4;
            }
            catch (TimeoutException timeoutException) {
                logger.info("TimeoutException: " + timeoutException.getMessage());
                string4 = NFCErrorString.CheckVconfException + "SDB: " + timeoutException.getMessage();
                return (boolean)string4;
            }
            catch (IOException iOException) {
                logger.info("IOException: " + iOException.getMessage());
                string4 = NFCErrorString.CheckVconfException + "SDB: " + iOException.getMessage();
                return (boolean)string4;
            }
            finally {
                SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
                if (string4.isEmpty()) break block11;
                throw new NFCEventException(string4);
            }
        }
        return (n = (string2 = stringBuilder.toString()).indexOf(9)) != -1 && Integer.valueOf(string2 = string2.substring(0, n)) <= 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean availableNfc() throws NFCEventException {
        String string = "vconftool get db/nfc/enable";
        final StringBuilder stringBuilder = new StringBuilder();
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                stringBuilder.append(stringArray[0]);
            }
        };
        String string2 = "";
        try {
            SDBHelperUtil.getInstance().executeShellRootCommand(string, (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            logger.info("SDBCommandRejectedException: " + sDBCommandRejectedException.getMessage());
            string2 = NFCErrorString.CheckVconfException + ApplicationConstants.EMULATOR_NOT_READY;
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException: " + timeoutException.getMessage());
            string2 = NFCErrorString.CheckVconfException + "SDB: " + timeoutException.getMessage();
        }
        catch (IOException iOException) {
            logger.info("IOException: " + iOException.getMessage());
            string2 = NFCErrorString.CheckVconfException + "SDB: " + iOException.getMessage();
        }
        finally {
            if (!string2.isEmpty()) {
                throw new NFCEventException(string2);
            }
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
        }
        String string3 = stringBuilder.toString();
        logger.info("shellResult: " + string3);
        return string3.indexOf(49) != -1 || string3.contains("True");
    }
}

