/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rssi.ui;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.rssi.ui.RSSISignalImage;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class RSSIController
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(RSSIController.class).getLogger();
    @FXML
    ImageView fx_rssi_img;
    @FXML
    TextField fx_level_textfield;
    Image lv0_img;
    Image lv1_img;
    Image lv2_img;
    Image lv3_img;
    Image lv4_img;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.lv0_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV0.getImg());
        this.lv1_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV1.getImg());
        this.lv2_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV2.getImg());
        this.lv3_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV3.getImg());
        this.lv4_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV4.getImg());
        this.fx_rssi_img.setImage(this.lv0_img);
        this.fx_level_textfield.textProperty().addListener((observableValue, string, string2) -> {
            if (!(string2 == null || string2.length() <= 0 || string2.matches("[0-4]") && Integer.parseInt(string2) >= 0 && Integer.parseInt(string2) <= 4)) {
                this.fx_level_textfield.setText(string);
            }
        });
    }

    public void setLevel(String string) {
        int n;
        this.fx_level_textfield.setText(string);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        switch (n) {
            case 0: {
                this.fx_rssi_img.setImage(this.lv0_img);
                break;
            }
            case 1: {
                this.fx_rssi_img.setImage(this.lv1_img);
                break;
            }
            case 2: {
                this.fx_rssi_img.setImage(this.lv2_img);
                break;
            }
            case 3: {
                this.fx_rssi_img.setImage(this.lv3_img);
                break;
            }
            case 4: {
                this.fx_rssi_img.setImage(this.lv4_img);
                break;
            }
            default: {
                logger.warning("Not supported level: " + n);
            }
        }
    }

    public void send(int n) {
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "11\n" + injectorMessage.getMessage());
        MessageSender.getInstance().sendInjectorReq("telephony", 19, n);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    @FXML
    public void onTextChanged(ActionEvent actionEvent) {
        String string = this.fx_level_textfield.getText();
        if (string.matches("[0-4]")) {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 4) {
                this.send(n);
                this.setLevel(string);
            }
            return;
        }
        MessageBox.error((String)"Please type the rssi level from 0 to 4.");
        actionEvent.consume();
    }

    @FXML
    public void onMouseClicked(MouseEvent mouseEvent) {
        double d = 0.0;
        double d2 = 0.0;
        d = mouseEvent.getX();
        RSSISignalImage rSSISignalImage = RSSISignalImage.getRSSISignalImage((int)d, (int)(d2 = mouseEvent.getY()));
        if (rSSISignalImage != null) {
            int n = rSSISignalImage.getLevel();
            this.setLevel(String.valueOf(n));
            this.send(n);
        }
    }
}

