/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gui;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.ButtonToggleEvent;
import org.tizen.ecp.control.TizenCheckBox;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.control.TizenSliderSkin;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.gui.CANVAS_MODE;
import org.tizen.ecp.sensor.gui.Magnetic;
import org.tizen.ecp.sensor.gui.MobileCanvas;
import org.tizen.ecp.sock.MessageSender;

public class FXMLSensorGuiController
implements Initializable {
    @FXML
    private Canvas fxCanvas;
    @FXML
    private Label fxAccelLab;
    @FXML
    private Label fxMagneticLab;
    @FXML
    private Label fxGyroLab;
    @FXML
    private Slider fxPitchSlider;
    @FXML
    private Slider fxRollSlider;
    @FXML
    private Slider fxYawSlider;
    @FXML
    private Button fxPortraitBtn;
    @FXML
    private Button fxLandscapeBtn;
    @FXML
    private Button fxRePortraitBtn;
    @FXML
    private Button fxReLandscapeBtn;
    @FXML
    private GridPane fxRadioGrid;
    private ToggleGroup toggleGroup;
    private MobileCanvas panel;
    private double orientation_yaw = 180.0;
    private double orientation_pitch = 90.0;
    private double orientation_roll = 180.0;
    ChangeListener<Number> pitchSliderListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            double d = number2.doubleValue() - FXMLSensorGuiController.this.orientation_pitch;
            if (((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.pitchDegree.get() != d) {
                ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.pitchDegree.set(d);
                FXMLSensorGuiController.this.panel.repaint();
                FXMLSensorGuiController.this.sendMessage("1\n", ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accelx, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely);
            }
        }
    };
    ChangeListener<Number> rollSliderListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            double d = number2.doubleValue() - FXMLSensorGuiController.this.orientation_roll;
            if (((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.rollDegree.get() != d) {
                ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.rollDegree.set(d);
                FXMLSensorGuiController.this.panel.repaint();
                FXMLSensorGuiController.this.sendMessage("1\n", ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accelx, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely);
            }
        }
    };
    ChangeListener<Number> yawSliderListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            double d = number2.doubleValue() - FXMLSensorGuiController.this.orientation_yaw;
            if (((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.yawDegree.get() != d) {
                ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.yawDegree.set(d);
                FXMLSensorGuiController.this.panel.repaint();
                FXMLSensorGuiController.this.sendMessage("1\n", ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accelx, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely);
            }
        }
    };
    StringProperty accelProperty = new SimpleStringProperty(this, "accelProp"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxAccelLab.setText((String)FXMLSensorGuiController.this.accelProperty.get());
                    FXMLSensorGuiController.this.sendMessage("1\n", ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accelx, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accely, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.read_accelz);
                }
            });
        }
    };
    StringProperty magneticProperty = new SimpleStringProperty(this, "magneticProp"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxMagneticLab.setText((String)FXMLSensorGuiController.this.magneticProperty.get());
                    Magnetic magnetic = Magnetic.getInstance();
                    FXMLSensorGuiController.this.sendMessage("5\n", magnetic.getAzimuth(), magnetic.getPitch(), magnetic.getRoll(), 3.0, magnetic.getReadCompassX(), magnetic.getReadCompassY(), magnetic.getReadCompassZ());
                }
            });
        }
    };
    StringProperty gyroProperty = new SimpleStringProperty(this, "gyroProp"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxGyroLab.setText((String)FXMLSensorGuiController.this.gyroProperty.get());
                    FXMLSensorGuiController.this.sendMessage("4\n", ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.gyroPitch, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.gyroRoll, ((FXMLSensorGuiController)FXMLSensorGuiController.this).panel.gyroYaw);
                }
            });
        }
    };
    private final DoubleProperty pitchDegree = new SimpleDoubleProperty(this, "pitchDegree"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxPitchSlider.setValue(FXMLSensorGuiController.this.pitchDegree.getValue() + FXMLSensorGuiController.this.orientation_pitch);
                }
            });
        }
    };
    private final DoubleProperty rollDegree = new SimpleDoubleProperty(this, "rollDegree"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxRollSlider.setValue(FXMLSensorGuiController.this.rollDegree.getValue() + FXMLSensorGuiController.this.orientation_roll);
                }
            });
        }
    };
    private final DoubleProperty yawDegree = new SimpleDoubleProperty(this, "yawDegree"){

        protected void invalidated() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXMLSensorGuiController.this.fxYawSlider.setValue(FXMLSensorGuiController.this.yawDegree.getValue() + FXMLSensorGuiController.this.orientation_yaw);
                }
            });
        }
    };
    private double tmp_accel_x = 0.1;
    private double tmp_accel_y = 0.1;
    private double tmp_accel_z = 0.1;
    private double tmp_gyro_x = 0.1;
    private double tmp_gyro_y = 0.1;
    private double tmp_gyro_z = 0.1;
    private int ACCEL_ADJUST = -100000;
    private double tmp_geo_x = 0.1;
    private double tmp_geo_y = 0.1;
    private double tmp_geo_z = 0.1;
    private double tmp_geo_a = 0.1;
    private double tmp_geo_b = 0.1;
    private double tmp_geo_c = 0.1;
    private double tmp_geo_d = 0.1;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.panel = new MobileCanvas(this);
        this.panel.run();
        this.panel.connect();
        this.fxPitchSlider.setSkin((Skin)new TizenSliderSkin(this.fxPitchSlider));
        this.fxRollSlider.setSkin((Skin)new TizenSliderSkin(this.fxRollSlider));
        this.fxYawSlider.setSkin((Skin)new TizenSliderSkin(this.fxYawSlider));
        this.fxPitchSlider.valueProperty().addListener(this.pitchSliderListener);
        this.fxRollSlider.valueProperty().addListener(this.rollSliderListener);
        this.fxYawSlider.valueProperty().addListener(this.yawSliderListener);
        this.makeRadioButtonGrid();
        this.fxPitchSlider.setValue(this.orientation_pitch);
        this.fxRollSlider.setValue(this.orientation_roll);
        this.fxYawSlider.setValue(this.orientation_yaw);
        this.fxPortraitBtn.getStyleClass().add((Object)"sensor-gui-button");
        this.fxLandscapeBtn.getStyleClass().add((Object)"sensor-gui-button");
        this.fxRePortraitBtn.getStyleClass().add((Object)"sensor-gui-button");
        this.fxReLandscapeBtn.getStyleClass().add((Object)"sensor-gui-button");
    }

    private void makeRadioButtonGrid() {
        this.toggleGroup = new ToggleGroup();
        this.toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                FXMLSensorGuiController.this.panel.setMode((CANVAS_MODE)((Object)FXMLSensorGuiController.this.toggleGroup.getSelectedToggle().getUserData()));
            }
        });
        TizenRadioButton tizenRadioButton = new TizenRadioButton("X/Z");
        this.fxRadioGrid.add((Node)tizenRadioButton, 0, 0);
        tizenRadioButton.setToggleGroup(this.toggleGroup);
        tizenRadioButton.setUserData((Object)CANVAS_MODE.YAW_PITCH);
        TizenRadioButton tizenRadioButton2 = new TizenRadioButton("X/Y");
        this.fxRadioGrid.add((Node)tizenRadioButton2, 1, 0);
        tizenRadioButton2.setToggleGroup(this.toggleGroup);
        tizenRadioButton2.setUserData((Object)CANVAS_MODE.ROLL_PITCH);
        TizenRadioButton tizenRadioButton3 = new TizenRadioButton("Move");
        this.fxRadioGrid.add((Node)tizenRadioButton3, 2, 0);
        tizenRadioButton3.setToggleGroup(this.toggleGroup);
        tizenRadioButton3.setUserData((Object)CANVAS_MODE.MOVE);
        tizenRadioButton.setSelected(true);
        TizenCheckBox tizenCheckBox = new TizenCheckBox("With axis");
        tizenCheckBox.setOnSelected((EventHandler)new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent buttonToggleEvent) {
                FXMLSensorGuiController.this.panel.setWithAxis(buttonToggleEvent.isSelected());
            }
        });
        tizenCheckBox.setAlignment(Pos.CENTER_LEFT);
        this.fxRadioGrid.add((Node)tizenCheckBox, 0, 1);
        GridPane.setColumnSpan((Node)tizenCheckBox, (Integer)2);
    }

    public StringProperty getAceelProperty() {
        return this.accelProperty;
    }

    public StringProperty getMagneticProperty() {
        return this.magneticProperty;
    }

    public StringProperty getGyroProperty() {
        return this.gyroProperty;
    }

    public final DoubleProperty getPitchDegreeProperty() {
        return this.pitchDegree;
    }

    public final DoubleProperty getRollDegreeProperty() {
        return this.rollDegree;
    }

    public final DoubleProperty getyawDegreeProperty() {
        return this.yawDegree;
    }

    public Canvas getCanvas() {
        return this.fxCanvas;
    }

    private void setXYZValue(int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        this.fxPitchSlider.setValue((double)n);
        this.fxRollSlider.setValue((double)n2);
        this.fxYawSlider.setValue((double)n3);
        this.panel.setGyroAxisX(dArray);
        this.panel.setGyroAxisY(dArray2);
        this.panel.setGyroAxisZ(dArray3);
        this.panel.repaint();
        this.orientation_pitch = n;
        this.orientation_yaw = n3;
        this.orientation_roll = n2;
        this.initValues();
    }

    public void initValues() {
        this.panel.rollDegree.set(0.0);
        this.panel.pitchDegree.set(0.0);
        this.panel.yawDegree.set(0.0);
        this.panel.setOldGyroRollDegree(0.0);
        this.panel.setOldGyroPitchDegree(0.0);
        this.panel.setOldGyroYawDegree(0.0);
    }

    @FXML
    public void onClickPortraitBtn(ActionEvent actionEvent) {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setXYZValue(90, 180, 180, dArray, dArray2, dArray3);
    }

    @FXML
    public void onClickLandscapeBtn(ActionEvent actionEvent) {
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        double[] dArray2 = new double[]{-1.0, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setXYZValue(90, 180, 270, dArray, dArray2, dArray3);
    }

    @FXML
    public void onClickRePortraitBtn(ActionEvent actionEvent) {
        double[] dArray = new double[]{-1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, -1.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setXYZValue(90, 180, 360, dArray, dArray2, dArray3);
    }

    @FXML
    public void onClickReLandscapeBtn(ActionEvent actionEvent) {
        double[] dArray = new double[]{0.0, 0.0, -1.0};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setXYZValue(90, 180, 90, dArray, dArray2, dArray3);
    }

    public void sendMessage(String string, double d, double d2, double d3) {
        if (string == "1\n") {
            if (this.tmp_accel_x != d || this.tmp_accel_y != d2 || this.tmp_accel_z != d3) {
                InjectorMessage injectorMessage = new InjectorMessage(d * (double)this.ACCEL_ADJUST, d2 * (double)this.ACCEL_ADJUST, d3 * (double)this.ACCEL_ADJUST);
                MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "1\n" + injectorMessage.getMessage());
                this.tmp_accel_x = d;
                this.tmp_accel_y = d2;
                this.tmp_accel_z = d3;
            }
        } else if ("4\n".equals(string) && (this.tmp_gyro_x != d || this.tmp_gyro_y != d2 || this.tmp_gyro_z != d3)) {
            InjectorMessage injectorMessage = new InjectorMessage(d, d2, d3);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "4\n" + injectorMessage.getMessage());
            this.tmp_gyro_x = d;
            this.tmp_gyro_y = d2;
            this.tmp_gyro_z = d3;
        }
    }

    public void sendMessage(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if ("5\n".equals(string) && (this.tmp_geo_x != d || this.tmp_geo_y != d2 || this.tmp_geo_z != d3 || this.tmp_geo_a != d4 || this.tmp_geo_b != d5 || this.tmp_geo_c != d6 || this.tmp_geo_d != d7)) {
            InjectorMessage injectorMessage = new InjectorMessage(d, d2, d3, d4, d5, d6, d7);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "5\n" + injectorMessage.getMessage());
            this.tmp_geo_x = d;
            this.tmp_geo_y = d2;
            this.tmp_geo_z = d3;
            this.tmp_geo_a = d4;
            this.tmp_geo_b = d5;
            this.tmp_geo_c = d6;
            this.tmp_geo_d = d7;
        }
    }
}

