/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.ui;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.TizenCheckBox;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.AbstractInjectorReceiver;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.call.G01A07;
import org.tizen.ecp.telephony.protocol.call.G01A21MO;
import org.tizen.ecp.telephony.protocol.call.G01A21MT;
import org.tizen.ecp.telephony.protocol.call.G01A22;
import org.tizen.ecp.telephony.protocol.call.G01A22End;
import org.tizen.ecp.telephony.protocol.call.G01A23;
import org.tizen.ecp.telephony.protocol.call.G01A26;
import org.tizen.ecp.telephony.protocol.call.G01A29;
import org.tizen.ecp.telephony.protocol.call.G01A62;
import org.tizen.ecp.telephony.protocol.call.G02A31;
import org.tizen.ecp.telephony.protocol.sms.G04A01;
import org.tizen.ecp.telephony.protocol.sms.G04A05;
import org.tizen.ecp.telephony.protocol.sms.crytography.DecodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.EncodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.SMS_USERDATA;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsAddressInfo;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_SUBMIT;
import org.tizen.ecp.telephony.protocol.sms.crytography.TapiNetTextCodingScheme;
import org.tizen.ecp.telephony.protocol.sms.crytography.TmDateTime;
import org.tizen.ecp.telephony.ui.CallInfo;
import org.tizen.ecp.telephony.ui.TelephonyConstants;
import org.tizen.ecp.utils.LogUtil;

public class TelephonyController
implements Initializable {
    Logger logger = LogUtil.getECPLogger(TelephonyController.class).getLogger();
    @FXML
    GridPane fx_hidden_checkbox;
    @FXML
    ComboBox<String> fx_MT_Call_combo;
    @FXML
    ComboBox<String> fx_MO_Call_combo;
    @FXML
    Button fx_connect_btn;
    @FXML
    Button fx_MT_disconnect_btn;
    @FXML
    Button fx_MO_disconnect_btn;
    @FXML
    TextField fx_MT_number_tf;
    @FXML
    TableView<CallInfo> fx_callList_table;
    @FXML
    Label fx_MO_callID_lbl;
    @FXML
    Label fx_MO_number_lbl;
    @FXML
    Label fx_MO_callType_lbl;
    @FXML
    TableColumn<CallInfo, Number> fx_callID_column;
    @FXML
    TableColumn<CallInfo, String> fx_status_column;
    @FXML
    TableColumn<CallInfo, String> fx_momt_column;
    @FXML
    TableColumn<CallInfo, String> fx_multiparty_column;
    @FXML
    TableColumn<CallInfo, String> fx_number_column;
    TizenCheckBox hidden_cb;
    @FXML
    GridPane fx_port_checkbox;
    @FXML
    ComboBox<String> fx_originAddress_combo;
    @FXML
    ComboBox<String> fx_message_combo;
    @FXML
    ComboBox<String> fx_SMS_status_combo;
    @FXML
    ComboBox<String> fx_MMS_status_combo;
    @FXML
    Button fx_sendMsg_btn;
    @FXML
    Button fx_SMS_set_btn;
    @FXML
    Button fx_MMS_set_btn;
    @FXML
    TextField fx_message_textfield;
    @FXML
    TextField fx_port_textfield;
    @FXML
    Label fx_received_msg_lbl;
    @FXML
    Label fx_received_callNumber_lbl;
    TizenCheckBox port_cb;
    HashMap<String, AbstractInjectorReceiver> receiverMap = null;
    ObservableList<CallInfo> callList = FXCollections.observableArrayList();
    boolean isbtenabled = true;
    boolean callWaiting = true;
    boolean isMsgReceived = false;
    boolean rssiStatus = true;
    boolean isInitialized = false;
    boolean listfull = false;
    boolean incoming = false;
    boolean dialing = false;
    boolean calling = false;
    private ObservableList<String> mtCall_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> moCall_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> originatingAddress_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> mmsStatus_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> smsStatus_ComboData = FXCollections.observableArrayList();
    private static ArrayList<AbstractInjectorReceiver> receiverList = new ArrayList();

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.hidden_cb = new TizenCheckBox("Hidden");
        this.hidden_cb.setAlignment(Pos.CENTER_LEFT);
        this.fx_hidden_checkbox.add((Node)this.hidden_cb, 0, 0);
        this.port_cb = new TizenCheckBox("Port");
        this.port_cb.setAlignment(Pos.CENTER_LEFT);
        this.fx_port_checkbox.add((Node)this.port_cb, 0, 0);
        this.mtCall_ComboData.add((Object)"CALL OK (Success)");
        this.fx_MT_Call_combo.setItems(this.mtCall_ComboData);
        this.fx_MT_Call_combo.setValue((Object)"CALL OK (Success)");
        this.moCall_ComboData.add((Object)"CALL OK (Success)");
        this.fx_MO_Call_combo.setItems(this.moCall_ComboData);
        this.fx_MO_Call_combo.setValue((Object)"CALL OK (Success)");
        this.fx_MO_disconnect_btn.setUserData((Object)1);
        this.originatingAddress_ComboData.add((Object)"+821030014180");
        this.fx_originAddress_combo.setItems(this.originatingAddress_ComboData);
        this.fx_originAddress_combo.setValue((Object)"+821030014180");
        this.mmsStatus_ComboData.add((Object)"MMS OK(Success)");
        this.mmsStatus_ComboData.add((Object)"MMS Failure");
        this.fx_MMS_status_combo.setItems(this.mmsStatus_ComboData);
        this.fx_MMS_status_combo.setValue((Object)"MMS OK(Success)");
        this.smsStatus_ComboData.add((Object)"SMS OK(Success)");
        this.smsStatus_ComboData.add((Object)"SMS Not Available");
        this.fx_SMS_status_combo.setItems(this.smsStatus_ComboData);
        this.fx_SMS_status_combo.setValue((Object)"SMS OK(Success)");
        this.fx_callID_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getCallIDProperty());
        this.fx_status_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getStatusProperty());
        this.fx_momt_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getMomtProperty());
        this.fx_multiparty_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getMultipartyProperty());
        this.fx_number_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getNumberProperty());
        this.receiverMap = new HashMap();
        this.registerReceivers();
        this.addInjectorReceiver(receiverList);
        this.fx_callList_table.getSelectionModel().selectedItemProperty().addListener((observableValue, callInfo, callInfo2) -> this.fx_MT_disconnect_btn.setDisable(false));
        this.fx_port_textfield.textProperty().addListener((observableValue, string, string2) -> {
            if (!string2.matches("[0-9]*")) {
                this.fx_port_textfield.setText(string);
            }
        });
        this.onActivate();
    }

    public void onActivate() {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
        this.sendAskData();
    }

    public boolean sendAskData() {
        int n = 17;
        int n2 = 91;
        String string = "";
        this.isInitialized = true;
        return MessageSender.getInstance().sendInjectorReq("telephony", n, n2, string);
    }

    @FXML
    public void onConnectAction(ActionEvent actionEvent) {
        this.setConnectMTButtonStatus(true);
        String string = this.checkStatus();
        if (string != null) {
            this.mtConnect(string);
        }
    }

    @FXML
    public void onMTDisconnectAction(ActionEvent actionEvent) {
        this.callEnd(false);
    }

    @FXML
    public void onMODisconnectAction(ActionEvent actionEvent) {
        int n = (Integer)this.fx_MO_disconnect_btn.getUserData();
        switch (n) {
            case 0: {
                this.moAlert();
                break;
            }
            case 1: {
                this.moConnect();
                break;
            }
            case 2: {
                this.moDisconnect();
            }
        }
    }

    @FXML
    public void onNumberChanged(ActionEvent actionEvent) {
        String string = this.fx_MT_number_tf.getText();
        if (TelephonyController.checkNumberFormat(string)) {
            this.fx_MT_number_tf.setText(string);
        }
    }

    @FXML
    public void onSetSMS() {
        int n = this.get_error_code_from_ui_index(this.fx_SMS_status_combo.getSelectionModel().getSelectedIndex());
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", n2);
        structureGA.setInt("DATA2", n3);
        try {
            this.send(g04A05);
        }
        catch (Exception exception) {
            this.logger.warning(exception.getMessage());
        }
    }

    @FXML
    public void onSetMMS(ActionEvent actionEvent) {
        int n = this.get_error_code_from_ui_index(this.fx_MMS_status_combo.getSelectionModel().getSelectedIndex());
        int n2 = n + 10 & 0xFF;
        int n3 = n + 10 >> 8 & 0xFF;
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", n2);
        structureGA.setInt("DATA2", n3);
        try {
            this.send(g04A05);
        }
        catch (Exception exception) {
            this.logger.warning(exception.getMessage());
        }
    }

    @FXML
    public void onSendMsg(ActionEvent actionEvent) {
        if (!this.checkRSSI()) {
            return;
        }
        String string = (String)this.fx_originAddress_combo.getValue();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.length() > 15) {
            return;
        }
        if (TelephonyController.checkNumberFormat(string)) {
            return;
        }
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        smsAddressInfo.diallingNum = "+821091111".toCharArray();
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        TapiNetTextCodingScheme tapiNetTextCodingScheme = new TapiNetTextCodingScheme();
        tapiNetTextCodingScheme.bCompressed = false;
        tapiNetTextCodingScheme.bMsgClassSet = false;
        tapiNetTextCodingScheme.bMsgIndActive = false;
        tapiNetTextCodingScheme.codingGroupType = 0;
        tapiNetTextCodingScheme.waitingType = 0;
        tapiNetTextCodingScheme.alphabetType = 2;
        tapiNetTextCodingScheme.classType = 0;
        tapiNetTextCodingScheme.codingGroup = 0;
        tapiNetTextCodingScheme.code = 0;
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        if (this.port_cb.isSelected()) {
            tPDU_SMS_DELIVER.ported = true;
            tPDU_SMS_DELIVER.port = Short.parseShort(this.fx_port_textfield.getText());
        } else {
            tPDU_SMS_DELIVER.ported = false;
            tPDU_SMS_DELIVER.port = (short)-1;
        }
        SmsAddressInfo smsAddressInfo2 = new SmsAddressInfo();
        smsAddressInfo2.diallingNum = string.toCharArray();
        smsAddressInfo2.dialnumlen = smsAddressInfo2.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo2;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = new TmDateTime();
        tPDU_SMS_DELIVER.dcs = tapiNetTextCodingScheme;
        tPDU_SMS_DELIVER.udl = 0;
        ArrayList<SMS_USERDATA> arrayList = this.getUserData(this.fx_message_textfield.getText());
        if (arrayList.size() > 1 || tPDU_SMS_DELIVER.ported) {
            tPDU_SMS_DELIVER.udhi = true;
        }
        Iterator<SMS_USERDATA> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SMS_USERDATA sMS_USERDATA;
            tPDU_SMS_DELIVER.userData = sMS_USERDATA = iterator.next();
            int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
            final byte[] byArray = this.convertToByte(cArray, n3);
            G04A01 g04A01 = new G04A01(){

                @Override
                protected void makeBody() {
                    StructureGA structureGA = this.getBody();
                    structureGA.addByteArrayItem("DATA", byArray.length);
                }
            };
            g04A01.intialize();
            StructureGA structureGA = g04A01.getBody();
            structureGA.setByteArray("DATA", byArray);
            try {
                this.send(g04A01);
            }
            catch (Exception exception) {
                this.logger.warning(exception.getMessage());
            }
        }
    }

    public void addInjectorReceiver(ArrayList<AbstractInjectorReceiver> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractInjectorReceiver abstractInjectorReceiver = arrayList.get(i);
            this.receiverMap.put(abstractInjectorReceiver.getKey(), abstractInjectorReceiver);
        }
    }

    private void setConnectMTButtonStatus(boolean bl) {
        this.fx_connect_btn.setDisable(bl);
        this.isbtenabled = !bl;
    }

    private void mtConnect(String string) {
        int n = 1;
        int n2 = 0;
        int n3 = this.hidden_cb.isSelected() ? 1 : 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        G01A21MT g01A21MT = new G01A21MT();
        g01A21MT.intialize();
        StructureGA structureGA = g01A21MT.getBody();
        structureGA.setInt("CALL_TYPE", n);
        structureGA.setInt("FORWARDED_STATUS", n2);
        structureGA.setInt("CLIR_STATUS", n3);
        structureGA.setInt("NUM_LEN", string.getBytes().length);
        structureGA.setInt("NUM_TYPE", n4);
        structureGA.setInt("CLI_PRESENT_ID", n5);
        structureGA.setInt("NO_CLI_CAUSE", n6);
        structureGA.setByteArray("CALL_NUMBER", string.getBytes());
        try {
            this.send(g01A21MT);
        }
        catch (Exception exception) {
            this.logger.warning("The call could not be reached");
        }
    }

    private String checkStatus() {
        if (!this.rssiStatus) {
            MessageBox.error((String)"RSSI level is zero. Please try again later.");
            return null;
        }
        if (this.listfull) {
            MessageBox.error((String)"There are many pending connections. Can't connect anymore.");
            return null;
        }
        if (this.incoming || this.dialing) {
            MessageBox.error((String)"User is busy. Please try again later.");
            return null;
        }
        if (!this.callWaiting && this.calling) {
            MessageBox.error((String)"User is busy. Call waiting mode of emulator is off. Please try again later.");
            return null;
        }
        String string = this.fx_MT_number_tf.getText().trim();
        if (string == null || string.length() == 0) {
            this.setConnectMTButtonStatus(false);
            return null;
        }
        return string;
    }

    private boolean send(AbstractGA abstractGA) {
        return MessageSender.getInstance().sendInjectorReq("telephony", abstractGA.getGroupID(), abstractGA.getActionID(), abstractGA.makePacket());
    }

    public void setCallWaiting(boolean bl) {
        this.callWaiting = bl;
    }

    public void setMsgReceived(boolean bl) {
        this.isMsgReceived = bl;
    }

    public void sendNetStatus(boolean bl) {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        int n = 2;
        int n2 = 1;
        int n3 = bl ? 1 : 0;
        int n4 = 0;
        int n5 = 17;
        int n6 = 32;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 10;
        int n11 = 0;
        G02A31 g02A31 = new G02A31();
        g02A31.intialize();
        StructureGA structureGA = g02A31.getBody();
        structureGA.setInt("NET_ACT_TYPE", n);
        structureGA.setInt("NET_SVC_DOMAIN", n2);
        structureGA.setInt("NET_REG_STATUS", n3);
        structureGA.setInt("NET_EDGE_SUPPORT", n4);
        structureGA.setInt("LAC0", n5);
        structureGA.setInt("LAC1", n6);
        structureGA.setInt("CELL_ID0", n7);
        structureGA.setInt("CELL_ID1", n8);
        structureGA.setInt("CELL_ID2", n9);
        structureGA.setInt("CELL_ID3", n10);
        structureGA.setInt("REJ_CAUSE", n11);
        byte[] byArray = g02A31.makePacket();
        MessageSender.getInstance().sendInjectorReq("telephony", 49, 2, byArray);
        this.setRssiStatus(bl);
    }

    public boolean getRSSIStatus() {
        return this.rssiStatus;
    }

    public void setRssiStatus(boolean bl) {
        this.rssiStatus = bl;
        if (!bl) {
            this.callEnd(true);
        }
    }

    public void callEnd(boolean bl) {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList = bl ? this.fx_callList_table.getItems() : this.fx_callList_table.getSelectionModel().getSelectedItems();
        if (observableList.size() == 0) {
            return;
        }
        for (int i = 0; i < observableList.size(); ++i) {
            int n = ((String)this.fx_MT_Call_combo.getSelectionModel().getSelectedItem()).equals("CALL OK (Success)") ? 32768 : -1;
            int n2 = n & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = ((CallInfo)observableList.get(i)).getCallId();
            G01A07 g01A07 = new G01A07();
            g01A07.intialize();
            StructureGA structureGA = g01A07.getBody();
            structureGA.setInt("ERROR_CAUSE_0", n2);
            structureGA.setInt("ERROR_CAUSE_1", n3);
            G01A22End g01A22End = new G01A22End();
            g01A22End.intialize();
            StructureGA structureGA2 = g01A22End.getBody();
            structureGA2.setInt("CALL_ID", n4);
            try {
                this.send(g01A07);
                this.send(g01A22End);
                String string = this.fx_MO_callID_lbl.getText();
                if (string == null || string.isEmpty() || n4 != Integer.parseInt(string)) continue;
                this.resetCompomentValue();
                continue;
            }
            catch (Exception exception) {
                this.logger.warning(exception.getMessage());
                this.resetCompomentValue();
            }
        }
    }

    public void sendInitialize() {
        byte[] byArray = new byte[]{22, 0, 0, 0};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 65, byArray);
        byte[] byArray2 = new byte[]{0, 0, 64, 66};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 71, byArray2);
        this.isInitialized = true;
    }

    public AbstractInjectorReceiver getReceiver(long l, long l2) {
        return this.receiverMap.get(l + ":" + l2);
    }

    public void registerReceiver(String string, AbstractInjectorReceiver abstractInjectorReceiver) {
        this.receiverMap.put(string, abstractInjectorReceiver);
    }

    protected void registerReceivers() {
        CallList22Receiver callList22Receiver = new CallList22Receiver();
        CallList26Receiver callList26Receiver = new CallList26Receiver();
        CallList29Receiver callList29Receiver = new CallList29Receiver();
        CallReceiver callReceiver = new CallReceiver();
        SimDBReceiver simDBReceiver = new SimDBReceiver();
        this.registerReceiver(callList22Receiver.getKey(), callList22Receiver);
        this.registerReceiver(callList26Receiver.getKey(), callList26Receiver);
        this.registerReceiver(callList29Receiver.getKey(), callList29Receiver);
        this.registerReceiver(callReceiver.getKey(), callReceiver);
        this.registerReceiver(simDBReceiver.getKey(), simDBReceiver);
    }

    private void resetCompomentValue() {
        this.fx_MO_Call_combo.setDisable(true);
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setDisable(true);
        this.dialing = false;
        this.fx_MO_disconnect_btn.setUserData((Object)0);
        this.fx_MO_callID_lbl.setText("");
        this.fx_MO_number_lbl.setText("");
        this.fx_MO_callType_lbl.setText("");
    }

    public void refresh() {
        this.fx_callList_table.getItems().removeAll((Object[])new CallInfo[0]);
        this.fx_callList_table.setItems(this.callList);
        if (this.callList.size() == 0) {
            this.fx_MT_disconnect_btn.setDisable(true);
        }
    }

    public void connectBtStatus(boolean bl) {
        this.fx_connect_btn.setDisable(bl);
        this.isbtenabled = bl;
    }

    private boolean checkRSSI() {
        return this.rssiStatus;
    }

    private static boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9++]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private ArrayList<SMS_USERDATA> getUserData(String string) {
        ArrayList<SMS_USERDATA> arrayList = new ArrayList<SMS_USERDATA>();
        int n = 60;
        int n2 = string.length() / n;
        ++n2;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
            try {
                int n4 = n3 + n > string.length() - n3 ? string.length() - n3 : n3 + n;
                sMS_USERDATA.data = string.substring(n3, n3 + n4).getBytes("ISO-10646-UCS-2");
                sMS_USERDATA.length = sMS_USERDATA.data.length;
                sMS_USERDATA.headerCnt = 1;
                sMS_USERDATA.setSMSUDH('\u0000', (short)0, (char)n2, (char)(i + 1));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                continue;
            }
            if (n2 == 1) {
                sMS_USERDATA.headerCnt = 0;
            }
            arrayList.add(sMS_USERDATA);
            n3 += n;
        }
        return arrayList;
    }

    private byte[] convertToByte(char[] cArray, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    protected int get_error_code_from_ui_index(int n) {
        if (n <= 17) {
            return n;
        }
        switch (n) {
            case 18: {
                return 32769;
            }
            case 19: {
                return 32776;
            }
            case 20: {
                return 32778;
            }
            case 21: {
                return 32789;
            }
            case 22: {
                return 32790;
            }
            case 23: {
                return 32795;
            }
            case 24: {
                return 32796;
            }
            case 25: {
                return 32797;
            }
            case 26: {
                return 32798;
            }
            case 27: {
                return 32806;
            }
            case 28: {
                return 32809;
            }
            case 29: {
                return 32810;
            }
            case 30: {
                return 32815;
            }
            case 31: {
                return 32818;
            }
            case 32: {
                return 32837;
            }
            case 33: {
                return 32849;
            }
            case 34: {
                return 32864;
            }
            case 35: {
                return 32865;
            }
            case 36: {
                return 32866;
            }
            case 37: {
                return 32867;
            }
            case 38: {
                return 32879;
            }
            case 39: {
                return 32895;
            }
            case 40: {
                return 33041;
            }
            case 41: {
                return 33062;
            }
            case 42: {
                return 33068;
            }
        }
        return 0;
    }

    public void sendDeliveryReport() {
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        smsAddressInfo.diallingNum = "+821091111".toCharArray();
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String string = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM");
        String string2 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("dd");
        String string3 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("HH");
        String string4 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("mm");
        String string5 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("ss");
        String string6 = simpleDateFormat.format(date);
        TmDateTime tmDateTime = new TmDateTime();
        tmDateTime.year = Integer.parseInt(string.trim());
        tmDateTime.month = Integer.parseInt(string2.trim());
        tmDateTime.day = Integer.parseInt(string3.trim());
        tmDateTime.hour = Integer.parseInt(string4.trim());
        tmDateTime.minute = Integer.parseInt(string5.trim());
        tmDateTime.second = Integer.parseInt(string6.trim());
        TapiNetTextCodingScheme tapiNetTextCodingScheme = new TapiNetTextCodingScheme();
        tapiNetTextCodingScheme.bCompressed = false;
        tapiNetTextCodingScheme.bMsgClassSet = false;
        tapiNetTextCodingScheme.bMsgIndActive = false;
        tapiNetTextCodingScheme.codingGroupType = 0;
        tapiNetTextCodingScheme.waitingType = 0;
        tapiNetTextCodingScheme.alphabetType = 2;
        tapiNetTextCodingScheme.classType = 0;
        tapiNetTextCodingScheme.codingGroup = 0;
        tapiNetTextCodingScheme.code = 0;
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        SmsAddressInfo smsAddressInfo2 = new SmsAddressInfo();
        String string7 = DecodeMsg.deliveryReportNum_set.iterator().next();
        DecodeMsg.deliveryReportNum_set.remove(string7);
        smsAddressInfo2.diallingNum = String.format(string7, new Object[0]).toCharArray();
        smsAddressInfo2.dialnumlen = smsAddressInfo2.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo2;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = tmDateTime;
        tPDU_SMS_DELIVER.dcs = tapiNetTextCodingScheme;
        tPDU_SMS_DELIVER.udl = 0;
        String string8 = DeviceMessages.getString("TelephonySMSDisplay.20");
        SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
        try {
            sMS_USERDATA.data = string8.getBytes("ISO-10646-UCS-2");
            sMS_USERDATA.length = sMS_USERDATA.data.length;
            sMS_USERDATA.headerCnt = 0;
            sMS_USERDATA.setSMSUDH('\u0000', (short)0, '\u0002', '\u0001');
            tPDU_SMS_DELIVER.userData = sMS_USERDATA;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
        final byte[] byArray = this.convertToByte(cArray, n3);
        G04A01 g04A01 = new G04A01(){

            @Override
            protected void makeBody() {
                StructureGA structureGA = this.getBody();
                structureGA.addByteArrayItem("DATA", byArray.length);
            }
        };
        g04A01.intialize();
        StructureGA structureGA = g04A01.getBody();
        structureGA.setByteArray("DATA", byArray);
        try {
            this.MatrixTime(1200);
            this.send(g04A01);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void MatrixTime(int n) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (l2 - l < (long)n) {
            l2 = System.currentTimeMillis();
        }
    }

    private char[] convertToChar(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i < n) continue;
            cArray[n3++] = (char)byArray[i];
            if (n3 >= n2) break;
        }
        return cArray;
    }

    private void moDisconnect() {
        int n = 2;
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        String string = this.fx_MO_callID_lbl.getText();
        G01A07 g01A07 = new G01A07();
        g01A07.intialize();
        StructureGA structureGA = g01A07.getBody();
        structureGA.setInt("ERROR_CAUSE_0", n2);
        structureGA.setInt("ERROR_CAUSE_1", n3);
        G01A22End g01A22End = new G01A22End();
        g01A22End.intialize();
        StructureGA structureGA2 = g01A22End.getBody();
        structureGA2.setInt("CALL_ID", Integer.parseInt(string));
        this.send(g01A07);
        this.send(g01A22End);
        this.fx_MO_Call_combo.setDisable(true);
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setDisable(true);
        this.dialing = false;
        this.fx_MO_disconnect_btn.setUserData((Object)n);
        this.fx_MO_callID_lbl.setText("");
        this.fx_MO_number_lbl.setText("");
        this.fx_MO_callType_lbl.setText("");
    }

    private void moAlert() {
        G01A62 g01A62 = new G01A62();
        g01A62.intialize();
        this.send(g01A62);
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setText("Connect");
        this.fx_MO_disconnect_btn.setUserData((Object)1);
    }

    private void moConnect() {
        G01A23 g01A23 = new G01A23();
        g01A23.intialize();
        this.send(g01A23);
        this.dialing = false;
        this.fx_MO_disconnect_btn.setText("Disonnect");
        this.fx_MO_disconnect_btn.setUserData((Object)2);
    }

    public class SimDBReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            StructureGA structureGA = abstractGA.getBody();
            TPDU_SMS_SUBMIT tPDU_SMS_SUBMIT = new TPDU_SMS_SUBMIT();
            byte[] byArray = structureGA.getByteArray("DATA");
            char[] cArray = TelephonyController.this.convertToChar(byArray, 3, byArray.length - 3);
            DecodeMsg decodeMsg = new DecodeMsg();
            decodeMsg.DecodeSmsSubmitTpdu(tPDU_SMS_SUBMIT, 500, cArray);
            TelephonyController.this.fx_received_callNumber_lbl.setText(String.valueOf(tPDU_SMS_SUBMIT.destAddr.diallingNum).trim());
            if (DecodeMsg.relayedsms) {
                TelephonyController.this.fx_received_msg_lbl.setText(String.valueOf(DecodeMsg.smsbuffer).trim());
                if (--DecodeMsg.relay_cnt == 0) {
                    for (int i = 0; i < DecodeMsg.smsbuffer_index; ++i) {
                        DecodeMsg.smsbuffer[i] = '\u0000';
                    }
                    DecodeMsg.smsbuffer_index = 0;
                    DecodeMsg.relayedsms = false;
                }
            } else {
                TelephonyController.this.fx_received_msg_lbl.setText(String.valueOf(tPDU_SMS_SUBMIT.userData).trim());
            }
            if (DecodeMsg.deliveryReport) {
                if (DecodeMsg.relayedsms) {
                    if (tPDU_SMS_SUBMIT.udl < 255) {
                        TelephonyController.this.sendDeliveryReport();
                    }
                } else {
                    TelephonyController.this.sendDeliveryReport();
                }
            }
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G04A01();
        }
    }

    public class CallReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            StructureGA structureGA = abstractGA.getBody();
            int n = structureGA.getInt("CALL_ID");
            int n2 = structureGA.getInt("CALL_TYPE");
            String string = new String(structureGA.getByteArray("CALL_NUMBER")).trim();
            TelephonyController.this.fx_MO_callID_lbl.setText(new Integer(n).toString());
            TelephonyController.this.fx_MO_number_lbl.setText(string);
            TelephonyController.this.fx_MO_callType_lbl.setText(TelephonyConstants.CALL_TYPE_LIST[n2]);
            TelephonyController.this.fx_MO_callType_lbl.getParent().layout();
            TelephonyController.this.fx_MO_disconnect_btn.setDisable(false);
            byte[] byArray = structureGA.getByteArray("CALL_NUMBER");
            if (byArray[0] == 4) {
                TelephonyController.this.dialing = true;
                TelephonyController.this.fx_MO_disconnect_btn.setText("Connect");
                TelephonyController.this.fx_MO_disconnect_btn.setUserData((Object)1);
            } else {
                TelephonyController.this.dialing = true;
                TelephonyController.this.fx_MO_disconnect_btn.setText("Alert");
                TelephonyController.this.fx_MO_disconnect_btn.setUserData((Object)0);
            }
            TelephonyController.this.fx_MO_Call_combo.setDisable(false);
            TelephonyController.this.fx_connect_btn.setDisable(true);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A21MO();
        }
    }

    public class CallList29Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            TelephonyController.this.incoming = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                int n3 = structureGA2.getInt("STAT", i) - 1;
                int n4 = structureGA2.getInt("DIR", i) - 1;
                if (n3 < 0 || n4 < 0) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 == 4 || n3 == 5) {
                    TelephonyController.this.incoming = true;
                }
                CallInfo callInfo = new CallInfo(structureGA2.getInt("IDX", i), n3, structureGA2.getInt("MULTIPARTY", i), n4, new String(structureGA2.getByteArray("NUMBER", i)).trim());
                TelephonyController.this.callList.add((Object)callInfo);
                TelephonyController.this.calling = true;
            }
            TelephonyController.this.refresh();
            TelephonyController.this.listfull = (n -= n2) == 6;
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A29();
        }
    }

    public class CallList26Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            TelephonyController.this.incoming = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                int n2 = structureGA2.getInt("STAT", i) - 1;
                int n3 = structureGA2.getInt("DIR", i) - 1;
                if (n2 < 0 || n3 < 0) continue;
                CallInfo callInfo = new CallInfo(structureGA2.getInt("IDX", i), n2, structureGA2.getInt("MULTIPARTY", i), n3, new String(structureGA2.getByteArray("NUMBER", i)).trim());
                if (n2 == 4 || n2 == 5) {
                    TelephonyController.this.incoming = true;
                }
                TelephonyController.this.callList.add((Object)callInfo);
                TelephonyController.this.calling = true;
            }
            TelephonyController.this.refresh();
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A26();
        }
    }

    public class CallList22Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            boolean bl = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            TelephonyController.this.incoming = false;
            for (int i = 0; i < n; ++i) {
                String string;
                CallInfo callInfo;
                String string2;
                int n3 = structureGA2.getInt("STAT", i) - 1;
                int n4 = structureGA2.getInt("DIR", i) - 1;
                if (n3 < 0 || n4 < 0) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 == 4 || n3 == 5) {
                    TelephonyController.this.incoming = true;
                }
                if ((string2 = (callInfo = new CallInfo(structureGA2.getInt("IDX", i), n3, structureGA2.getInt("MULTIPARTY", i), n4, new String(structureGA2.getByteArray("NUMBER", i)).trim())).getNumber()).compareTo(string = TelephonyController.this.fx_MO_number_lbl.getText()) == 0) {
                    bl = true;
                }
                TelephonyController.this.callList.add((Object)callInfo);
            }
            TelephonyController.this.refresh();
            if ((n -= n2) != 6) {
                TelephonyController.this.listfull = false;
            }
            if (n == 0) {
                TelephonyController.this.calling = false;
            }
            if (!bl) {
                TelephonyController.this.resetCompomentValue();
            }
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A22();
        }
    }
}

