/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rssi.cli;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class RSSISetCLIv2
extends AbstractEmulatorCLI {
    @Argument(required=true, index=0)
    String mode;

    public RSSISetCLIv2() {
        this.messageType = "sensor";
    }

    public int execute() {
        int n = 0;
        if (this.mode == null) {
            OutputUtil.printError((String)DeviceMessages.getString("RSSISetCLI.0"));
            this.printHelp();
            return 25;
        }
        try {
            n = Integer.parseInt(this.mode);
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.println((String)("\"" + this.mode + "\"" + " " + DeviceMessages.getString("RSSISetCLI.1")));
            this.printHelp();
            return 25;
        }
        if (n < 0 || n > 4) {
            OutputUtil.println((String)DeviceMessages.getString("RSSISetCLI.2"));
            OutputUtil.println((String)this.help);
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "11\n" + injectorMessage.getMessage());
        MessageSender.getInstance().sendInjectorReq("telephony", 19, n);
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
                OutputUtil.printFail();
                this.stopRunning();
                return;
            }
            MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
            OutputUtil.printOK();
            this.stopRunning();
        }
    }

    public void printHelp() {
        OutputUtil.println((String)this.help);
    }
}

