/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.pedometer;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.pedometer.PedometerModel;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class PedometerController
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(PedometerController.class).getLogger();
    @FXML
    public GridPane pedoGrid;
    private TizenRadioButton stop;
    private TizenRadioButton walk_slow;
    private TizenRadioButton walk;
    private TizenRadioButton run_slow;
    private TizenRadioButton run;
    private PedometerModel model;
    ChangeListener<Number> statusChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            int n = number2.intValue();
            if (n == 1) {
                PedometerController.this.stop.setSelected(true);
            } else if (n == 2) {
                PedometerController.this.walk_slow.setSelected(true);
            } else if (n == 3) {
                PedometerController.this.walk.setSelected(true);
            } else if (n == 4) {
                PedometerController.this.run_slow.setSelected(true);
            } else if (n == 5) {
                PedometerController.this.run.setSelected(true);
            } else {
                logger.warning("Unsupported value: " + n);
            }
        }
    };
    ChangeListener<Toggle> toggleChangeListener = new ChangeListener<Toggle>(){

        public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
            int n = -1;
            if (toggle == null) {
                return;
            }
            if (toggle2.equals(PedometerController.this.stop)) {
                n = 1;
            } else if (toggle2.equals(PedometerController.this.walk_slow)) {
                n = 2;
            } else if (toggle2.equals(PedometerController.this.walk)) {
                n = 3;
            } else if (toggle2.equals(PedometerController.this.run_slow)) {
                n = 4;
            } else if (toggle2.equals(PedometerController.this.run)) {
                n = 5;
            }
            PedometerController.this.model.setStatus(n);
            PedometerController.this.send(n);
        }
    };

    public PedometerController(PedometerModel pedometerModel) {
        this.model = pedometerModel;
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.selectedToggleProperty().addListener(this.toggleChangeListener);
        this.stop = this.model.getStop();
        this.stop.setHgap(18.0);
        this.stop.setToggleGroup(toggleGroup);
        this.pedoGrid.add((Node)this.stop, 1, 1, 3, 1);
        this.walk_slow = this.model.getWalk_slow();
        this.walk_slow.setHgap(18.0);
        this.walk_slow.setToggleGroup(toggleGroup);
        this.pedoGrid.add((Node)this.walk_slow, 1, 3, 3, 1);
        this.walk = this.model.getWalk();
        this.walk.setHgap(18.0);
        this.walk.setToggleGroup(toggleGroup);
        this.pedoGrid.add((Node)this.walk, 1, 5, 3, 1);
        this.run_slow = this.model.getRun_slow();
        this.run_slow.setHgap(18.0);
        this.run_slow.setToggleGroup(toggleGroup);
        this.pedoGrid.add((Node)this.run_slow, 1, 7, 3, 1);
        this.run = this.model.getRun();
        this.run.setHgap(18.0);
        this.run.setToggleGroup(toggleGroup);
        this.pedoGrid.add((Node)this.run, 1, 9, 3, 1);
        this.model.getStatus().addListener(this.statusChangeListener);
    }

    public void send(int n) {
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "23\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            logger.warning("Thread is interrupted.");
        }
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 119);
    }
}

