/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.memory.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import javafx.scene.layout.Pane;
import org.tizen.ecp.memory.ui.MemoryModel;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class MemoryPane
extends ECPPopupPane {
    private MemoryModel model = new MemoryModel();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("vconf", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("vconf", 30, 0, "int\nmemory/sysman/low_memory\n" + StringResources.NEW_LINE);
    }

    public void onShow() {
        int n = this.model.getStatus().get();
        if (n == 4) {
            this.model.getHardWarn().setSelected(true);
        } else if (n == 2) {
            this.model.getSoftWarn().setSelected(true);
        } else if (n == 1) {
            this.model.getNormal().setSelected(true);
        }
    }

    public Pane create() {
        Pane pane = null;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/memory/ui/Memory.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[]{this.model});
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return pane;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 30 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getGroup()) {
            String string2 = injectorNtf.getData().toStringUtf8();
            if (string2.equals(Integer.toString(4))) {
                this.model.setStatus(4);
                this.setCardDescription("Hard Warning");
            } else if (string2.equals(Integer.toString(2))) {
                this.setCardDescription("Soft Warning");
                this.model.setStatus(2);
            } else {
                this.setCardDescription("Normal");
                this.model.setStatus(1);
            }
        }
    }
}

