/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.protocol;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tizen.ecp.location.model.GeoLocation;
import org.tizen.ecp.location.protocol.AbstractNMEA0183;

public class NMEA0183_GPGGA
extends AbstractNMEA0183 {
    private Date currentDate = new Date();
    private String date;
    private GeoLocation location;
    private String qualityIndicator = "1";
    private int numOfSatellites = 5;
    private double hdop = 0.0;
    private double altitude = 0.0;
    private String altitudeUnit = "M";

    public NMEA0183_GPGGA() {
        this(0.0, 0.0);
    }

    public NMEA0183_GPGGA(double d, double d2) {
        super("GPGGA");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss.0");
        this.date = simpleDateFormat.format(this.currentDate);
        this.location = new GeoLocation(d, d2);
        this.createSentence();
    }

    @Override
    protected void createBody() {
        DecimalFormat decimalFormat = new DecimalFormat("0000.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("00000.000000");
        DecimalFormat decimalFormat3 = new DecimalFormat("00");
        DecimalFormat decimalFormat4 = new DecimalFormat("0.0");
        DecimalFormat decimalFormat5 = new DecimalFormat("###0.0");
        this.getBody().add(this.date);
        this.getBody().add(decimalFormat.format(this.location.getNMEAlatitude()));
        this.getBody().add(this.location.getNorthSouth());
        this.getBody().add(decimalFormat2.format(this.location.getNMEAlongitude()));
        this.getBody().add(this.location.getEastWest());
        this.getBody().add(this.qualityIndicator);
        this.getBody().add(decimalFormat3.format(this.numOfSatellites));
        this.getBody().add(decimalFormat4.format(this.hdop));
        this.getBody().add(decimalFormat5.format(this.altitude));
        this.getBody().add(this.altitudeUnit);
        this.getBody().add(NULL);
        this.getBody().add(NULL);
        this.getBody().add(NULL);
        this.getBody().add(NULL);
    }

    @Override
    protected boolean validate() {
        return true;
    }
}

