/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.protocol.sms.crytography;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_SUBMIT;
import org.tizen.ecp.telephony.protocol.sms.crytography.TapiNetTextCodingScheme;
import org.tizen.ecp.utils.LogUtil;

public class DecodeMsg {
    int ton;
    int npi;
    private boolean deliveryReport;
    private char[] smsBuffer;
    private int smsBufferIndex;
    private boolean relayedSms;
    private int relayCnt;
    private int udhl;
    private HashSet<String> deliveryReportNumSet;
    private boolean isDecodeEnd = true;
    Logger logger = LogUtil.getECPLogger(DecodeMsg.class).getLogger();

    public DecodeMsg() {
        this.deliveryReportNumSet = new HashSet();
        this.smsBuffer = new char[4096];
    }

    public int getTon() {
        return this.ton;
    }

    public void setTon(int n) {
        this.ton = n;
    }

    public int getNpi() {
        return this.npi;
    }

    public void setNpi(int n) {
        this.npi = n;
    }

    public boolean isDeliveryReport() {
        return this.deliveryReport;
    }

    public void setDeliveryReport(boolean bl) {
        this.deliveryReport = bl;
    }

    public char[] getSmsbuffer() {
        return this.smsBuffer;
    }

    public void setSmsbuffer(char[] cArray) {
        this.smsBuffer = cArray;
    }

    public int getSmsbuffer_index() {
        return this.smsBufferIndex;
    }

    public void setSmsbuffer_index(int n) {
        this.smsBufferIndex = n;
    }

    public boolean isRelayedsms() {
        return this.relayedSms;
    }

    public void setRelayedsms(boolean bl) {
        this.relayedSms = bl;
    }

    public int getRelay_cnt() {
        return this.relayCnt;
    }

    public void setRelay_cnt(int n) {
        this.relayCnt = n;
    }

    public void setMinusRelayCnt() {
        this.relayCnt = -1;
    }

    public int getUdhl() {
        return this.udhl;
    }

    public void setUdhl(int n) {
        this.udhl = n;
    }

    public HashSet<String> getDeliveryReportNum_set() {
        return this.deliveryReportNumSet;
    }

    public void setDeliveryReportNum_set(HashSet<String> hashSet) {
        this.deliveryReportNumSet = hashSet;
    }

    public boolean isDecodeEnd() {
        return this.isDecodeEnd;
    }

    public void setDecodeEnd(boolean bl) {
        this.isDecodeEnd = bl;
    }

    public boolean DecodeSmsSubmitTpdu(TPDU_SMS_SUBMIT tPDU_SMS_SUBMIT, int n, char[] cArray) {
        int n2;
        this.isDecodeEnd = false;
        int n3 = 0;
        int n4 = 0;
        char[] cArray2 = new char[256];
        char[] cArray3 = new char[21];
        int n5 = 0;
        this.SmsUtilDecodeAddrField_sca(cArray2, cArray);
        n5 += 2;
        n3 = this.getSize(cArray2);
        n5 = n3 % 2 != 0 ? (n5 += n3 / 2 + 1) : (n5 += n3 / 2);
        if (this.ton == 1) {
            cArray3[0] = 43;
            for (n2 = 0; n2 < n3; ++n2) {
                cArray3[n2 + 1] = cArray2[n2];
                cArray3[n3 + 1] = '\u0000';
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                cArray3[n2] = cArray2[n2];
                cArray3[n3] = '\u0000';
            }
        }
        tPDU_SMS_SUBMIT.setMsgType(1);
        tPDU_SMS_SUBMIT.setRd((cArray[n5] & 4) != 0);
        tPDU_SMS_SUBMIT.setVpf((cArray[n5] & 0x18) >> 3);
        tPDU_SMS_SUBMIT.setSrr((cArray[n5] & 0x20) != 0);
        tPDU_SMS_SUBMIT.setUdhi((cArray[n5] & 0x40) != 0);
        tPDU_SMS_SUBMIT.setRp((cArray[n5] & 0x80) != 0);
        tPDU_SMS_SUBMIT.setMr(cArray[++n5]);
        Arrays.fill(cArray2, '\u0000');
        if (!this.SmsUtilDecodeAddrField_dst(cArray2, this.getCharArray(cArray, ++n5))) {
            return false;
        }
        n5 += 2;
        n4 = this.getSize(cArray2);
        n5 = n4 % 2 != 0 ? (n5 += n4 / 2 + 1) : (n5 += n4 / 2);
        if (this.ton == 1) {
            tPDU_SMS_SUBMIT.getDestAddr().setDiallingNum("+" + new String(cArray2));
        } else {
            tPDU_SMS_SUBMIT.getDestAddr().setDiallingNum(new String(cArray2));
        }
        tPDU_SMS_SUBMIT.getDestAddr().setNpi(this.npi);
        tPDU_SMS_SUBMIT.getDestAddr().setTon(this.ton);
        tPDU_SMS_SUBMIT.setpId(cArray[n5]);
        this.SmsUtilDecodeDCS(tPDU_SMS_SUBMIT.getDcs(), cArray[++n5]);
        ++n5;
        switch (tPDU_SMS_SUBMIT.getVp().getVpType()) {
            case 2: {
                tPDU_SMS_SUBMIT.getVp().setVpValue(cArray[n5]);
                tPDU_SMS_SUBMIT.getVp().setVpRelativeType(3);
                ++n5;
                break;
            }
            case 1: 
            case 3: {
                n5 += 7;
                break;
            }
        }
        tPDU_SMS_SUBMIT.setUdl(cArray[n5] & 0xFF);
        if (tPDU_SMS_SUBMIT.getUdl() > 255) {
            tPDU_SMS_SUBMIT.setUdl(255);
        }
        ++n5;
        if (tPDU_SMS_SUBMIT.isUdhi()) {
            this.udhl = cArray[n5];
            n2 = 7 - cArray[n5] * 8 % 7;
            this.udhl += n2;
            if (cArray[n5 += this.udhl] == '\u0001') {
                this.relayCnt = cArray[n5 - 1];
                for (int i = 0; i < this.smsBuffer.length; ++i) {
                    this.smsBuffer[i] = '\u0000';
                }
            }
            ++n5;
            this.relayedSms = true;
        } else if (this.relayedSms) {
            for (n2 = 0; n2 < this.smsBuffer.length; ++n2) {
                this.smsBuffer[n2] = '\u0000';
            }
            this.smsBufferIndex = 0;
            this.relayedSms = false;
        }
        n2 = 0;
        if (tPDU_SMS_SUBMIT.getDcs().getAlphabetType() == 0) {
            char[] cArray4 = new char[256];
            for (n2 = 0; n2 < tPDU_SMS_SUBMIT.getUdl(); ++n2) {
                cArray4[n2] = (char)(cArray[n5 + n2] & 0xFF);
                if (this.relayCnt == 1 ? n2 == tPDU_SMS_SUBMIT.getUdl() - this.udhl : (tPDU_SMS_SUBMIT.isUdhi() ? n2 == tPDU_SMS_SUBMIT.getUdl() - this.udhl : n2 == tPDU_SMS_SUBMIT.getUdl())) break;
            }
            cArray4[n2] = '\u0000';
            tPDU_SMS_SUBMIT.setUserData(cArray4);
            if (this.relayedSms) {
                String string = new String(this.smsBuffer);
                String string2 = new String(cArray4);
                String string3 = string.trim() + string2.trim();
                this.smsBuffer = string3.toCharArray();
            }
        } else if (tPDU_SMS_SUBMIT.getDcs().getAlphabetType() == 2) {
            byte[] byArray = new byte[256];
            for (n2 = 0; n2 < tPDU_SMS_SUBMIT.getUdl(); ++n2) {
                byArray[n2] = (byte)(cArray[n5 + n2] & 0xFF);
                if (this.relayCnt == 1 ? n2 == tPDU_SMS_SUBMIT.getUdl() - this.udhl + 1 : (tPDU_SMS_SUBMIT.isUdhi() ? n2 == tPDU_SMS_SUBMIT.getUdl() - this.udhl : n2 == tPDU_SMS_SUBMIT.getUdl())) break;
            }
            try {
                byArray[n2] = 0;
                tPDU_SMS_SUBMIT.setUserData(this.ucs2ToUTF16(byArray, n2 / 2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (tPDU_SMS_SUBMIT.isSrr()) {
            this.deliveryReportNumSet.add(String.valueOf(cArray2).trim());
            this.deliveryReport = true;
        } else {
            this.deliveryReport = false;
        }
        this.isDecodeEnd = true;
        return true;
    }

    private char[] getCharArray(char[] cArray, int n) {
        int n2 = cArray.length - n;
        char[] cArray2 = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[n + i];
        }
        return cArray2;
    }

    private void SmsUtilDecodeDCS(TapiNetTextCodingScheme tapiNetTextCodingScheme, char c) {
        if (c < '\u0080') {
            if (c < '@') {
                tapiNetTextCodingScheme.setCodingGroupType(0);
            } else {
                tapiNetTextCodingScheme.setCodingGroupType(5);
            }
            if ((c & 0x20) != 0) {
                tapiNetTextCodingScheme.setbCompressed(true);
            }
            if ((c & 0x10) != 0) {
                tapiNetTextCodingScheme.setbMsgClassSet(true);
                tapiNetTextCodingScheme.setClassType(c & 3);
            } else {
                tapiNetTextCodingScheme.setClassType(4);
            }
            switch (c & 0xC) {
                case 0: {
                    tapiNetTextCodingScheme.setAlphabetType(0);
                    break;
                }
                case 4: {
                    tapiNetTextCodingScheme.setAlphabetType(1);
                    break;
                }
                case 8: {
                    tapiNetTextCodingScheme.setAlphabetType(2);
                    break;
                }
                case 12: {
                    tapiNetTextCodingScheme.setAlphabetType(4);
                    break;
                }
            }
        } else if (c == '\u00c0') {
            tapiNetTextCodingScheme.setCodingGroupType(7);
        } else if (c < '\u00f0') {
            if (c < '\u00e0') {
                tapiNetTextCodingScheme.setCodingGroupType(8);
            } else {
                tapiNetTextCodingScheme.setCodingGroupType(9);
            }
            if ((c & 8) != 0) {
                tapiNetTextCodingScheme.setbMsgIndActive(true);
            }
            tapiNetTextCodingScheme.setWaitingType(c & 3);
        } else {
            tapiNetTextCodingScheme.setCodingGroupType(11);
            if ((c & 4) != 0) {
                tapiNetTextCodingScheme.setAlphabetType(1);
            }
            tapiNetTextCodingScheme.setClassType(c & 3);
        }
    }

    private boolean SmsUtilDecodeAddrField_sca(char[] cArray, char[] cArray2) {
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        this.ton = (cArray2[n + 1] & 0x70) >> 4;
        this.npi = cArray2[n + 1] & 0xF;
        if (this.ton != 5) {
            c = cArray2[n];
            if (c > '\u0001') {
                n2 = (cArray2[n++] - '\u0001') * 2;
            }
        } else {
            n2 = (cArray2[n++] + '\u0001') / 2 * 8 / 7;
        }
        if (n2 > 20) {
            n2 = 20;
        }
        ++n;
        if (this.ton != 5) {
            return this.SmsUtilConvertBCD2Digit(cArray, this.getCharArray(cArray2, n), n2);
        }
        this.SmsUtilUnpackGSMCode(cArray, this.getCharArray(cArray2, n), n2);
        return true;
    }

    private boolean SmsUtilDecodeAddrField_dst(char[] cArray, char[] cArray2) {
        int n = 0;
        int n2 = 0;
        this.ton = (cArray2[n + 1] & 0x70) >> 4;
        this.npi = cArray2[n + 1] & 0xF;
        n2 = this.ton != 5 ? cArray2[n++] : (cArray2[n++] + '\u0001') / 2 * 8 / 7;
        if (n2 > 20) {
            n2 = 20;
        }
        ++n;
        if (this.ton != 5) {
            return this.SmsUtilConvertBCD2Digit(cArray, this.getCharArray(cArray2, n), n2);
        }
        this.SmsUtilUnpackGSMCode(cArray, this.getCharArray(cArray2, n), n2);
        return true;
    }

    private boolean SmsUtilConvertBCD2Digit(char[] cArray, char[] cArray2, int n) {
        char[] cArray3 = new char[]{'\u0000', '\u0000'};
        if (cArray2 == null || cArray == null) {
            this.logger.warning(DeviceMessages.getString("DecodeMsg.0"));
            return false;
        }
        if (n == 0) {
            cArray[0] = '\u0000';
            return true;
        }
        int n2 = n % 2 != 0 ? n / 2 + 1 : n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = cArray2[i] & 0xF;
            if (n3 == 10) {
                n3 = 42;
            } else if (n3 == 11) {
                n3 = 35;
            } else if (n3 == 12) {
                n3 = 112;
            } else if (n3 == 15) {
                n3 = 0;
            } else {
                this.AcItoa(n3, cArray3, 16);
                n3 = (char)this.AcToupper(cArray3[0]);
            }
            int n4 = cArray2[i] >> 4 & 0xF;
            if (n4 == 10) {
                n4 = 42;
            } else if (n4 == 11) {
                n4 = 35;
            } else if (n4 == 12) {
                n4 = 112;
            } else {
                if (n4 == 15) {
                    cArray[this.getSize((char[])cArray)] = n3;
                    cArray[n2 * 2 - 1] = '\u0000';
                    return true;
                }
                this.AcItoa(n4, cArray3, 16);
                n4 = (char)this.AcToupper(cArray3[0]);
            }
            cArray[this.getSize((char[])cArray)] = n3;
            cArray[this.getSize((char[])cArray)] = n4;
        }
        cArray[n] = '\u0000';
        return true;
    }

    private int getSize(char[] cArray) {
        int n = 0;
        String string = new String(cArray);
        n = string.indexOf(0);
        return n;
    }

    private int AcToupper(int n) {
        return 97 <= n && n <= 122 ? n - 32 : n;
    }

    private void AcItoa(int n, char[] cArray, int n2) {
        int n3 = 0;
        String string = new String("0123456789ABCDEF");
        do {
            cArray[n3++] = string.charAt(n % n2);
        } while ((n /= n2) > 0);
        this.reverse(cArray, n3);
        cArray[n3] = '\u0000';
    }

    private void reverse(char[] cArray, int n) {
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n2];
            cArray[n2--] = c;
        }
    }

    private void SmsUtilUnpackGSMCode(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            cArray[n4] = (char)(cArray2[n3] << n2 & 0x7F);
            if (n3 != 0) {
                int n5 = n4;
                cArray[n5] = (char)(cArray[n5] | cArray2[n3 - 1] >> 8 - n2);
            }
            if (++n2 == 7) {
                n2 = 0;
                cArray[++n4] = (char)(cArray2[n3] >> 1);
                if (cArray[n4] == '\u0000') break;
            }
            ++n4;
            ++n3;
        }
    }

    public char[] ucs2ToUTF16(byte[] byArray, int n) throws UnsupportedEncodingException {
        String string = new String(byArray, "UTF-16");
        char[] cArray = string.toCharArray();
        String string2 = new String(this.smsBuffer);
        String string3 = string.substring(0, n);
        String string4 = string2.trim() + string3.trim();
        this.smsBuffer = string4.toCharArray();
        return cArray;
    }
}

