/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.protocol;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.tizen.ecp.location.protocol.AbstractNMEA0183;
import org.tizen.ecp.location.protocol.SatelliteInfo;

public class NMEA0183_GPGSV
extends AbstractNMEA0183 {
    private int numTotalMessage = 3;
    private int seq;
    private int satellitesInView = 10;
    private SatelliteInfo[] satellites;

    public NMEA0183_GPGSV(int n) {
        this(n, NMEA0183_GPGSV.createDefaultSatellites(n));
    }

    public NMEA0183_GPGSV(int n, SatelliteInfo[] satelliteInfoArray) {
        super("GPGSV");
        this.seq = n;
        this.satellites = satelliteInfoArray;
        this.createSentence();
    }

    @Override
    protected void createBody() {
        DecimalFormat decimalFormat = new DecimalFormat("##0");
        DecimalFormat decimalFormat2 = new DecimalFormat("00");
        this.getBody().add(decimalFormat.format(this.numTotalMessage));
        this.getBody().add(decimalFormat.format(this.seq));
        this.getBody().add(decimalFormat.format(this.satellitesInView));
        for (int i = 0; i < this.satellites.length; ++i) {
            this.getBody().add(decimalFormat2.format(this.satellites[i].getId()));
            this.getBody().add(decimalFormat.format(this.satellites[i].getElevation()));
            this.getBody().add(decimalFormat.format(this.satellites[i].getAzimuth()));
            if (this.satellites[i].getSnr() == 0) {
                this.getBody().add(NULL);
                continue;
            }
            this.getBody().add(decimalFormat.format(this.satellites[i].getSnr()));
        }
    }

    @Override
    protected boolean validate() {
        return true;
    }

    private static SatelliteInfo[] createDefaultSatellites(int n) {
        ArrayList<SatelliteInfo> arrayList = new ArrayList<SatelliteInfo>();
        int n2 = 4;
        if (n == 3) {
            n2 = 2;
        }
        for (int i = 1; i <= n2; ++i) {
            arrayList.add(new SatelliteInfo(4 * (n - 1) + i, 45, 300, 0));
        }
        return arrayList.toArray(new SatelliteInfo[arrayList.size()]);
    }
}

