#ifndef _EVAS_3D_MATERIAL_EO_H_
#define _EVAS_3D_MATERIAL_EO_H_

#ifndef _EVAS_3D_MATERIAL_EO_CLASS_TYPE
#define _EVAS_3D_MATERIAL_EO_CLASS_TYPE

typedef Eo Evas_3D_Material;

#endif

#ifndef _EVAS_3D_MATERIAL_EO_TYPES
#define _EVAS_3D_MATERIAL_EO_TYPES


#endif
#define EVAS_3D_MATERIAL_CLASS evas_3d_material_class_get()

const Eo_Class *evas_3d_material_class_get(void) EINA_CONST;

/**
 *
 * Set the material attribute enable flag of the given material.
 *
 * You might want to disable some material reflection contribution. For
 * example,Emission attribute is rarely used. Disabling unused attributes
 * might help the shading less complex so that can get speed up.
 *
 * By default, diffuse and specular is enabled.
 *
 * @ingroup Evas_3D_Material
 *
 * @param[in] attrib Material attribute ID.
 * @param[in] enable Whether to enable the attribute (@c EINA_TRUE), or not (@c EINA_FALSE).
 *
 */
EOAPI void  evas_3d_material_enable_set(Evas_3D_Material_Attrib attrib, Eina_Bool enable);

/**
 *
 * Get the material attribute enable flag of the given material.
 *
 * @see evas_3d_material_enable_set()
 *
 * @return              @c EINA_TRUE if enabled, or @c EINA_FALSE if not.
 * @ingroup Evas_3D_Material
 *
 * @param[in] attrib Material attribute ID.
 *
 */
EOAPI Eina_Bool  evas_3d_material_enable_get(Evas_3D_Material_Attrib attrib);

/**
 *
 * Set the shininess of the given material.
 *
 * Shininess is only used when specular attribute is enabled. Higher shininess
 * value will make the object more shiny.
 *
 * Default shininess value is 150.0.
 *
 * @see evas_3d_material_enable_set()
 *
 * @ingroup Evas_3D_Material
 *
 * @param[in] shininess Shininess value.
 *
 */
EOAPI void  evas_3d_material_shininess_set(Evas_Real shininess);

/**
 *
 * Get the shininess of the given material.
 *
 * @see evas_3d_material_shininess_set()
 *
 * @return              The shininess value.
 * @ingroup Evas_3D_Material
 *
 *
 */
EOAPI Evas_Real  evas_3d_material_shininess_get(void);

/**
 *
 * Set the texture of the given material.
 *
 * You have to enable the desired attribute first.
 *
 * @see evas_3d_material_enable_set()
 *
 * @ingroup Evas_3D_Material
 *
 * @param[in] attrib Material attribute ID.
 * @param[in] texture No description supplied.
 *
 */
EOAPI void  evas_3d_material_texture_set(Evas_3D_Material_Attrib attrib, Evas_3D_Texture *texture);

/**
 *
 * Get the texture of the given material.
 *
 * @see evas_3d_material_texture_set()
 *
 * @return              The texture that is set to the given material attribute.
 *
 * @ingroup Evas_3D_Material
 *
 * @param[in] attrib Material attribute ID.
 *
 */
EOAPI Evas_3D_Texture * evas_3d_material_texture_get(Evas_3D_Material_Attrib attrib);

/**
 *
 * Set the material attribute color of the given material.
 *
 * Material color is used also when texture map is enabled. The colors will be
 * modulated (multiplied). To controll the color contribution of a material
 * attribute, use gray color. Setting color value for normal attribute has no
 * effect.
 *
 * Default color is as follows.
 *
 * Ambient  : (0.2, 0.2, 0.2, 1.0)
 * Diffuse  : (0.8, 0.8, 0.8, 1.0)
 * Specular : (1.0, 1.0, 1.0, 1.0)
 * Emission : (0.0, 0.0, 0.0, 1.0)
 * Normal   : Not used
 *
 * @ingroup Evas_3D_Material
 * 
 *
 * @param[in] attrib Material attribute ID.
 * @param[in] r Red component of the color.
 * @param[in] g Green component of the color.
 * @param[in] b Blue component of the color.
 * @param[in] a Alpha component of the color.
 *
 */
EOAPI void  evas_3d_material_color_set(Evas_3D_Material_Attrib attrib, Evas_Real r, Evas_Real g, Evas_Real b, Evas_Real a);

/**
 *
 * Get the material attribute color of the given material.
 *
 * @see evas_3d_material_color_set()
 *
 * @ingroup Evas_3D_Material
 * 
 *
 * @param[in] attrib Material attribute ID.
 * @param[out] r Pointer to receive red component of the color.
 * @param[out] g Pointer to receive green component of the color.
 * @param[out] b Pointer to receive blue component of the color.
 * @param[out] a Pointer to receive alpha component of the color.
 *
 */
EOAPI void  evas_3d_material_color_get(Evas_3D_Material_Attrib attrib, Evas_Real *r, Evas_Real *g, Evas_Real *b, Evas_Real *a);


#endif
