#ifndef __DALI_ACTOR_ENUMERATIONS_H__
#define __DALI_ACTOR_ENUMERATIONS_H__

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <dali/public-api/common/dali-common.h>

namespace Dali
{
/**
 * @addtogroup dali_core_actors
 * @{
 */

/**
 * @brief Actor color mode.
 *
 * @since_tizen 2.4
 */
enum ColorMode
{
  USE_OWN_COLOR,                 ///< Actor will use its own color @since_tizen 2.4
  USE_PARENT_COLOR,              ///< Actor will use its parent color @since_tizen 2.4
  USE_OWN_MULTIPLY_PARENT_COLOR, ///< Actor will blend its color with its parents color. @since_tizen 2.4
  USE_OWN_MULTIPLY_PARENT_ALPHA  ///< Actor will blend its alpha with its parents alpha. This means when parent fades in or out child does as well. This is the default. @since_tizen 2.4
};

/**
 * @brief Actor position inheritance mode.
 * @since_tizen 2.4
 */
enum PositionInheritanceMode
{
  INHERIT_PARENT_POSITION,                 ///< Actor will inherit its parent position. This is the default. @since_tizen 2.4
  USE_PARENT_POSITION,                     ///< Actor will copy its parent position. This is useful if many actors are stacked together in the same place. This option ignores parent origin and anchor point. @since_tizen 2.4
  USE_PARENT_POSITION_PLUS_LOCAL_POSITION, ///< Actor will copy its parent position and add local position. This is useful if many actors are stacked together in the same place with an offset.  This option ignores parent origin and anchor point. @since_tizen 2.4
  DONT_INHERIT_POSITION                    ///< Actor will not inherit position. Local position is treated as world position. This is useful if a constraint is used to override local position or if an actor is positioned globally. This option ignores parent origin, anchor point and local position. @since_tizen 2.4
};

/**
 * @brief Dimensions for layout
 * @since_tizen 2.4
 */
namespace Dimension
{
enum Type
{
  WIDTH  = 0x1,       ///< Width dimension @since_tizen 2.4
  HEIGHT = 0x2,       ///< Height dimension @since_tizen 2.4

  ALL_DIMENSIONS = 0x3  ///< Mask to cover all flags @since_tizen 2.4
};

enum Meta
{
  DIMENSION_COUNT = 2  ///< Number of dimensions - update this if adding new dimension @since_tizen 2.4
};
}

/**
 * @brief Size negotiation resize policies
 * @since_tizen 2.4
 */
namespace ResizePolicy
{
enum Type
{
  FIXED,                 ///< Size is fixed as set by SetSize. @since_tizen 2.4
  USE_NATURAL_SIZE,      ///< Size is to use the actor's natural size. @since_tizen 2.4
  FILL_TO_PARENT,        ///< Size is to fill up to the actor's parent's bounds. Aspect ratio is not maintained. @since_tizen 2.4
  SIZE_RELATIVE_TO_PARENT,        ///< The actors size will be ( ParentSize * SizeRelativeToParentFactor ). @since_tizen 2.4
  SIZE_FIXED_OFFSET_FROM_PARENT,  ///< The actors size will be ( ParentSize + SizeRelativeToParentFactor ). @since_tizen 2.4
  FIT_TO_CHILDREN,       ///< Size will adjust to wrap around all children. @since_tizen 2.4
  DIMENSION_DEPENDENCY,  ///< One dimension is dependent on the other. @since_tizen 2.4
  USE_ASSIGNED_SIZE      ///< The size will be assigned to the actor. @since_tizen 2.4
};
const Type DEFAULT = USE_NATURAL_SIZE; ///< Default resize policy
}

/**
 * @brief Policies to determine how an actor should resize itself when having its size set in size negotiation
 * @since_tizen 2.4
 */
namespace SizeScalePolicy
{
enum Type
{
  USE_SIZE_SET,                ///< Use the size that was set. @since_tizen 2.4
  FIT_WITH_ASPECT_RATIO,       ///< Fit within the size set maintaining natural size aspect ratio. @since_tizen 2.4
  FILL_WITH_ASPECT_RATIO       ///< Fill up the size set maintaining natural size aspect ratio. May exceed size bounds in one dimension. @since_tizen 2.4
};
}

/**
 * @brief Horizontal alignment types.
 * @since_tizen 2.4
 */
namespace HorizontalAlignment
{
enum Type
{
  LEFT,         ///< Align horizontally left @since_tizen 2.4
  CENTER,       ///< Align horizontally center @since_tizen 2.4
  RIGHT         ///< Align horiztonally right @since_tizen 2.4
};
}

/**
 * @brief Vertical alignment types.
 * @since_tizen 2.4
 */
namespace VerticalAlignment
{
enum Type
{
  TOP,          ///< Align vertically top @since_tizen 2.4
  CENTER,       ///< Align vertically center @since_tizen 2.4
  BOTTOM        ///< Align vertically bottom @since_tizen 2.4
};
}

/**
 * @}
 */
} // namespace Dali

#endif // __DALI_ACTOR_ENUMERATIONS_H__
