#ifndef _EEXT_FLOATINGBUTTON_EO_LEGACY_H_
#define _EEXT_FLOATINGBUTTON_EO_LEGACY_H_

#ifndef _EEXT_FLOATINGBUTTON_EO_CLASS_TYPE
#define _EEXT_FLOATINGBUTTON_EO_CLASS_TYPE

typedef Eo Eext_Floatingbutton;

#endif

#ifndef _EEXT_FLOATINGBUTTON_EO_TYPES
#define _EEXT_FLOATINGBUTTON_EO_TYPES


#endif

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set the floatingbutton position
 *
 * @remark The floatingbutton can be moved among predefined positions
 * (LEFT_OUT, LEFT, CENTER, RIGHT, RIGHT_OUT),
 * eext_floatingbutton_pos_set() moves floatingbutton to a given position immediately
 * (without animation).
 *
 * @return @c EINA_TRUE on success, @c EINA_FALSE otherwise.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 * @param[in] pos the floatingbutton position
 */
EAPI Eina_Bool eext_floatingbutton_pos_set(Eext_Floatingbutton *obj, Eext_Floatingbutton_Pos pos);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the floatingbutton position
 *
 * @return Floatingbutton position with Eext_Floatingbutton_Pos enumeration
 *
 * @see eext_floatingbutton_pos_set()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 */
EAPI Eext_Floatingbutton_Pos eext_floatingbutton_pos_get(const Eext_Floatingbutton *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set whether floatingbutton can be moved or not.
 *
 * @remark By default, floatingbutton are movable by user interaction.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 * @param[in] block the floatingbutton movability
 */
EAPI void eext_floatingbutton_movement_block_set(Eext_Floatingbutton *obj, Eina_Bool block);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get movability for a given floatingbutton widget.
 *
 * @return @c EINA_TRUE, if @p obj is set to be unmovable,
 * @c EINA_FALSE, if it's @b movable.
 *
 * @see eext_floatingbutton_movement_block_set()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 */
EAPI Eina_Bool eext_floatingbutton_movement_block_get(const Eext_Floatingbutton *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set floatingbutton mode.
 *
 * @remark Positions where floatingbutton can stop are restrained by mode.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 * @param[in] mode floatingbutton mode
 */
EAPI void eext_floatingbutton_mode_set(Eext_Floatingbutton *obj, Eext_Floatingbutton_Mode mode);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get floatingbutton mode.
 *
 * @see eext_floatingbutton_mode_set()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 *
 * @param[in] obj The floatingbutton object
 */
EAPI Eext_Floatingbutton_Mode eext_floatingbutton_mode_get(const Eext_Floatingbutton *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set the floatingbutton position with animation
 *
 * @remark Move floatingbutton similar to eext_floatingbutton_pos_set(),
 * but with animation.
 *
 * @return @c EINA_TRUE on success, @c EINA_FALSE otherwise.
 *
 * @see eext_floatingbutton_pos_set()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Floatingbutton
 * 
 *
 * @param[in] obj The floatingbutton object
 * @param[in] pos the floatingbutton position
 */
EAPI Eina_Bool eext_floatingbutton_pos_bring_in(const Eext_Floatingbutton *obj, Eext_Floatingbutton_Pos pos);

#endif
