#ifndef _ELM_CTXPOPUP_EO_LEGACY_H_
#define _ELM_CTXPOPUP_EO_LEGACY_H_

#ifndef _ELM_CTXPOPUP_EO_CLASS_TYPE
#define _ELM_CTXPOPUP_EO_CLASS_TYPE

typedef Eo Elm_Ctxpopup;

#endif

#ifndef _ELM_CTXPOPUP_EO_TYPES
#define _ELM_CTXPOPUP_EO_TYPES


#endif

/**
 *
 * @brief Change the ctxpopup's orientation to horizontal or vertical.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 * @param[in] horizontal @c EINA_TRUE for horizontal mode, @c EINA_FALSE for vertical
 */
EAPI void elm_ctxpopup_horizontal_set(Elm_Ctxpopup *obj, Eina_Bool horizontal);

/**
 *
 * @brief Get the value of current ctxpopup object's orientation.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return @c EINA_TRUE for horizontal mode, @c EINA_FALSE for vertical mode (or errors)
 *
 * @see elm_ctxpopup_horizontal_set()
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 */
EAPI Eina_Bool elm_ctxpopup_horizontal_get(const Elm_Ctxpopup *obj);

/**
 *
 * @brief Set ctxpopup auto hide mode triggered by ctxpopup policy.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @since 1.9
 *
 * @remark Use this function when user wants ctxpopup not to hide automatically.
 * By default, ctxpopup is dismissed whenever mouse clicked its background area, language is changed,
 * and its parent geometry is updated(changed).
 * Not to hide ctxpopup automatically, disable auto hide function by calling this API,
 * then ctxpopup won't be dismissed in those scenarios.
 *
 * @remark Default value of disabled is @c EINA_FALSE.
 *
 * @see elm_ctxpopup_auto_hide_disabled_get()
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 * @param[in] disabled auto hide enable/disable.
 */
EAPI void elm_ctxpopup_auto_hide_disabled_set(Elm_Ctxpopup *obj, Eina_Bool disabled);

/**
 *
 * @brief Set the Ctxpopup's parent
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark Set the parent object.
 *
 * @remark elm_ctxpopup_add() will automatically call this function
 * with its @c parent argument.
 *
 * @see elm_ctxpopup_add()
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 * @param[in] parent The parent to use
 */
EAPI void elm_ctxpopup_hover_parent_set(Elm_Ctxpopup *obj, Evas_Object *parent);

/**
 *
 * @brief Get the Ctxpopup's parent
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @see elm_ctxpopup_hover_parent_set() for more information
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 */
EAPI Evas_Object *elm_ctxpopup_hover_parent_get(const Elm_Ctxpopup *obj);

/**
 *
 * @brief Set the direction priority of a ctxpopup.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This functions gives a chance to user to set the priority of ctxpopup
 * showing direction. This doesn't guarantee the ctxpopup will appear in the
 * requested direction.
 *
 * @see Elm_Ctxpopup_Direction
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 * @param[in] first 1st priority of direction
 * @param[in] second 2nd priority of direction
 * @param[in] third 3th priority of direction
 * @param[in] fourth 4th priority of direction
 */
EAPI void elm_ctxpopup_direction_priority_set(Elm_Ctxpopup *obj, Elm_Ctxpopup_Direction first, Elm_Ctxpopup_Direction second, Elm_Ctxpopup_Direction third, Elm_Ctxpopup_Direction fourth);

/**
 *
 * @brief Get the direction priority of a ctxpopup.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @see elm_ctxpopup_direction_priority_set() for more information.
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 * @param[out] first 1st priority of direction
 * @param[out] second 2nd priority of direction
 * @param[out] third 3th priority of direction
 * @param[out] fourth 4th priority of direction
 */
EAPI void elm_ctxpopup_direction_priority_get(const Elm_Ctxpopup *obj, Elm_Ctxpopup_Direction *first, Elm_Ctxpopup_Direction *second, Elm_Ctxpopup_Direction *third, Elm_Ctxpopup_Direction *fourth);

/**
 *
 * @brief Get the current direction of a ctxpopup.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return current direction of a ctxpopup
 * (If getting the current direction is failed, it returns #ELM_CTXPOPUP_DIRECTION_UNKNOWN)
 *
 * @warning Once the ctxpopup showed up, the direction would be determined
 *
 * @ingroup Ctxpopup
 *
 * @param[in] obj The elm ctxpopup object
 */
EAPI Elm_Ctxpopup_Direction elm_ctxpopup_direction_get(const Elm_Ctxpopup *obj);

/**
 *
 * @brief Dismiss a ctxpopup object
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Ctxpopup
 *
 * @remark Use this function to simulate clicking outside of the ctxpopup to dismiss it.
 * In this way, the ctxpopup will be hidden and the "clicked" signal will be
 * emitted.
 * 
 *
 * @param[in] obj The elm ctxpopup object
 */
EAPI void elm_ctxpopup_dismiss(Elm_Ctxpopup *obj);

/**
 *
 * @brief Clear all items in the given ctxpopup object.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Ctxpopup
 * 
 *
 * @param[in] obj The elm ctxpopup object
 */
EAPI void elm_ctxpopup_clear(Elm_Ctxpopup *obj);

/**
 *
 * @brief Add a new item to a ctxpopup object.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return A handle to the item added or @c NULL, on errors
 *
 * @warning Ctxpopup can't hold both an item list and a content at the same
 * time. When an item is added, any previous content will be removed.
 *
 * @see elm_object_content_set()
 *
 * @ingroup Ctxpopup
 * 
 *
 * @param[in] obj The elm ctxpopup object
 * @param[in] label The Label of the new item
 * @param[in] icon Icon to be set on new item
 * @param[in] func Convenience function called when item selected
 * @param[in] data Data passed to @p func
 */
EAPI Elm_Object_Item *elm_ctxpopup_item_append(Elm_Ctxpopup *obj, const char *label, Evas_Object *icon, Evas_Smart_Cb func, const void *data);

#endif
