/*
 * Video for Linux Two header file for samsung
 *
 * Copyright (C) 2009, Dongsoo Nathaniel Kim<dongsoo45.kim@samsung.com>
 *
 * This header file contains several v4l2 APIs to be proposed to v4l2
 * community and until bein accepted, will be used restrictly in Samsung's
 * camera interface driver FIMC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __LINUX_VIDEODEV2_SAMSUNG_H
#define __LINUX_VIDEODEV2_SAMSUNG_H

/* Values for 'capabilities' field */
/* Object detection device */
#define V4L2_CAP_OBJ_RECOGNITION	0x10000000
/* strobe control */
#define V4L2_CAP_STROBE			0x20000000

#define V4L2_CID_FOCUS_MODE		(V4L2_CID_CAMERA_CLASS_BASE+17)
/* Focus Methods */
enum v4l2_focus_mode {
	V4L2_FOCUS_MODE_AUTO		= 0,
	V4L2_FOCUS_MODE_MACRO		= 1,
	V4L2_FOCUS_MODE_MANUAL		= 2,
	V4L2_FOCUS_MODE_LASTP		= 2,
};

#define V4L2_CID_ZOOM_MODE		(V4L2_CID_CAMERA_CLASS_BASE+18)
/* Zoom Methods */
enum v4l2_zoom_mode {
	V4L2_ZOOM_MODE_CONTINUOUS	= 0,
	V4L2_ZOOM_MODE_OPTICAL		= 1,
	V4L2_ZOOM_MODE_DIGITAL		= 2,
	V4L2_ZOOM_MODE_LASTP		= 2,
};

/* Exposure Methods */
#define V4L2_CID_PHOTOMETRY		(V4L2_CID_CAMERA_CLASS_BASE+19)
enum v4l2_photometry_mode {
	V4L2_PHOTOMETRY_MULTISEG	= 0, /*Multi Segment*/
	V4L2_PHOTOMETRY_CWA		= 1, /*Centre Weighted Average*/
	V4L2_PHOTOMETRY_SPOT		= 2,
	V4L2_PHOTOMETRY_AFSPOT		= 3, /*Spot metering on focused point*/
	V4L2_PHOTOMETRY_LASTP		= V4L2_PHOTOMETRY_AFSPOT,
};

/* Manual exposure control items menu type: iris, shutter, iso */
#define V4L2_CID_CAM_APERTURE	(V4L2_CID_CAMERA_CLASS_BASE+20)
enum v4l2_aperture_mode {
	APERTURE_F_AUTO = 0,
	APERTURE_F_2_8,
	APERTURE_F_3_2,
	APERTURE_F_3_6,
	APERTURE_F_4_0,
	APERTURE_F_4_5,
	APERTURE_F_5_1,
	APERTURE_F_5_7,
	APERTURE_F_6_4,
	APERTURE_F_7_2,
	APERTURE_MAX,
};
#define V4L2_CID_CAM_SHUTTER	(V4L2_CID_CAMERA_CLASS_BASE+21)
#define V4L2_CID_CAM_ISO	(V4L2_CID_CAMERA_CLASS_BASE+22)

/* Following CIDs are menu type */
#define V4L2_CID_SCENEMODE	(V4L2_CID_CAMERA_CLASS_BASE+23)
#define V4L2_CID_CAM_STABILIZE	(V4L2_CID_CAMERA_CLASS_BASE+24)
#define V4L2_CID_CAM_MULTISHOT	(V4L2_CID_CAMERA_CLASS_BASE+25)

/* Control dynamic range */
#define V4L2_CID_CAM_DR		(V4L2_CID_CAMERA_CLASS_BASE+26)

/* White balance preset control */
#define V4L2_CID_WHITE_BALANCE_PRESET (V4L2_CID_CAMERA_CLASS_BASE+27)
#define V4L2_CID_CAM_SENSOR_FW_VER (V4L2_CID_CAMERA_CLASS_BASE + 28)
#define V4L2_CID_CAM_PHONE_FW_VER (V4L2_CID_CAMERA_CLASS_BASE + 29)

/* CID extensions */
#define V4L2_CID_ROTATION		(V4L2_CID_PRIVATE_BASE + 0)
#define V4L2_CID_PADDR_Y		(V4L2_CID_PRIVATE_BASE + 1)
#define V4L2_CID_PADDR_CB		(V4L2_CID_PRIVATE_BASE + 2)
#define V4L2_CID_PADDR_CR		(V4L2_CID_PRIVATE_BASE + 3)
#define V4L2_CID_PADDR_CBCR		(V4L2_CID_PRIVATE_BASE + 4)
#define V4L2_CID_OVERLAY_AUTO		(V4L2_CID_PRIVATE_BASE + 5)
#define V4L2_CID_OVERLAY_VADDR0		(V4L2_CID_PRIVATE_BASE + 6)
#define V4L2_CID_OVERLAY_VADDR1		(V4L2_CID_PRIVATE_BASE + 7)
#define V4L2_CID_OVERLAY_VADDR2		(V4L2_CID_PRIVATE_BASE + 8)
#define V4L2_CID_OVLY_MODE		(V4L2_CID_PRIVATE_BASE + 9)
#define V4L2_CID_DST_INFO		(V4L2_CID_PRIVATE_BASE + 10)
/* UMP secure id control */
#define V4L2_CID_GET_UMP_SECURE_ID	(V4L2_CID_PRIVATE_BASE + 11)
#define V4L2_CID_GET_PHY_SRC_YADDR	(V4L2_CID_PRIVATE_BASE + 12)
#define V4L2_CID_GET_PHY_SRC_CADDR	(V4L2_CID_PRIVATE_BASE + 13)
#define V4L2_CID_IMAGE_EFFECT_FN	(V4L2_CID_PRIVATE_BASE + 16)
#define V4L2_CID_IMAGE_EFFECT_APPLY	(V4L2_CID_PRIVATE_BASE + 17)
#define V4L2_CID_IMAGE_EFFECT_CB	(V4L2_CID_PRIVATE_BASE + 18)
#define V4L2_CID_IMAGE_EFFECT_CR	(V4L2_CID_PRIVATE_BASE + 19)
#define V4L2_CID_RESERVED_MEM_BASE_ADDR	(V4L2_CID_PRIVATE_BASE + 20)
#define V4L2_CID_FIMC_VERSION		(V4L2_CID_PRIVATE_BASE + 21)

#define V4L2_CID_CACHE_FLUSH		(V4L2_CID_PRIVATE_BASE + 61)
#define V4L2_CID_RESERVED_MEM_SIZE	(V4L2_CID_PRIVATE_BASE + 63)
#define V4L2_CID_STREAM_PAUSE			(V4L2_CID_PRIVATE_BASE + 53)
#define V4L2_CID_CACHE_FLUSH			(V4L2_CID_PRIVATE_BASE + 61)
#define V4L2_CID_RESERVED_MEM_SIZE		(V4L2_CID_PRIVATE_BASE + 63)

/* CID Extensions for camera sensor operations */
#define V4L2_CID_CAM_PREVIEW_ONOFF		(V4L2_CID_PRIVATE_BASE + 64)
#define V4L2_CID_CAM_CAPTURE			(V4L2_CID_PRIVATE_BASE + 65)
/* #define V4L2_CID_CAM_JPEG_MEMSIZE	(V4L2_CID_PRIVATE_BASE + 66) */

#define V4L2_CID_CAM_DATE_INFO_YEAR		(V4L2_CID_PRIVATE_BASE + 14)
#define V4L2_CID_CAM_DATE_INFO_MONTH		(V4L2_CID_PRIVATE_BASE + 15)
#define V4L2_CID_CAM_DATE_INFO_DATE		(V4L2_CID_PRIVATE_BASE + 22)
#define V4L2_CID_CAM_SENSOR_VER			(V4L2_CID_PRIVATE_BASE + 23)
#define V4L2_CID_CAM_FW_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 24)
#define V4L2_CID_CAM_FW_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 25)
#define V4L2_CID_CAM_PRM_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 26)
#define V4L2_CID_CAM_PRM_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 27)
#define V4L2_CID_CAM_FW_VER			(V4L2_CID_PRIVATE_BASE + 28)
#define V4L2_CID_CAM_SET_FW_ADDR		(V4L2_CID_PRIVATE_BASE + 29)
#define V4L2_CID_CAM_SET_FW_SIZE		(V4L2_CID_PRIVATE_BASE + 30)
#define V4L2_CID_CAM_UPDATE_FW	(V4L2_CID_PRIVATE_BASE + 31)
enum v4l2_firmware_mode {
	FW_MODE_NONE,
	FW_MODE_VERSION,
	FW_MODE_UPDATE,
	FW_MODE_DUMP,
};

#define V4L2_CID_CAM_JPEG_MAIN_SIZE		(V4L2_CID_PRIVATE_BASE + 32)
#define V4L2_CID_CAM_JPEG_MAIN_OFFSET		(V4L2_CID_PRIVATE_BASE + 33)
#define V4L2_CID_CAM_JPEG_THUMB_SIZE		(V4L2_CID_PRIVATE_BASE + 34)
#define V4L2_CID_CAM_JPEG_THUMB_OFFSET		(V4L2_CID_PRIVATE_BASE + 35)
#define V4L2_CID_CAM_JPEG_POSTVIEW_OFFSET	(V4L2_CID_PRIVATE_BASE + 36)
#define V4L2_CID_CAM_JPEG_QUALITY	(V4L2_CID_PRIVATE_BASE + 37)
#define V4L2_CID_CAM_SENSOR_MAKER	(V4L2_CID_PRIVATE_BASE + 38)
#define V4L2_CID_CAM_SENSOR_OPTICAL	(V4L2_CID_PRIVATE_BASE + 39)
#define V4L2_CID_CAM_AF_VER_LOW		(V4L2_CID_PRIVATE_BASE + 40)
#define V4L2_CID_CAM_AF_VER_HIGH	(V4L2_CID_PRIVATE_BASE + 41)
#define V4L2_CID_CAM_GAMMA_RG_LOW	(V4L2_CID_PRIVATE_BASE + 42)
#define V4L2_CID_CAM_GAMMA_RG_HIGH	(V4L2_CID_PRIVATE_BASE + 43)
#define V4L2_CID_CAM_GAMMA_BG_LOW	(V4L2_CID_PRIVATE_BASE + 44)
#define V4L2_CID_CAM_GAMMA_BG_HIGH	(V4L2_CID_PRIVATE_BASE + 45)
#define V4L2_CID_CAM_DUMP_FW		(V4L2_CID_PRIVATE_BASE + 46)
#define V4L2_CID_CAM_GET_DUMP_SIZE  (V4L2_CID_PRIVATE_BASE + 47)
#define V4L2_CID_CAMERA_VT_MODE		(V4L2_CID_PRIVATE_BASE + 48)
enum cam_vt_mode {
	CAM_VT_MODE_NONE ,
	CAM_VT_MODE_3G ,
	CAM_VT_MODE_VOIP ,
};

#define V4L2_CID_CAMERA_VGA_BLUR	(V4L2_CID_PRIVATE_BASE + 49)
#define V4L2_CID_CAMERA_CAPTURE		(V4L2_CID_PRIVATE_BASE + 50)
#define V4L2_CID_CAMERA_HDR (V4L2_CID_PRIVATE_BASE + 51)
#define V4L2_CID_CAMERA_HYBRID		(V4L2_CID_PRIVATE_BASE + 52)

#define V4L2_CID_MAIN_SW_DATE_INFO_YEAR		(V4L2_CID_PRIVATE_BASE + 54)
#define V4L2_CID_MAIN_SW_DATE_INFO_MONTH	(V4L2_CID_PRIVATE_BASE + 55)
#define V4L2_CID_MAIN_SW_DATE_INFO_DATE		(V4L2_CID_PRIVATE_BASE + 56)
#define V4L2_CID_MAIN_SW_FW_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 57)
#define V4L2_CID_MAIN_SW_FW_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 58)
#define V4L2_CID_MAIN_SW_PRM_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 59)
#define V4L2_CID_MAIN_SW_PRM_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 60)
#define V4L2_CID_CAM_JPEG_POSTVIEW_SIZE		(V4L2_CID_PRIVATE_BASE + 61)
#define V4L2_CID_CAMERA_HYBRID_CAPTURE		(V4L2_CID_PRIVATE_BASE + 62)
#define V4L2_CID_CAMERA_FAST_MODE		(V4L2_CID_PRIVATE_BASE + 66)
enum cam_fast_mode {
	FAST_MODE_SUBSAMPLING_NONE ,
	FAST_MODE_SUBSAMPLING_HALF ,
	FAST_MODE_SUBSAMPLING_QUARTER ,
};
#define V4L2_CID_CAMERA_POSTVIEW_CAPTURE	(V4L2_CID_PRIVATE_BASE + 67)
#define V4L2_CID_CAMERA_CAPTURE_MODE		(V4L2_CID_PRIVATE_BASE + 68)
#define V4L2_CID_CAMERA_YUV_CAPTURE (V4L2_CID_PRIVATE_BASE + 69)

#define V4L2_CID_FIMC_IS_BASE			(V4L2_CTRL_CLASS_CAMERA | 0x1000)
#define V4L2_CID_FIMC_IS_TUNE_BASE		(V4L2_CTRL_CLASS_CAMERA | 0x2000)
#define V4L2_CID_FIMC_IS_ISP_DBG_BASE	(V4L2_CTRL_CLASS_CAMERA | 0x3000)

#define V4L2_CID_IS_LOAD_FW			(V4L2_CID_FIMC_IS_BASE + 10)
#define V4L2_CID_IS_INIT_PARAM			(V4L2_CID_FIMC_IS_BASE + 11)
#define V4L2_CID_IS_RESET			(V4L2_CID_FIMC_IS_BASE + 12)
#define V4L2_CID_IS_S_POWER			(V4L2_CID_FIMC_IS_BASE + 13)
enum is_set_power {
	IS_POWER_OFF,
	IS_POWER_ON
};

#define V4L2_CID_IS_S_STREAM			(V4L2_CID_FIMC_IS_BASE + 14)
enum is_set_stream {
	IS_DISABLE_STREAM,
	IS_ENABLE_STREAM
};

#define V4L2_CID_IS_S_SCENARIO_MODE		(V4L2_CID_FIMC_IS_BASE + 15)
#define V4L2_CID_IS_S_FORMAT_SCENARIO		(V4L2_CID_FIMC_IS_BASE + 16)
enum scenario_mode {
	IS_MODE_PREVIEW_STILL,
	IS_MODE_PREVIEW_VIDEO,
	IS_MODE_CAPTURE_STILL,
	IS_MODE_CAPTURE_VIDEO,
	IS_MODE_MAX
};

/* global */
#define V4L2_CID_IS_CAMERA_SHOT_MODE_NORMAL	(V4L2_CID_FIMC_IS_BASE + 400)
/* value : 1 : single shot , >=2 : continuous shot */

#define V4L2_CID_IS_CAMERA_SENSOR_NUM		(V4L2_CID_FIMC_IS_BASE + 201)

#define V4L2_CID_IS_CAMERA_FOCUS_MODE		(V4L2_CID_FIMC_IS_BASE + 401)
enum is_focus_mode {
	IS_FOCUS_MODE_AUTO,
	IS_FOCUS_MODE_MACRO,
	IS_FOCUS_MODE_INFINITY,
	IS_FOCUS_MODE_CONTINUOUS,
	IS_FOCUS_MODE_TOUCH,
	IS_FOCUS_MODE_FACEDETECT,
	IS_FOCUS_MODE_IDLE,
	IS_FOCUS_MODE_MAX,
};

#define V4L2_CID_IS_CAMERA_FLASH_MODE		(V4L2_CID_FIMC_IS_BASE + 402)
enum is_flash_mode {
	IS_FLASH_MODE_OFF,
	IS_FLASH_MODE_AUTO,
	IS_FLASH_MODE_AUTO_REDEYE,
	IS_FLASH_MODE_ON,
	IS_FLASH_MODE_TORCH,
	IS_FLASH_MODE_MAX
};

#define V4L2_CID_IS_CAMERA_AWB_MODE		(V4L2_CID_FIMC_IS_BASE + 403)
enum is_awb_mode {
	IS_AWB_AUTO,
	IS_AWB_DAYLIGHT,
	IS_AWB_CLOUDY,
	IS_AWB_TUNGSTEN,
	IS_AWB_FLUORESCENT,
	IS_AWB_MAX
};

#define V4L2_CID_IS_CAMERA_IMAGE_EFFECT		(V4L2_CID_FIMC_IS_BASE + 404)
enum is_image_effect {
	IS_IMAGE_EFFECT_DISABLE,
	IS_IMAGE_EFFECT_MONOCHROME,
	IS_IMAGE_EFFECT_NEGATIVE_MONO,
	IS_IMAGE_EFFECT_NEGATIVE_COLOR,
	IS_IMAGE_EFFECT_SEPIA,
	IS_IMAGE_EFFECT_SEPIA_CB,
	IS_IMAGE_EFFECT_SEPIA_CR,
	IS_IMAGE_EFFECT_NEGATIVE,
	IS_IMAGE_EFFECT_ARTFREEZE,
	IS_IMAGE_EFFECT_EMBOSSING,
	IS_IMAGE_EFFECT_SILHOUETTE,
	IS_IMAGE_EFFECT_MAX
};

#define V4L2_CID_IS_CAMERA_ISO			(V4L2_CID_FIMC_IS_BASE + 405)
enum is_iso {
	IS_ISO_AUTO,
	IS_ISO_50,
	IS_ISO_100,
	IS_ISO_200,
	IS_ISO_400,
	IS_ISO_800,
	IS_ISO_1600,
	IS_ISO_MAX
};

#define V4L2_CID_IS_CAMERA_CONTRAST		(V4L2_CID_FIMC_IS_BASE + 406)
enum is_contrast {
	IS_CONTRAST_AUTO,
	IS_CONTRAST_MINUS_2,
	IS_CONTRAST_MINUS_1,
	IS_CONTRAST_DEFAULT,
	IS_CONTRAST_PLUS_1,
	IS_CONTRAST_PLUS_2,
	IS_CONTRAST_MAX
};

#define V4L2_CID_IS_CAMERA_SATURATION		(V4L2_CID_FIMC_IS_BASE + 407)
enum is_saturation {
	IS_SATURATION_MINUS_2,
	IS_SATURATION_MINUS_1,
	IS_SATURATION_DEFAULT,
	IS_SATURATION_PLUS_1,
	IS_SATURATION_PLUS_2,
	IS_SATURATION_MAX
};

#define V4L2_CID_IS_CAMERA_SHARPNESS		(V4L2_CID_FIMC_IS_BASE + 408)
enum is_sharpness {
	IS_SHARPNESS_MINUS_2,
	IS_SHARPNESS_MINUS_1,
	IS_SHARPNESS_DEFAULT,
	IS_SHARPNESS_PLUS_1,
	IS_SHARPNESS_PLUS_2,
	IS_SHARPNESS_MAX
};

#define V4L2_CID_IS_CAMERA_EXPOSURE		(V4L2_CID_FIMC_IS_BASE + 409)
enum is_exposure {
	IS_EXPOSURE_MINUS_4,
	IS_EXPOSURE_MINUS_3,
	IS_EXPOSURE_MINUS_2,
	IS_EXPOSURE_MINUS_1,
	IS_EXPOSURE_DEFAULT,
	IS_EXPOSURE_PLUS_1,
	IS_EXPOSURE_PLUS_2,
	IS_EXPOSURE_PLUS_3,
	IS_EXPOSURE_PLUS_4,
	IS_EXPOSURE_MAX
};

#define V4L2_CID_IS_CAMERA_BRIGHTNESS		(V4L2_CID_FIMC_IS_BASE + 410)
enum is_brightness {
	IS_BRIGHTNESS_MINUS_2,
	IS_BRIGHTNESS_MINUS_1,
	IS_BRIGHTNESS_DEFAULT,
	IS_BRIGHTNESS_PLUS_1,
	IS_BRIGHTNESS_PLUS_2,
	IS_BRIGHTNESS_MAX
};

#define V4L2_CID_IS_CAMERA_HUE			(V4L2_CID_FIMC_IS_BASE + 411)
enum is_hue {
	IS_HUE_MINUS_2,
	IS_HUE_MINUS_1,
	IS_HUE_DEFAULT,
	IS_HUE_PLUS_1,
	IS_HUE_PLUS_2,
	IS_HUE_MAX
};

#define V4L2_CID_IS_CAMERA_METERING		(V4L2_CID_FIMC_IS_BASE + 412)
enum is_metering {
	IS_METERING_AVERAGE,
	IS_METERING_SPOT,
	IS_METERING_MATRIX,
	IS_METERING_CENTER,
	IS_METERING_MAX
};
#define V4L2_CID_IS_CAMERA_METERING_POSITION_X	(V4L2_CID_FIMC_IS_BASE + 500)
#define V4L2_CID_IS_CAMERA_METERING_POSITION_Y	(V4L2_CID_FIMC_IS_BASE + 501)
#define V4L2_CID_IS_CAMERA_METERING_WINDOW_X	(V4L2_CID_FIMC_IS_BASE + 502)
#define V4L2_CID_IS_CAMERA_METERING_WINDOW_Y	(V4L2_CID_FIMC_IS_BASE + 503)

#define V4L2_CID_IS_CAMERA_AFC_MODE		(V4L2_CID_FIMC_IS_BASE + 413)
enum is_afc_mode {
	IS_AFC_DISABLE,
	IS_AFC_AUTO,
	IS_AFC_MANUAL_50HZ,
	IS_AFC_MANUAL_60HZ,
	IS_AFC_MAX
};

#define V4L2_CID_IS_AWB_LOCK_UNLOCK		(V4L2_CID_FIMC_IS_BASE + 496)
enum is_awb_lock_unlock {
	IS_AWB_LOCK,
	IS_AWB_UNLOCK,
	IS_AWB_LOCK_UNLOCK_MAX
};

#define V4L2_CID_IS_AE_LOCK_UNLOCK		(V4L2_CID_FIMC_IS_BASE + 497)
enum is_ae_lock_unlock {
	IS_AE_LOCK,
	IS_AE_UNLOCK,
	IS_AE_LOCK_UNLOCK_MAX
};

#define V4L2_CID_IS_FD_GET_FACE_COUNT			(V4L2_CID_FIMC_IS_BASE + 600)
#define V4L2_CID_IS_FD_GET_FACE_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 601)
#define V4L2_CID_IS_FD_GET_FACE_CONFIDENCE		(V4L2_CID_FIMC_IS_BASE + 602)
#define V4L2_CID_IS_FD_GET_FACE_SMILE_LEVEL		(V4L2_CID_FIMC_IS_BASE + 603)
#define V4L2_CID_IS_FD_GET_FACE_BLINK_LEVEL		(V4L2_CID_FIMC_IS_BASE + 604)
#define V4L2_CID_IS_FD_GET_FACE_TOPLEFT_X		(V4L2_CID_FIMC_IS_BASE + 605)
#define V4L2_CID_IS_FD_GET_FACE_TOPLEFT_Y		(V4L2_CID_FIMC_IS_BASE + 606)
#define V4L2_CID_IS_FD_GET_FACE_BOTTOMRIGHT_X		(V4L2_CID_FIMC_IS_BASE + 607)
#define V4L2_CID_IS_FD_GET_FACE_BOTTOMRIGHT_Y		(V4L2_CID_FIMC_IS_BASE + 608)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_TOPLEFT_X		(V4L2_CID_FIMC_IS_BASE + 609)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_TOPLEFT_Y		(V4L2_CID_FIMC_IS_BASE + 610)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_BOTTOMRIGHT_X	(V4L2_CID_FIMC_IS_BASE + 611)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_BOTTOMRIGHT_Y	(V4L2_CID_FIMC_IS_BASE + 612)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_TOPLEFT_X		(V4L2_CID_FIMC_IS_BASE + 613)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_TOPLEFT_Y		(V4L2_CID_FIMC_IS_BASE + 614)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_BOTTOMRIGHT_X	(V4L2_CID_FIMC_IS_BASE + 615)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_BOTTOMRIGHT_Y	(V4L2_CID_FIMC_IS_BASE + 616)
#define V4L2_CID_IS_FD_GET_MOUTH_TOPLEFT_X		(V4L2_CID_FIMC_IS_BASE + 617)
#define V4L2_CID_IS_FD_GET_MOUTH_TOPLEFT_Y		(V4L2_CID_FIMC_IS_BASE + 618)
#define V4L2_CID_IS_FD_GET_MOUTH_BOTTOMRIGHT_X		(V4L2_CID_FIMC_IS_BASE + 619)
#define V4L2_CID_IS_FD_GET_MOUTH_BOTTOMRIGHT_Y		(V4L2_CID_FIMC_IS_BASE + 620)
#define V4L2_CID_IS_FD_GET_ANGLE			(V4L2_CID_FIMC_IS_BASE + 621)
#define V4L2_CID_IS_FD_GET_YAW_ANGLE			(V4L2_CID_FIMC_IS_BASE + 622)
#define V4L2_CID_IS_FD_GET_NEXT				(V4L2_CID_FIMC_IS_BASE + 623)
#define V4L2_CID_IS_FD_GET_DATA				(V4L2_CID_FIMC_IS_BASE + 624)

#define V4L2_CID_IS_FD_SET_MAX_FACE_NUMBER		(V4L2_CID_FIMC_IS_BASE + 650)
#define V4L2_CID_IS_FD_SET_ROLL_ANGLE			(V4L2_CID_FIMC_IS_BASE + 651)

enum is_fd_roll_angle {
	/* 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_BASIC		= 0,
	/* 0, 30, 0, -30, 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_PRECISE_BASIC	= 1,
	/* 0, 90, 0, -90 */
	IS_FD_ROLL_ANGLE_SIDES		= 2,
	/* 0, 90, 0, -90 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_PRECISE_SIDES	= 3,
	/* 0, 90, 0, -90, 0, 180 */
	IS_FD_ROLL_ANGLE_FULL		= 4,
	/* 0, 90, 0, -90, 0, 180, 0, 135, 0, -135 */
	IS_FD_ROLL_ANGLE_PRECISE_FULL	= 5,
};

#define V4L2_CID_IS_FD_SET_YAW_ANGLE	(V4L2_CID_FIMC_IS_BASE + 652)
enum is_fd_yaw_angle {
	IS_FD_YAW_ANGLE_0	= 0,
	IS_FD_YAW_ANGLE_45	= 1,
	IS_FD_YAW_ANGLE_90	= 2,
	IS_FD_YAW_ANGLE_45_90	= 3,
};

#define V4L2_CID_IS_FD_SET_SMILE_MODE	(V4L2_CID_FIMC_IS_BASE + 653)
enum is_fd_smile_mode {
	IS_FD_SMILE_MODE_DISABLE	= 0,
	IS_FD_SMILE_MODE_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_BLINK_MODE	(V4L2_CID_FIMC_IS_BASE + 654)
enum is_fd_blink_mode {
	IS_FD_BLINK_MODE_DISABLE	= 0,
	IS_FD_BLINK_MODE_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_EYE_DETECT_MODE	(V4L2_CID_FIMC_IS_BASE + 655)
enum is_fd_eye_detect_mode {
	IS_FD_EYE_DETECT_DISABLE	= 0,
	IS_FD_EYE_DETECT_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_MOUTH_DETECT_MODE	(V4L2_CID_FIMC_IS_BASE + 656)
enum is_fd_mouth_detect_mode {
	IS_FD_MOUTH_DETECT_DISABLE	= 0,
	IS_FD_MOUTH_DETECT_ENABLE	= 1,
};

#define V4L2_CID_IS_FD_SET_ORIENTATION_MODE  (V4L2_CID_FIMC_IS_BASE + 657)
enum is_fd_orientation_mode {
	IS_FD_ORIENTATION_DISABLE	= 0,
	IS_FD_ORIENTATION_ENABLE	= 1,
};

#define V4L2_CID_IS_FD_SET_ORIENTATION	(V4L2_CID_FIMC_IS_BASE + 658)
#define V4L2_CID_IS_FD_SET_DATA_ADDRESS	(V4L2_CID_FIMC_IS_BASE + 659)

#define V4L2_CID_IS_SET_ISP			(V4L2_CID_FIMC_IS_BASE + 440)
enum is_isp_bypass_mode {
	IS_ISP_BYPASS_DISABLE,
	IS_ISP_BYPASS_ENABLE,
	IS_ISP_BYPASS_MAX
};

#define V4L2_CID_IS_SET_DRC			(V4L2_CID_FIMC_IS_BASE + 441)
enum is_drc_bypass_mode {
	IS_DRC_BYPASS_DISABLE,
	IS_DRC_BYPASS_ENABLE,
	IS_DRC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_FD			(V4L2_CID_FIMC_IS_BASE + 442)
enum is_fd_bypass_mode {
	IS_FD_BYPASS_DISABLE,
	IS_FD_BYPASS_ENABLE,
	IS_FD_BYPASS_MAX
};

#define V4L2_CID_IS_SET_ODC			(V4L2_CID_FIMC_IS_BASE + 443)
enum is_odc_bypass_mode {
	IS_ODC_BYPASS_DISABLE,
	IS_ODC_BYPASS_ENABLE,
	IS_ODC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_DIS			(V4L2_CID_FIMC_IS_BASE + 444)
enum is_dis_bypass_mode {
	IS_DIS_BYPASS_DISABLE,
	IS_DIS_BYPASS_ENABLE,
	IS_DIS_BYPASS_MAX
};

#define V4L2_CID_IS_SET_3DNR			(V4L2_CID_FIMC_IS_BASE + 445)
enum is_tdnr_bypass_mode {
	IS_TDNR_BYPASS_DISABLE,
	IS_TDNR_BYPASS_ENABLE,
	IS_TDNR_BYPASS_MAX
};

#define V4L2_CID_IS_SET_SCALERC			(V4L2_CID_FIMC_IS_BASE + 446)
enum is_scalerc_bypass_mode {
	IS_SCALERC_BYPASS_DISABLE,
	IS_SCALERC_BYPASS_ENABLE,
	IS_SCALERC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_SCALERP			(V4L2_CID_FIMC_IS_BASE + 446)
enum is_scalerp_bypass_mode {
	IS_SCALERP_BYPASS_DISABLE,
	IS_SCALERP_BYPASS_ENABLE,
	IS_SCALERP_BYPASS_MAX
};

#define V4L2_CID_IS_ROTATION_MODE		(V4L2_CID_FIMC_IS_BASE + 450)
enum is_rotation_mode {
	IS_ROTATION_0,
	IS_ROTATION_90,
	IS_ROTATION_180,
	IS_ROTATION_270,
	IS_ROTATION_MAX
};

#define V4L2_CID_IS_3DNR_1ST_FRAME_MODE		(V4L2_CID_FIMC_IS_BASE + 451)
enum is_tdnr_1st_frame_mode {
	IS_TDNR_1ST_FRAME_NOPROCESSING,
	IS_TDNR_1ST_FRAME_2DNR,
	IS_TDNR_MAX
};

#define V4L2_CID_IS_CAMERA_OBJECT_POSITION_X	(V4L2_CID_FIMC_IS_BASE + 452)
#define V4L2_CID_IS_CAMERA_OBJECT_POSITION_Y	(V4L2_CID_FIMC_IS_BASE + 453)
#define V4L2_CID_IS_CAMERA_WINDOW_SIZE_X	(V4L2_CID_FIMC_IS_BASE + 454)
#define V4L2_CID_IS_CAMERA_WINDOW_SIZE_Y	(V4L2_CID_FIMC_IS_BASE + 455)

#define V4L2_CID_IS_CAMERA_EXIF_EXPTIME		(V4L2_CID_FIMC_IS_BASE + 456)
#define V4L2_CID_IS_CAMERA_EXIF_FLASH		(V4L2_CID_FIMC_IS_BASE + 457)
#define V4L2_CID_IS_CAMERA_EXIF_ISO		(V4L2_CID_FIMC_IS_BASE + 458)
#define V4L2_CID_IS_CAMERA_EXIF_SHUTTERSPEED	(V4L2_CID_FIMC_IS_BASE + 459)
#define V4L2_CID_IS_CAMERA_EXIF_BRIGHTNESS	(V4L2_CID_FIMC_IS_BASE + 460)

#define V4L2_CID_IS_CAMERA_ISP_SEL_INPUT	(V4L2_CID_FIMC_IS_BASE + 461)
enum is_isp_sel_input {
	IS_ISP_INPUT_OTF,
	IS_ISP_INPUT_DMA1,
	IS_ISP_INPUT_DMA2,
	IS_ISP_INPUT_DMA12,
	IS_ISP_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_ISP_SEL_OUTPUT	(V4L2_CID_FIMC_IS_BASE + 462)
enum is_isp_sel_output {
	IS_ISP_OUTPUT_OTF,
	IS_ISP_OUTPUT_DMA1,
	IS_ISP_OUTPUT_DMA2,
	IS_ISP_OUTPUT_DMA12,
	IS_ISP_OUTPUT_OTF_DMA1,
	IS_ISP_OUTPUT_OTF_DMA2,
	IS_ISP_OUTPUT_OTF_DMA12,
	IS_ISP_OUTPUT_MAX
};

#define V4L2_CID_IS_CAMERA_DRC_SEL_INPUT	(V4L2_CID_FIMC_IS_BASE + 463)
enum is_drc_sel_input {
	IS_DRC_INPUT_OTF,
	IS_DRC_INPUT_DMA,
	IS_DRC_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_FD_SEL_INPUT		(V4L2_CID_FIMC_IS_BASE + 464)
enum is_fd_sel_input {
	IS_FD_INPUT_OTF,
	IS_FD_INPUT_DMA,
	IS_FD_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_INIT_WIDTH		(V4L2_CID_FIMC_IS_BASE + 465)
#define V4L2_CID_IS_CAMERA_INIT_HEIGHT		(V4L2_CID_FIMC_IS_BASE + 466)

#define V4L2_CID_IS_CMD_ISP			(V4L2_CID_FIMC_IS_BASE + 467)
enum is_isp_cmd_mode {
	IS_ISP_COMMAND_STOP,
	IS_ISP_COMMAND_START,
	IS_ISP_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_DRC			(V4L2_CID_FIMC_IS_BASE + 468)
enum is_drc_cmd_mode {
	IS_DRC_COMMAND_STOP,
	IS_DRC_COMMAND_START,
	IS_DRC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_FD			(V4L2_CID_FIMC_IS_BASE + 469)
enum is_fd_cmd_mode {
	IS_FD_COMMAND_STOP,
	IS_FD_COMMAND_START,
	IS_FD_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_ODC			(V4L2_CID_FIMC_IS_BASE + 470)
enum is_odc_cmd_mode {
	IS_ODC_COMMAND_STOP,
	IS_ODC_COMMAND_START,
	IS_ODC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_DIS			(V4L2_CID_FIMC_IS_BASE + 471)
enum is_dis_cmd_mode {
	IS_DIS_COMMAND_STOP,
	IS_DIS_COMMAND_START,
	IS_DIS_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_TDNR			(V4L2_CID_FIMC_IS_BASE + 472)
enum is_tdnr_cmd_mode {
	IS_TDNR_COMMAND_STOP,
	IS_TDNR_COMMAND_START,
	IS_TDNR_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_SCALERC			(V4L2_CID_FIMC_IS_BASE + 473)
enum is_scalerc_cmd_mode {
	IS_SCALERC_COMMAND_STOP,
	IS_SCALERC_COMMAND_START,
	IS_SCALERC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_SCALERP			(V4L2_CID_FIMC_IS_BASE + 474)
enum is_scalerp_cmd_mode {
	IS_SCALERP_COMMAND_STOP,
	IS_SCALERP_COMMAND_START,
	IS_SCALERP_COMMAND_MAX
};

#define V4L2_CID_IS_GET_SENSOR_OFFSET_X		(V4L2_CID_FIMC_IS_BASE + 480)
#define V4L2_CID_IS_GET_SENSOR_OFFSET_Y		(V4L2_CID_FIMC_IS_BASE + 481)
#define V4L2_CID_IS_GET_SENSOR_WIDTH		(V4L2_CID_FIMC_IS_BASE + 482)
#define V4L2_CID_IS_GET_SENSOR_HEIGHT		(V4L2_CID_FIMC_IS_BASE + 483)

#define V4L2_CID_IS_GET_FRAME_VALID		(V4L2_CID_FIMC_IS_BASE + 484)
#define V4L2_CID_IS_SET_FRAME_VALID		(V4L2_CID_FIMC_IS_BASE + 485)
#define V4L2_CID_IS_GET_FRAME_BADMARK		(V4L2_CID_FIMC_IS_BASE + 486)
#define V4L2_CID_IS_SET_FRAME_BADMARK		(V4L2_CID_FIMC_IS_BASE + 487)
#define V4L2_CID_IS_GET_FRAME_CAPTURED		(V4L2_CID_FIMC_IS_BASE + 488)
#define V4L2_CID_IS_SET_FRAME_CAPTURED		(V4L2_CID_FIMC_IS_BASE + 489)
#define V4L2_CID_IS_SET_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 490)
#define V4L2_CID_IS_GET_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 491)
#define V4L2_CID_IS_CLEAR_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 492)
#define V4L2_CID_IS_GET_LOSTED_FRAME_NUMBER	(V4L2_CID_FIMC_IS_BASE + 493)
#define V4L2_CID_IS_ISP_DMA_BUFFER_NUM		(V4L2_CID_FIMC_IS_BASE + 494)
#define V4L2_CID_IS_ISP_DMA_BUFFER_ADDRESS	(V4L2_CID_FIMC_IS_BASE + 495)

#define V4L2_CID_IS_ZOOM_STATE			(V4L2_CID_FIMC_IS_BASE + 660)
#define V4L2_CID_IS_ZOOM_MAX_LEVEL		(V4L2_CID_FIMC_IS_BASE + 661)
#define V4L2_CID_IS_ZOOM			(V4L2_CID_FIMC_IS_BASE + 662)
#define V4L2_CID_IS_FW_DEBUG_REGION_ADDR	(V4L2_CID_FIMC_IS_BASE + 663)

#define V4L2_CID_IS_TUNE_SEL_ENTRY		(V4L2_CID_FIMC_IS_TUNE_BASE)
#define V4L2_CID_IS_TUNE_SENSOR_EXPOSURE	(V4L2_CID_FIMC_IS_TUNE_BASE + 1)
#define V4L2_CID_IS_TUNE_SENSOR_ANALOG_GAIN	(V4L2_CID_FIMC_IS_TUNE_BASE + 2)
#define V4L2_CID_IS_TUNE_SENSOR_FRAME_RATE	(V4L2_CID_FIMC_IS_TUNE_BASE + 3)
#define V4L2_CID_IS_TUNE_SENSOR_ACTUATOR_POS	(V4L2_CID_FIMC_IS_TUNE_BASE + 4)

enum v4l2_blur {
	BLUR_LEVEL_0 = 0,
	BLUR_LEVEL_1,
	BLUR_LEVEL_2,
	BLUR_LEVEL_3,
	BLUR_LEVEL_MAX,
};

#if 1
#define V4L2_CID_CAMERA_SCENE_MODE		(V4L2_CID_PRIVATE_BASE+70)
enum v4l2_scene_mode {
	SCENE_MODE_BASE,
	SCENE_MODE_NONE,
	SCENE_MODE_PORTRAIT,
	SCENE_MODE_NIGHTSHOT,
	SCENE_MODE_BACK_LIGHT,
	SCENE_MODE_LANDSCAPE,
	SCENE_MODE_SPORTS,
	SCENE_MODE_PARTY_INDOOR,
	SCENE_MODE_BEACH_SNOW,
	SCENE_MODE_SUNSET,
	SCENE_MODE_DUSK_DAWN,
	SCENE_MODE_FALL_COLOR,
	SCENE_MODE_FIREWORKS,
	SCENE_MODE_TEXT,
	SCENE_MODE_CANDLE_LIGHT,
	SCENE_MODE_LOW_LIGHT,
	SCENE_MODE_MAX,
};

#define V4L2_CID_CAMERA_FLASH_MODE		(V4L2_CID_PRIVATE_BASE+71)
enum v4l2_flash_mode {
	FLASH_MODE_BASE,
	FLASH_MODE_OFF,
	FLASH_MODE_AUTO,
	FLASH_MODE_ON,
	FLASH_MODE_TORCH,
	FLASH_MODE_RED_EYE,
	FLASH_MODE_FILL_IN,
	FLASH_MODE_SLOW_SYNC,
	FLASH_MODE_RED_EYE_FIX,
	FLASH_MODE_MAX,
};

#define V4L2_CID_CAMERA_BRIGHTNESS		(V4L2_CID_PRIVATE_BASE+72)
enum v4l2_ev_mode {
	EV_MINUS_4	= -4,
	EV_MINUS_3	= -3,
	EV_MINUS_2	= -2,
	EV_MINUS_1	= -1,
	EV_DEFAULT	= 0,
	EV_PLUS_1	= 1,
	EV_PLUS_2	= 2,
	EV_PLUS_3	= 3,
	EV_PLUS_4	= 4,
	EV_MAX,
	EV_MAX_V4L2	= EV_MAX,
};

enum v4l2_exposure {
	EXPOSURE_MINUS_6 = -6,
	EXPOSURE_MINUS_5 = -5,
	EXPOSURE_MINUS_4 = -4,
	EXPOSURE_MINUS_3 = -3,
	EXPOSURE_MINUS_2 = -2,
	EXPOSURE_MINUS_1 = -1,
	EXPOSURE_DEFAULT = 0,
	EXPOSURE_PLUS_1	= 1,
	EXPOSURE_PLUS_2	= 2,
	EXPOSURE_PLUS_3	= 3,
	EXPOSURE_PLUS_4	= 4,
	EXPOSURE_PLUS_5	= 5,
	EXPOSURE_PLUS_6	= 6,
	EXPOSURE_MAX,
};

#define V4L2_CID_CAMERA_WHITE_BALANCE	(V4L2_CID_PRIVATE_BASE+73)
enum v4l2_wb_mode {
	WHITE_BALANCE_BASE = 0,
	WHITE_BALANCE_AUTO,
	WHITE_BALANCE_SUNNY,
	WHITE_BALANCE_CLOUDY,
	WHITE_BALANCE_TUNGSTEN,
	WHITE_BALANCE_FLUORESCENT,
	WHITE_BALANCE_FLUORESCENT_H,
	WHITE_BALANCE_FLUORESCENT_L,
	WHITE_BALANCE_CUSTOM,
	WHITE_BALANCE_K,
	WHITE_BALANCE_INCANDESCENT,
	WHITE_BALANCE_PROHIBITION,
	WHITE_BALANCE_HORIZON,
	WHITE_BALANCE_LEDLIGHT,
	WHITE_BALANCE_MAX,
};

#define V4L2_CID_CAMERA_EFFECT			(V4L2_CID_PRIVATE_BASE+74)
enum v4l2_effect_mode {
	IMAGE_EFFECT_BASE = 0,
	IMAGE_EFFECT_NONE,
	IMAGE_EFFECT_BNW,
	IMAGE_EFFECT_SEPIA,
	IMAGE_EFFECT_AQUA,
	IMAGE_EFFECT_ANTIQUE,
	IMAGE_EFFECT_NEGATIVE,
	IMAGE_EFFECT_SHARPEN,
	IMAGE_EFFECT_SKETCH,
	IMAGE_EFFECT_WASHED,
	IMAGE_EFFECT_VINTAGE_WARM,
	IMAGE_EFFECT_VINTAGE_COLD,
	IMAGE_EFFECT_SOLARIZE,
	IMAGE_EFFECT_POSTERIZE,
	IMAGE_EFFECT_POINT_BLUE,
	IMAGE_EFFECT_POINT_RED_YELLOW,
	IMAGE_EFFECT_POINT_COLOR_3,
	IMAGE_EFFECT_POINT_GREEN,
	IMAGE_EFFECT_POINT_RED,
	IMAGE_EFFECT_POINT_YELLOW,
	IMAGE_EFFECT_CARTOONIZE,
	IMAGE_EFFECT_MAX,
};

#define V4L2_CID_CAMERA_ISO		(V4L2_CID_PRIVATE_BASE+75)
enum v4l2_iso_mode {
	ISO_AUTO = 0,
	ISO_50,
	ISO_100,
	ISO_200,
	ISO_400,
	ISO_800,
	ISO_1600,
	ISO_3200,
	ISO_SPORTS,
	ISO_NIGHT,
	ISO_MOVIE,
	ISO_MAX,
};

#define V4L2_CID_CAMERA_METERING	(V4L2_CID_PRIVATE_BASE+76)
enum v4l2_metering_mode {
	METERING_BASE = 0,
	METERING_MATRIX,
	METERING_CENTER,
	METERING_SPOT,
	METERING_MAX,
};

#define V4L2_CID_CAMERA_CONTRAST	(V4L2_CID_PRIVATE_BASE+77)
enum v4l2_contrast_mode {
	CONTRAST_MINUS_2 = 0,
	CONTRAST_MINUS_1,
	CONTRAST_DEFAULT,
	CONTRAST_PLUS_1,
	CONTRAST_PLUS_2,
	CONTRAST_MAX,
};

#define V4L2_CID_CAMERA_SATURATION		(V4L2_CID_PRIVATE_BASE+78)
enum v4l2_saturation_mode {
	SATURATION_MINUS_2 = 0,
	SATURATION_MINUS_1,
	SATURATION_DEFAULT,
	SATURATION_PLUS_1,
	SATURATION_PLUS_2,
	SATURATION_MAX,
};

#define V4L2_CID_CAMERA_SHARPNESS		(V4L2_CID_PRIVATE_BASE+79)
enum v4l2_sharpness_mode {
	SHARPNESS_MINUS_2 = 0,
	SHARPNESS_MINUS_1,
	SHARPNESS_DEFAULT,
	SHARPNESS_PLUS_1,
	SHARPNESS_PLUS_2,
	SHARPNESS_MAX,
};

#define V4L2_CID_CAMERA_WDR		(V4L2_CID_PRIVATE_BASE+80)
enum v4l2_wdr_mode {
	WDR_OFF,
	WDR_ON,
	WDR_MAX,
};

#define V4L2_CID_CAMERA_ANTI_SHAKE		(V4L2_CID_PRIVATE_BASE+81)
enum v4l2_anti_shake_mode {
	ANTI_SHAKE_OFF,
	ANTI_SHAKE_STILL_ON,
	ANTI_SHAKE_MOVIE_ON,
	ANTI_SHAKE_MAX,
};

#define V4L2_CID_CAMERA_TOUCH_AF_START_STOP (V4L2_CID_PRIVATE_BASE+82)
enum v4l2_touch_af {
	TOUCH_AF_STOP = 0,
	TOUCH_AF_START,
	TOUCH_AF_MAX,
};

#define V4L2_CID_CAMERA_SMART_AUTO		(V4L2_CID_PRIVATE_BASE+83)
enum v4l2_smart_auto {
	SMART_AUTO_OFF = 0,
	SMART_AUTO_ON,
	SMART_AUTO_MAX,
};

#define V4L2_CID_CAMERA_VINTAGE_MODE		(V4L2_CID_PRIVATE_BASE+84)
enum v4l2_vintage_mode {
	VINTAGE_MODE_BASE,
	VINTAGE_MODE_OFF,
	VINTAGE_MODE_NORMAL,
	VINTAGE_MODE_WARM,
	VINTAGE_MODE_COOL,
	VINTAGE_MODE_BNW,
	VINTAGE_MODE_MAX,
};

#define V4L2_CID_CAMERA_JPEG_QUALITY		(V4L2_CID_PRIVATE_BASE+85)
#define V4L2_CID_CAMERA_CAPTURE_THUMB (V4L2_CID_PRIVATE_BASE + 86)
#define V4L2_CID_CAMERA_YUV_SNAPSHOT	(V4L2_CID_PRIVATE_BASE + 87)
#define V4L2_CID_CAMERA_LOW_LIGHT_MODE	(V4L2_CID_PRIVATE_BASE + 88)
#define V4L2_CID_CAMERA_GPS_LATITUDE	(V4L2_CID_CAMERA_CLASS_BASE+30)
/* (V4L2_CID_PRIVATE_BASE+87) */
#define V4L2_CID_CAMERA_GPS_LONGITUDE	(V4L2_CID_CAMERA_CLASS_BASE + 31)
/* (V4L2_CID_PRIVATE_BASE+88) */
#define V4L2_CID_CAMERA_GPS_TIMESTAMP	(V4L2_CID_CAMERA_CLASS_BASE + 32)
/* (V4L2_CID_PRIVATE_BASE+89)*/
#define V4L2_CID_CAMERA_GPS_ALTITUDE	(V4L2_CID_CAMERA_CLASS_BASE + 33)
#define V4L2_CID_CAMERA_EXIF_TIME_INFO	(V4L2_CID_CAMERA_CLASS_BASE + 34)
#define V4L2_CID_CAMERA_GPS_PROCESSINGMETHOD	(V4L2_CID_CAMERA_CLASS_BASE+35)

#define V4L2_CID_FOCUS_AUTO_MODE				(V4L2_CID_CAMERA_CLASS_BASE+36)
enum v4l2_focus_mode_type {
	V4L2_FOCUS_AUTO_NORMAL = 0,
	V4L2_FOCUS_AUTO_MACRO,
	V4L2_FOCUS_AUTO_CONTINUOUS,
	V4L2_FOCUS_AUTO_FACE_DETECTION,
	V4L2_FOCUS_AUTO_RECTANGLE,
	V4L2_FOCUS_AUTO_MAX,
};
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_LEFT		(V4L2_CID_CAMERA_CLASS_BASE+37)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_TOP		(V4L2_CID_CAMERA_CLASS_BASE+38)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_WIDTH		(V4L2_CID_CAMERA_CLASS_BASE+39)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_HEIGHT		(V4L2_CID_CAMERA_CLASS_BASE+40)

#define V4L2_CID_CAMERA_ZOOM	(V4L2_CID_PRIVATE_BASE+90)
enum v4l2_zoom_level {
	ZOOM_LEVEL_0 = 0,
	ZOOM_LEVEL_1,
	ZOOM_LEVEL_2,
	ZOOM_LEVEL_3,
	ZOOM_LEVEL_4,
	ZOOM_LEVEL_5,
	ZOOM_LEVEL_6,
	ZOOM_LEVEL_7,
	ZOOM_LEVEL_8,
	ZOOM_LEVEL_9,
	ZOOM_LEVEL_10,
	ZOOM_LEVEL_11,
	ZOOM_LEVEL_12,
	ZOOM_LEVEL_MAX = 31,
};

#define V4L2_CID_CAMERA_FACE_DETECTION		(V4L2_CID_PRIVATE_BASE+91)
enum v4l2_face_detection {
	FACE_DETECTION_OFF = 0,
	FACE_DETECTION_ON,
	FACE_DETECTION_NOLINE,
	FACE_DETECTION_ON_BEAUTY,
	FACE_DETECTION_NORMAL,
	FACE_DETECTION_SMILE_SHOT,
	FACE_DETECTION_BLINK,
	FACE_DETECTION_MAX,
};

#define V4L2_CID_CAMERA_SMART_AUTO_STATUS	(V4L2_CID_PRIVATE_BASE+92)
enum v4l2_smart_auto_status {
	SMART_AUTO_STATUS_AUTO = 0,
	SMART_AUTO_STATUS_LANDSCAPE,
	SMART_AUTO_STATUS_PORTRAIT,
	SMART_AUTO_STATUS_MACRO,
	SMART_AUTO_STATUS_NIGHT,
	SMART_AUTO_STATUS_PORTRAIT_NIGHT,
	SMART_AUTO_STATUS_BACKLIT,
	SMART_AUTO_STATUS_PORTRAIT_BACKLIT,
	SMART_AUTO_STATUS_ANTISHAKE,
	SMART_AUTO_STATUS_PORTRAIT_ANTISHAKE,
	SMART_AUTO_STATUS_MAX,
};

#define V4L2_CID_CAMERA_SET_AUTO_FOCUS		(V4L2_CID_PRIVATE_BASE+93)
enum v4l2_auto_focus {
	AUTO_FOCUS_OFF = 0,
	AUTO_FOCUS_ON,
	AUTO_FOCUS_MAX,
};

#define V4L2_CID_CAMERA_BEAUTY_SHOT		(V4L2_CID_PRIVATE_BASE+94)
enum v4l2_beauty_shot {
	BEAUTY_SHOT_OFF = 0,
	BEAUTY_SHOT_ON,
	BEAUTY_SHOT_MAX,
};

#define V4L2_CID_CAMERA_AEAWB_LOCK_UNLOCK	(V4L2_CID_PRIVATE_BASE+95)
enum v4l2_ae_awb_lockunlock {
	AE_UNLOCK_AWB_UNLOCK = 0,
	AE_LOCK_AWB_UNLOCK,
	AE_UNLOCK_AWB_LOCK,
	AE_LOCK_AWB_LOCK,
	AE_AWB_MAX
};

#define V4L2_CID_CAMERA_FACEDETECT_LOCKUNLOCK	(V4L2_CID_PRIVATE_BASE+96)
enum v4l2_face_lock {
	FACE_LOCK_OFF = 0,
	FACE_LOCK_ON,
	FIRST_FACE_TRACKING,
	FACE_LOCK_MAX,
};

#define V4L2_CID_CAMERA_OBJECT_POSITION_X	(V4L2_CID_PRIVATE_BASE+97)
#define V4L2_CID_CAMERA_OBJECT_POSITION_Y	(V4L2_CID_PRIVATE_BASE+98)
#define V4L2_CID_CAMERA_FOCUS_MODE		(V4L2_CID_PRIVATE_BASE+99)
enum v4l2_focusmode {
	FOCUS_MODE_AUTO = 0,
	FOCUS_MODE_MACRO,
	FOCUS_MODE_FACEDETECT,
	FOCUS_MODE_AUTO_DEFAULT,
	FOCUS_MODE_MACRO_DEFAULT,
	FOCUS_MODE_FACEDETECT_DEFAULT,
	FOCUS_MODE_INFINITY,
	FOCUS_MODE_FIXED,
	FOCUS_MODE_CONTINOUS,
	FOCUS_MODE_CONTINOUS_PICTURE,
	FOCUS_MODE_CONTINOUS_PICTURE_MACRO,
	FOCUS_MODE_CONTINOUS_VIDEO,
	FOCUS_MODE_TOUCH,
	FOCUS_MODE_MANUAL,
	FOCUS_MODE_MULTI,
	FOCUS_MODE_OBJECT_TRACKING,
	FOCUS_MODE_MAX,
	FOCUS_MODE_DEFAULT = (1 << 8),
};

#define V4L2_CID_CAMERA_OBJ_TRACKING_STATUS	(V4L2_CID_PRIVATE_BASE+100)
enum v4l2_obj_tracking_status {
	OBJECT_TRACKING_STATUS_BASE = 0,
	OBJECT_TRACKING_STATUS_SUCCESS = 1,
	OBJECT_TRACKING_STATUS_MISSING = 2,
	OBJECT_TRACKING_STATUS_FAIL = 3,
	OBJECT_TRACKING_STATUS_MAX,
};

#define V4L2_CID_CAMERA_OBJ_TRACKING_START_STOP	(V4L2_CID_PRIVATE_BASE+101)
enum v4l2_ot_start_stop {
	OT_STOP = 0,
	OT_START,
	OT_MAX,
};

#define V4L2_CID_CAMERA_CAF_START_STOP	(V4L2_CID_PRIVATE_BASE+102)
enum v4l2_caf_start_stop {
	CAF_STOP = 0,
	CAF_START,
	CAF_MAX,
};

#define V4L2_CID_CAMERA_AUTO_FOCUS_RESULT	(V4L2_CID_PRIVATE_BASE+103)
enum v4l2_af_status {
	CAMERA_AF_STATUS_IN_PROGRESS = 0,
	CAMERA_AF_STATUS_SUCCESS,
	CAMERA_AF_STATUS_FAIL,
	CAMERA_AF_STATUS_1ST_SUCCESS,
	CAMERA_AF_STATUS_RESTART,
	CAMERA_AF_STATUS_MAX,
};

#define V4L2_CID_CAMERA_FRAME_RATE		(V4L2_CID_PRIVATE_BASE+104)
enum v4l2_frame_rate {
	FRAME_RATE_AUTO = 0,
	FRAME_RATE_7 = 7,
	FRAME_RATE_15 = 15,
	FRAME_RATE_20 = 20,
	FRAME_RATE_25 = 25,
	FRAME_RATE_30 = 30,
	FRAME_RATE_60 = 60,
	FRAME_RATE_120 = 120,
	FRAME_RATE_MAX
};

#define V4L2_CID_CAMERA_ANTI_BANDING		(V4L2_CID_PRIVATE_BASE+105)
enum v4l2_anti_banding {
	ANTI_BANDING_AUTO = 0,
	ANTI_BANDING_50HZ = 1,
	ANTI_BANDING_60HZ = 2,
	ANTI_BANDING_50_60Hz = 3,
	ANTI_BANDING_OFF = 4,
};

#define V4L2_CID_CAMERA_SET_GAMMA	(V4L2_CID_PRIVATE_BASE+106)
enum v4l2_gamma_mode {
	GAMMA_OFF = 0,
	GAMMA_ON = 1,
	GAMMA_MAX,
};

#define V4L2_CID_CAMERA_SET_SLOW_AE	(V4L2_CID_PRIVATE_BASE+107)
enum v4l2_slow_ae_mode {
	SLOW_AE_OFF,
	SLOW_AE_ON,
	SLOW_AE_MAX,
};

#define V4L2_CID_CAMERA_BATCH_REFLECTION	(V4L2_CID_PRIVATE_BASE+108)
#define V4L2_CID_CAMERA_EXIF_ORIENTATION	(V4L2_CID_PRIVATE_BASE+109)
#define V4L2_CID_CAMERA_GET_LUX			(V4L2_CID_PRIVATE_BASE+110)

/* s1_camera [ Defense process by ESD input ] */
#define V4L2_CID_CAMERA_RESET			(V4L2_CID_PRIVATE_BASE+111)
#define V4L2_CID_CAMERA_CHECK_DATALINE		(V4L2_CID_PRIVATE_BASE+112)
#define V4L2_CID_CAMERA_CHECK_DATALINE_STOP	(V4L2_CID_PRIVATE_BASE+113)

#endif

/* Modify NTTS1 */
#if defined(CONFIG_ARIES_NTT)
#define V4L2_CID_CAMERA_AE_AWB_DISABLE_LOCK	(V4L2_CID_PRIVATE_BASE+114)
#endif
#define V4L2_CID_CAMERA_THUMBNAIL_NULL		(V4L2_CID_PRIVATE_BASE+115)
#define V4L2_CID_CAMERA_SENSOR_MODE		(V4L2_CID_PRIVATE_BASE+116)
enum v4l2_sensor_mode {
	SENSOR_CAMERA,
	SENSOR_MOVIE,
};

enum stream_mode_t {
	STREAM_MODE_CAM_OFF,
	STREAM_MODE_CAM_ON,
	STREAM_MODE_MOVIE_OFF,
	STREAM_MODE_MOVIE_ON,
	STREAM_MODE_WAIT_OFF
};

#define V4L2_CID_CAMERA_EXIF_EXPTIME		(V4L2_CID_PRIVATE_BASE+117)
#define V4L2_CID_CAMERA_EXIF_FLASH	(V4L2_CID_PRIVATE_BASE+118)
#define V4L2_CID_CAMERA_EXIF_ISO		(V4L2_CID_PRIVATE_BASE+119)
#define V4L2_CID_CAMERA_EXIF_TV		(V4L2_CID_PRIVATE_BASE+120)
#define V4L2_CID_CAMERA_EXIF_BV		(V4L2_CID_PRIVATE_BASE+121)
#define V4L2_CID_CAMERA_EXIF_EBV		(V4L2_CID_PRIVATE_BASE+122)
#define V4L2_CID_CAMERA_CHECK_ESD		(V4L2_CID_PRIVATE_BASE+123)
#define V4L2_CID_CAMERA_APP_CHECK		(V4L2_CID_PRIVATE_BASE+124)
#define V4L2_CID_CAMERA_CHECK_SENSOR_STATUS	(V4L2_CID_PRIVATE_BASE+150)
#define V4L2_CID_CAMERA_DEFAULT_FOCUS_POSITION  (V4L2_CID_PRIVATE_BASE+151)
#define V4L2_CID_CAMERA_BUSFREQ_LOCK		(V4L2_CID_PRIVATE_BASE+125)
#define V4L2_CID_CAMERA_BUSFREQ_UNLOCK		(V4L2_CID_PRIVATE_BASE+126)

/* If you would like to control AE and AWB lock with signle command,
 * use V4L2_CID_CAMERA_AEAWB_LOCK_UNLOCK above.
 */
#define V4L2_CID_CAMERA_AE_LOCK_UNLOCK	(V4L2_CID_PRIVATE_BASE + 127)
enum v4l2_ae_lockunlock {
	AE_UNLOCK = 0,
	AE_LOCK,
	AE_LOCK_MAX
};

#define V4L2_CID_CAMERA_AWB_LOCK_UNLOCK	(V4L2_CID_PRIVATE_BASE + 128)
enum v4l2_awb_lockunlock {
	AWB_UNLOCK = 0,
	AWB_LOCK,
	AWB_LOCK_MAX
};

#define V4L2_CID_CAMERA_SENSOR_OUTPUT_SIZE  (V4L2_CID_PRIVATE_BASE + 129)
#define V4L2_CID_EMBEDDEDDATA_ENABLE	(V4L2_CID_PRIVATE_BASE + 130)
#define V4L2_CID_CAMERA_JPEG_RESOLUTION	 (V4L2_CID_PRIVATE_BASE + 131)
#define V4L2_CID_CAMERA_FACE_ZOOM  (V4L2_CID_PRIVATE_BASE + 132)
enum v4l2_face_zoom {
	FACE_ZOOM_STOP = 0,
	FACE_ZOOM_START
};

/* control for post processing block in ISP */
#define V4L2_CID_CAMERA_SET_ODC				(V4L2_CID_PRIVATE_BASE+127)
enum set_odc_mode {
	CAMERA_ODC_ON,
	CAMERA_ODC_OFF
};

#define V4L2_CID_CAMERA_SET_DIS				(V4L2_CID_PRIVATE_BASE+128)
enum set_dis_mode {
	CAMERA_DIS_ON,
	CAMERA_DIS_OFF
};

#define V4L2_CID_CAMERA_SET_3DNR				(V4L2_CID_PRIVATE_BASE+129)
enum set_3dnr_mode {
	CAMERA_3DNR_ON,
	CAMERA_3DNR_OFF
};

#define V4L2_CID_CAMERA_BRACKET     (V4L2_CID_PRIVATE_BASE+134)
enum v4l2_face_bracket_mode {
	BRACKET_MODE_OFF = 0,
	BRACKET_MODE_AEB,
	BRACKET_MODE_WBB,
	BRACKET_MODE_MAX,
};

#define V4L2_CID_CAMERA_BRACKET_AEB     (V4L2_CID_PRIVATE_BASE+135)
enum v4l2_face_bracket_aeb_value {
	BRACKET_AEB_VALUE1 = 1,
	BRACKET_AEB_VALUE2,
	BRACKET_AEB_VALUE3,
	BRACKET_AEB_VALUE4,
	BRACKET_AEB_VALUE5,
	BRACKET_AEB_VALUE6,
};

#define V4L2_CID_CAMERA_BRACKET_WBB     (V4L2_CID_PRIVATE_BASE+136)
enum v4l2_face_bracket_wbb_value {
	BRACKET_WBB_OFF = 0,
	BRACKET_WBB_VALUE1 = 1,
	BRACKET_WBB_VALUE2,
	BRACKET_WBB_VALUE3,
	BRACKET_WBB_VALUE4,
	BRACKET_WBB_VALUE5,
	BRACKET_WBB_VALUE6,
};

#define V4L2_CID_CAMERA_DRIVE_DIAL    (V4L2_CID_PRIVATE_BASE+137)
enum v4l2_drive_dial {
	DRIVEDIAL_SINGLE = 1,
	DRIVEDIAL_BKT = 2,
	DRIVEDIAL_CONTI_3 = 3,
	DRIVEDIAL_CONTI_5 = 5,
	DRIVEDIAL_CONTI_10 = 10,
};

enum v4l2_running_cap_mode {
	RUNNING_MODE_SINGLE = 0,
	RUNNING_MODE_CONTINUOUS,
	RUNNING_MODE_BEST,
	RUNNING_MODE_LOWLIGHT,
	RUNNING_MODE_AE_BRACKET,
	RUNNING_MODE_WB_BRACKET,
	RUNNING_MODE_HDR,
	RUNNING_MODE_BLINK,
	RUNNING_MODE_RAW,
	RUNNING_MODE_BURST,
	RUNNING_MODE_MAX
};

enum v4l2_continuous_mode {
	CONTINUOUS_MODE_OFF = 0,
	CONTINUOUS_MODE_ON,
	CONTINUOUS_MODE_MAX,
};

enum v4l2_continuous_fps {
	MULTI_CAPTURE_FPS_1 = 0,
	MULTI_CAPTURE_FPS_10,
	MULTI_CAPTURE_FPS_5,
	MULTI_CAPTURE_FPS_3,
	MULTI_CAPTURE_FPS_MAX,
};

enum v4l2_burst_mode {
	BURST_MODE_OFF = 0,
	BURST_MODE_ON,
};

enum v4l2_best_mode {
	BEST_MODE_OFF = 0,
	BEST_MODE_ON,
	BEST_MODE_MAX,};

enum v4l2_lowlight_mode {
	LOWLIGHT_MODE_OFF = 0,
	LOWLIGHT_MODE_ON,
	LOWLIGHT_MODE_MAX,};

#define V4L2_CID_CAMERA_FD_EYE_BLINK_RESULT    (V4L2_CID_PRIVATE_BASE+138)

#define V4L2_CID_CAMERA_OPTICAL_ZOOM_STEP      (V4L2_CID_PRIVATE_BASE + 139)
#define V4L2_CID_CAMERA_OPTICAL_ZOOM_CTRL      (V4L2_CID_PRIVATE_BASE + 140)
enum v4l2_optical_zoom_ctrl {
	V4L2_OPTICAL_ZOOM_STOP,
	V4L2_OPTICAL_ZOOM_TELE_START,
	V4L2_OPTICAL_ZOOM_WIDE_START,
	V4L2_OPTICAL_ZOOM_SLOW_TELE_START,
	V4L2_OPTICAL_ZOOM_SLOW_WIDE_START,
};

#define V4L2_CID_CAMERA_LDC    (V4L2_CID_PRIVATE_BASE+142)
enum set_LDC_mode {
	LDC_SET_OFF = 0,
	LDC_SET_ON = 1,
};

#define V4L2_CID_CAMERA_LSC    (V4L2_CID_PRIVATE_BASE+143)
enum set_LSC_mode {
	LSC_SET_OFF = 0,
	LSC_SET_ON = 1,
};

#define V4L2_CID_CAMERA_FACTORY_OIS    (V4L2_CID_PRIVATE_BASE+147)
enum set_Factory_OIS {
	FACTORY_OIS_RETURN_TO_CENTER = 0,
	FACTORY_OIS_RUN = 1,
	FACTORY_OIS_START = 2,
	FACTORY_OIS_STOP = 3,
	FACTORY_OIS_MODE_ON = 4,
	FACTORY_OIS_MODE_OFF = 5,
	FACTORY_OIS_LOG = 6,
	FACTORY_OIS_ON = 7,
};

#define V4L2_CID_CAMERA_FACTORY_ZOOM_RANGE_CHECK_DATA_MIN \
	(V4L2_CID_PRIVATE_BASE+148)
#define V4L2_CID_CAMERA_FACTORY_ZOOM_RANGE_CHECK_DATA_MAX \
	(V4L2_CID_PRIVATE_BASE+149)
#define V4L2_CID_CAMERA_FACTORY_ZOOM_SLOPE_CHECK_DATA_MIN \
	(V4L2_CID_PRIVATE_BASE+152)
#define V4L2_CID_CAMERA_FACTORY_ZOOM_SLOPE_CHECK_DATA_MAX \
	(V4L2_CID_PRIVATE_BASE+153)
#define V4L2_CID_CAMERA_FACTORY_ZOOM_STEP  (V4L2_CID_PRIVATE_BASE+154)
#define V4L2_CID_CAMERA_FACTORY_ZOOM    (V4L2_CID_PRIVATE_BASE+155)
enum set_Factory_Zoom {
	FACTORY_ZOOM_MOVE_STEP = 0,
	FACTORY_ZOOM_RANGE_CHECK_START = 1,
	FACTORY_ZOOM_RANGE_CHECK_STOP = 2,
	FACTORY_ZOOM_SLOPE_CHECK_START = 3,
	FACTORY_ZOOM_SLOPE_CHECK_STOP = 4,
	FACTORY_ZOOM_SET_RANGE_CHECK_DATA = 5,
	FACTORY_ZOOM_SET_SLOPE_CHECK_DATA = 6,
	FACTORY_ZOOM_STEP_TELE = 7,
	FACTORY_ZOOM_STEP_WIDE = 8,
	FACTORY_ZOOM_MOVE_END_CHECK = 9,
};

#define V4L2_CID_CAMERA_FACTORY_PUNT_RANGE_DATA_MIN \
	(V4L2_CID_PRIVATE_BASE+156)
#define V4L2_CID_CAMERA_FACTORY_PUNT_RANGE_DATA_MAX \
	(V4L2_CID_PRIVATE_BASE+157)
#define V4L2_CID_CAMERA_FACTORY_PUNT_RANGE_DATA_NUM \
	(V4L2_CID_PRIVATE_BASE+158)
#define V4L2_CID_CAMERA_FACTORY_PUNT    (V4L2_CID_PRIVATE_BASE+159)
enum set_Factory_Punt {
	FACTORY_PUNT_RANGE_START = 0,
	FACTORY_PUNT_RANGE_STOP = 1,
	FACTORY_PUNT_SHORT_SCAN_DATA = 2,
	FACTORY_PUNT_SHORT_SCAN_START = 3,
	FACTORY_PUNT_SHORT_SCAN_STOP = 4,
	FACTORY_PUNT_LONG_SCAN_DATA = 5,
	FACTORY_PUNT_LONG_SCAN_START = 6,
	FACTORY_PUNT_LONG_SCAN_STOP = 7,
	FACTORY_PUNT_LOG = 8,
	FACTORY_PUNT_SET_RANGE_DATA = 9,
	FACTORY_PUNT_EEP_WRITE = 10,
};

#define V4L2_CID_CAMERA_FACTORY_FAIL_STOP    (V4L2_CID_PRIVATE_BASE+160)
enum set_Factory_Fail_Stop {
	FACTORY_FAIL_STOP_ON = 0,
	FACTORY_FAIL_STOP_OFF = 1,
	FACTORY_FAIL_STOP_RUN = 2,
	FACTORY_FAIL_STOP_STOP = 3,
};

#define V4L2_CID_CAMERA_FACTORY_NODEFOCUS    (V4L2_CID_PRIVATE_BASE+161)
enum set_Factory_NoDeFocus {
	FACTORY_NODEFOCUSYES_ON = 0,
	FACTORY_NODEFOCUSYES_OFF = 1,
	FACTORY_NODEFOCUSYES_RUN = 2,
	FACTORY_NODEFOCUSYES_STOP = 3,
};

#define V4L2_CID_CAMERA_FACTORY_INTERPOLATION    (V4L2_CID_PRIVATE_BASE+162)
enum set_Factory_Interpolation {
	FACTORY_INTERPOLATION_USE = 0,
	FACTORY_INTERPOLATION_RELEASE = 1,
};

#define V4L2_CID_CAMERA_FACTORY_DOWN_RESULT (V4L2_CID_PRIVATE_BASE+163)
#define V4L2_CID_CAMERA_FACTORY_END_RESULT (V4L2_CID_PRIVATE_BASE+164)
#define V4L2_CID_CAMERA_FACTORY_COMMON    (V4L2_CID_PRIVATE_BASE+165)
enum set_Factory_Common {
	FACTORY_FIRMWARE_DOWNLOAD = 0,
	FACTORY_DOWNLOAD_CHECK = 1,
	FACTORY_END_CHECK = 2,
	FACTORY_COMMON_SET_FOCUS_ZONE_MACRO = 3,
	FACTORY_FPS30_ON = 4,
	FACTORY_FPS30_OFF = 5,
};

#define V4L2_CID_CAMERA_FACTORY_VIB    (V4L2_CID_PRIVATE_BASE+166)
enum set_Factory_Vib {
	FACTORY_VIB_START = 0,
	FACTORY_VIB_STOP = 1,
	FACTORY_VIB_LOG = 2,
};

#define V4L2_CID_CAMERA_FACTORY_GYRO    (V4L2_CID_PRIVATE_BASE+167)
enum set_Factory_Gyro {
	FACTORY_GYRO_START = 0,
	FACTORY_GYRO_STOP = 1,
	FACTORY_GYRO_LOG = 2,
};

#define V4L2_CID_CAMERA_FACTORY_BACKLASH    (V4L2_CID_PRIVATE_BASE+168)
enum set_Factory_Backlash {
	FACTORY_BACKLASH_INPUT = 0,
	FACTORY_BACKLASH_MAX_THR = 1,
	FACTORY_BACKLASH_WIDE_RUN = 2,
	FACTORY_BACKLASH_LOG = 3,
};

#define V4L2_CID_CAMERA_FACTORY_AF_STEP_SET    (V4L2_CID_PRIVATE_BASE+169)
#define V4L2_CID_CAMERA_FACTORY_AF_POSITION    (V4L2_CID_PRIVATE_BASE+170)
#define V4L2_CID_CAMERA_FACTORY_AF_INT_RESULT (V4L2_CID_PRIVATE_BASE+171)
#define V4L2_CID_CAMERA_FACTORY_AF    (V4L2_CID_PRIVATE_BASE+172)
enum set_Factory_AF {
	FACTORY_AF_LOCK_ON_SET = 0,
	FACTORY_AF_LOCK_OFF_SET = 1,
	FACTORY_AF_MOVE = 2,
	FACTORY_AF_STEP_LOG = 3,
	FACTORY_AF_LOCK_START = 4,
	FACTORY_AF_LOCK_STOP = 5,
	FACTORY_AF_FOCUS_LOG = 6,
	FACTORY_AF_INT_SET = 7,
	FACTORY_AF_SCAN_LIMIT_START = 8,
	FACTORY_AF_SCAN_LIMIT_STOP = 10,
	FACTORY_AF_SCAN_RANGE_START = 11,
	FACTORY_AF_SCAN_RANGE_STOP = 12,
	FACTORY_AF_STEP_SAVE = 13,
	FACTORY_AF_LED_END_CHECK = 14,
	FACTORY_AF_LED_LOG = 15,
	FACTORY_AF_MOVE_END_CHECK = 16,
	FACTORY_AF_SCAN_END_CHECK = 17,
};

#define V4L2_CID_CAMERA_FACTORY_DEFOCUS_WIDE    (V4L2_CID_PRIVATE_BASE+173)
#define V4L2_CID_CAMERA_FACTORY_DEFOCUS_TELE (V4L2_CID_PRIVATE_BASE+174)
#define V4L2_CID_CAMERA_FACTORY_DEFOCUS    (V4L2_CID_PRIVATE_BASE+175)
enum set_Factory_DeFocus {
	FACTORY_DEFOCUS_RUN = 0,
	FACTORY_DEFOCUS_STOP = 1,
};

#define V4L2_CID_CAMERA_FACTORY_RESOL_CAP    (V4L2_CID_PRIVATE_BASE+176)
enum set_Factory_Resol_Cap {
	FACTORY_CAP_COMP_ON = 0,
	FACTORY_CAP_COMP_OFF = 1,
	FACTORY_CAP_BARREL_ON = 2,
	FACTORY_CAP_BARREL_OFF = 3,
	FACTORY_CAP_BARREL_START = 4,
	FACTORY_CAP_BARREL_STOP = 5,
	FACTORY_CAP_COMP_START = 6,
	FACTORY_CAP_COMP_STOP = 7,
};

#define V4L2_CID_CAMERA_SET_G_VALUE          (V4L2_CID_PRIVATE_BASE + 177)
#define V4L2_CID_CAMERA_SET_B_VALUE          (V4L2_CID_PRIVATE_BASE + 178)
#define V4L2_CID_CAMERA_SET_A_VALUE          (V4L2_CID_PRIVATE_BASE + 179)
#define V4L2_CID_CAMERA_SET_M_VALUE          (V4L2_CID_PRIVATE_BASE + 180)
#define V4L2_CID_CAMERA_SET_GBAM          (V4L2_CID_PRIVATE_BASE + 181)
#define V4L2_CID_CAMERA_SET_K_VALUE          (V4L2_CID_PRIVATE_BASE + 182)
#define V4L2_CID_CAMERA_SET_FLASH_EVC_STEP   (V4L2_CID_PRIVATE_BASE + 183)

#define V4L2_CID_CAMERA_APERTURE_CMD (V4L2_CID_PRIVATE_BASE+184)
enum set_Factory_Aperture_Cmd {
	FACTORY_CMD_PREVIEW = 0,
	FACTORY_CMD_CAPTURE = 1,
};

#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_X_MIN (V4L2_CID_PRIVATE_BASE+185)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_X_MAX (V4L2_CID_PRIVATE_BASE+186)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_Y_MIN (V4L2_CID_PRIVATE_BASE+187)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_Y_MAX (V4L2_CID_PRIVATE_BASE+188)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_X_GAIN \
	(V4L2_CID_PRIVATE_BASE+189)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_PEAK_X \
	(V4L2_CID_PRIVATE_BASE+190)
#define V4L2_CID_CAMERA_FACTORY_OIS_RANGE_DATA_PEAK_Y \
	(V4L2_CID_PRIVATE_BASE+191)

#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_X_MIN (V4L2_CID_PRIVATE_BASE+192)
#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_X_MAX (V4L2_CID_PRIVATE_BASE+193)
#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_Y_MIN (V4L2_CID_PRIVATE_BASE+194)
#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_Y_MAX (V4L2_CID_PRIVATE_BASE+195)
#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_PEAK_X \
	(V4L2_CID_PRIVATE_BASE+196)
#define V4L2_CID_CAMERA_FACTORY_VIB_RANGE_DATA_PEAK_Y \
	(V4L2_CID_PRIVATE_BASE+197)

#define V4L2_CID_CAMERA_FACTORY_GYRO_RANGE_DATA_X_MIN \
	(V4L2_CID_PRIVATE_BASE+198)
#define V4L2_CID_CAMERA_FACTORY_GYRO_RANGE_DATA_X_MAX \
	(V4L2_CID_PRIVATE_BASE+199)
#define V4L2_CID_CAMERA_FACTORY_GYRO_RANGE_DATA_Y_MIN \
	(V4L2_CID_PRIVATE_BASE+200)
#define V4L2_CID_CAMERA_FACTORY_GYRO_RANGE_DATA_Y_MAX \
	(V4L2_CID_PRIVATE_BASE+202)

#define V4L2_CID_CAMERA_FACTORY_TEST_NUMBER (V4L2_CID_PRIVATE_BASE+203)

#define V4L2_CID_CAMERA_FACTORY_BACKLASH_COUNT (V4L2_CID_PRIVATE_BASE+204)
#define V4L2_CID_CAMERA_FACTORY_BACKLASH_MAXTHRESHOLD \
	(V4L2_CID_PRIVATE_BASE+205)

#define V4L2_CID_CAMERA_FACTORY_CAPTURE_CTRL (V4L2_CID_PRIVATE_BASE + 206)
enum set_Factory_Cap_Ctrl {
	FACTORY_STILL_CAP_NORMAL = 0,
	FACTORY_STILL_CAP_DUALCAP = 1,
	FACTORY_DUAL_CAP_ON = 2,
	FACTORY_DUAL_CAP_OFF = 3,
};

#define V4L2_CID_CAMERA_DUAL_POSTVIEW          (V4L2_CID_PRIVATE_BASE + 207)
#define V4L2_CID_CAMERA_DUAL_CAPTURE           (V4L2_CID_PRIVATE_BASE + 208)
#define V4L2_CID_CAMERA_SET_DUAL_CAPTURE       (V4L2_CID_PRIVATE_BASE + 209)
#define V4L2_CID_CAMERA_DUAL_CAPTURE_MODE	(V4L2_CID_PRIVATE_BASE + 210)

#define V4L2_CID_CAMERA_FOCUS_AREA_MODE        (V4L2_CID_PRIVATE_BASE + 211)
enum set_fouce_area {
	V4L2_FOCUS_AREA_CENTER = 0,
	V4L2_FOCUS_AREA_MULTI = 1,
	V4L2_FOCUS_AREA_SMART_TOUCH = 2,
};

#define V4L2_CID_CAMERA_FACTORY_AF_SCAN_LIMIT_MIN    (V4L2_CID_PRIVATE_BASE+212)
#define V4L2_CID_CAMERA_FACTORY_AF_SCAN_LIMIT_MAX    (V4L2_CID_PRIVATE_BASE+213)
#define V4L2_CID_CAMERA_FACTORY_AF_SCAN_RANGE_MIN    (V4L2_CID_PRIVATE_BASE+214)
#define V4L2_CID_CAMERA_FACTORY_AF_SCAN_RANGE_MAX    (V4L2_CID_PRIVATE_BASE+215)
#define V4L2_CID_CAM_APERTURE_PREVIEW	(V4L2_CID_PRIVATE_BASE+216)
#define V4L2_CID_CAM_APERTURE_CAPTURE	(V4L2_CID_PRIVATE_BASE+217)

#define V4L2_CID_CAMERA_FACTORY_AF_ZONE	(V4L2_CID_PRIVATE_BASE+218)
enum set_Factory_AFZone_Cmd {
	FACTORY_AFZONE_NORMAL = 0,
	FACTORY_AFZONE_MACRO,
	FACTORY_AFZONE_AUTO,
};

#define V4L2_CID_CAMERA_FACTORY_OIS_SHIFT	(V4L2_CID_PRIVATE_BASE+219)
#define V4L2_CID_CAMERA_FACTORY_FLICKER	(V4L2_CID_PRIVATE_BASE+220)
enum set_Factory_Flicker_Cmd {
	FACTORY_FLICKER_AUTO = 0,
	FACTORY_FLICKER_50HZ,
	FACTORY_FLICKER_60HZ,
	FACTORY_FLICKER_50_60,
	FACTORY_FLICKER_OFF,
};

#define V4L2_CID_CAMERA_FACTORY_AF_LENS	(V4L2_CID_PRIVATE_BASE+221)
enum set_Factory_AFLENS_Cmd {
	FACTORY_AFLENS_OPEN = 0,
	FACTORY_AFLENS_CLOSE,
};

#define V4L2_CID_CAMERA_FACTORY_LV_TARGET	(V4L2_CID_PRIVATE_BASE+222)

#define V4L2_CID_CAMERA_FACTORY_ADJ_IRIS_RANGE_MIN (V4L2_CID_PRIVATE_BASE+223)
#define V4L2_CID_CAMERA_FACTORY_ADJ_IRIS_RANGE_MAX (V4L2_CID_PRIVATE_BASE+224)
#define V4L2_CID_CAMERA_FACTORY_ADJ_IRIS	(V4L2_CID_PRIVATE_BASE+225)
enum set_Factory_Adj_IRIS_Cmd {
	FACTORY_ADJ_IRIS_RUN = 0,
	FACTORY_ADJ_IRIS_STOP,
	FACTORY_ADJ_IRIS_END_CHECK,
	FACTORY_ADJ_IRIS_LOG,
};

#define V4L2_CID_CAMERA_FACTORY_ADJ_GAIN_LIVEVIEW_RANGE_MIN \
	(V4L2_CID_PRIVATE_BASE+226)
#define V4L2_CID_CAMERA_FACTORY_ADJ_GAIN_LIVEVIEW_RANGE_MAX \
	(V4L2_CID_PRIVATE_BASE+227)
#define V4L2_CID_CAMERA_FACTORY_ADJ_GAIN_LIVEVIEW (V4L2_CID_PRIVATE_BASE+228)
enum set_Factory_Adj_Gain_LiveView_Cmd {
	FACTORY_ADJ_GAIN_LIVEVIEW_RUN = 0,
	FACTORY_ADJ_GAIN_LIVEVIEW_STOP,
	FACTORY_ADJ_GAIN_LIVEVIEW_END_CHECK,
	FACTORY_ADJ_GAIN_LIVEVIEW_LOG,
};

#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_IRIS_NUM (V4L2_CID_PRIVATE_BASE+229)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_SET_IRIS (V4L2_CID_PRIVATE_BASE+230)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_ISO	(V4L2_CID_PRIVATE_BASE+231)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_RANGE (V4L2_CID_PRIVATE_BASE+232)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_SPEEDTIME_X (V4L2_CID_PRIVATE_BASE+233)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE_SPEEDTIME_Y (V4L2_CID_PRIVATE_BASE+234)
#define V4L2_CID_CAMERA_FACTORY_SH_CLOSE	(V4L2_CID_PRIVATE_BASE+235)
enum set_Factory_SH_Close_Cmd {
	FACTORY_SH_CLOSE_RUN = 0,
	FACTORY_SH_CLOSE_STOP,
	FACTORY_SH_CLOSE_END_CHECK,
	FACTORY_SH_CLOSE_LOG,
};

#define V4L2_CID_CAMERA_FACTORY_CAPTURE_GAIN_RANGE_MIN	\
	(V4L2_CID_PRIVATE_BASE+236)
#define V4L2_CID_CAMERA_FACTORY_CAPTURE_GAIN_RANGE_MAX	\
	(V4L2_CID_PRIVATE_BASE+237)
#define V4L2_CID_CAMERA_FACTORY_CAPTURE_GAIN	(V4L2_CID_PRIVATE_BASE+238)
enum set_Factory_Capture_Gain_Cmd {
	FACTORY_CAPTURE_GAIN_RUN = 0,
	FACTORY_CAPTURE_GAIN_STOP,
	FACTORY_CAPTURE_GAIN_END_CHECK,
	FACTORY_CAPTURE_GAIN_LOG,
};

#define V4L2_CID_CAMERA_FACTORY_LSC_TABLE	(V4L2_CID_PRIVATE_BASE+239)
#define V4L2_CID_CAMERA_FACTORY_LSC_REFERENCE (V4L2_CID_PRIVATE_BASE+240)

#define V4L2_CID_CAMERA_FACTORY_PUNT_SHORT_SCAN_DATA (V4L2_CID_PRIVATE_BASE+241)
#define V4L2_CID_CAMERA_FACTORY_PUNT_LONG_SCAN_DATA (V4L2_CID_PRIVATE_BASE+242)

#define V4L2_CID_CAMERA_PASM_MODE		(V4L2_CID_PRIVATE_BASE + 243)
enum set_camera_mode_Cmd {
	MODE_SMART_AUTO = 0,
	MODE_PROGRAM,
	MODE_A,
	MODE_S,
	MODE_M,
	MODE_VIDEO,
	MODE_BACKGROUND_BLUR,
	MODE_HIGH_SPEED,
	MODE_LIGHT_TRAIL_SHOT,
	MODE_WATERFALL,
	MODE_SILHOUETTE,
	MODE_SUNSET,
	MODE_CLOSE_UP,
	MODE_FIREWORKS,
	MODE_CROSS_FILTER,
	MODE_BACKLIGHT,
	MODE_BLUE_SKY,
	MODE_NATURAL_GREEN,
	MODE_BEST_GROUP_POSE,
	MODE_FOOD,
	MODE_START_FILTER,
	MODE_MOVING_SHOT,
};

#define V4L2_CID_CAMERA_SHUTTER_SPEED		(V4L2_CID_PRIVATE_BASE + 244)
#define V4L2_CID_CAMERA_F_NUMBER		(V4L2_CID_PRIVATE_BASE + 245)

#define V4L2_CID_CAMERA_IMAGE_STABILIZER       (V4L2_CID_PRIVATE_BASE + 246)
enum set_Image_Stabilizer {
	V4L2_IMAGE_STABILIZER_OFF = 0,
	V4L2_IMAGE_STABILIZER_OIS = 1,
	V4L2_IMAGE_STABILIZER_DUALIS = 2,
};

#define V4L2_CID_CAMERA_IS_OIS_MODE            (V4L2_CID_PRIVATE_BASE + 247)
enum set_IS_OIS_mode {
	V4L2_IS_OIS_NONE = 0,
	V4L2_IS_OIS_MOVIE = 1,
	V4L2_IS_OIS_STILL = 2,
	V4L2_IS_OIS_MULTI = 3,
	V4L2_IS_OIS_VSS = 4,
};

#define V4L2_CID_CAMERA_FACTORY_AE_TARGET (V4L2_CID_PRIVATE_BASE + 248)

#define V4L2_CID_CAMERA_AV		(V4L2_CID_PRIVATE_BASE + 249)
#define V4L2_CID_CAMERA_TV		(V4L2_CID_PRIVATE_BASE + 250)
#define V4L2_CID_CAMERA_SV		(V4L2_CID_PRIVATE_BASE + 251)
#define V4L2_CID_CAMERA_EV		(V4L2_CID_PRIVATE_BASE + 252)

#define V4L2_CID_CAMERA_SCENE_SUB_MODE		(V4L2_CID_PRIVATE_BASE + 253)

#define V4L2_CID_CAMERA_WB_CUSTOM_X		(V4L2_CID_PRIVATE_BASE + 254)
#define V4L2_CID_CAMERA_WB_CUSTOM_Y		(V4L2_CID_PRIVATE_BASE + 255)
#define V4L2_CID_CAMERA_WB_CUSTOM_VALUE		(V4L2_CID_PRIVATE_BASE + 256)

#define V4L2_CID_CAMERA_RED_EYE_FIX_RESULT     (V4L2_CID_PRIVATE_BASE + 257)
#define V4L2_CID_CAMERA_FACTORY_FLASH		(V4L2_CID_PRIVATE_BASE + 258)
enum set_Factory_Flash_Cmd {
	FACTORY_FLASH_STROBE_CHECK_ON = 0,
	FACTORY_FLASH_STROBE_CHECK_OFF = 1,
	FACTORY_FLASH_CHARGE = 2,
	FACTORY_FLASH_LOG = 3,
	FACTORY_FLASH_CHARGE_END_CHECK = 4,
	FACTORY_FLASH_STROBE_CHARGE_END_CHECK = 5,
	FACTORY_FLASH_WB_LOG = 6,
	FACTORY_ADJ_FLASH_WB_LOG = 7,
	FACTORY_ADJ_FLASH_WB_END_CHECK = 8,
};

#define V4L2_CID_CAMERA_FACTORY_WB		(V4L2_CID_PRIVATE_BASE + 259)
enum set_Factory_WB_Cmd {
	FACTORY_WB_INDOOR_RUN = 0,
	FACTORY_WB_INDOOR_END_CHECK = 1,
	FACTORY_WB_OUTDOOR_RUN = 2,
	FACTORY_WB_OUTDOOR_END_CHECK = 3,
	FACTORY_WB_LOG = 4,
};

#define V4L2_CID_CAMERA_FACTORY_FLASH_RANGE_X (V4L2_CID_PRIVATE_BASE + 260)
#define V4L2_CID_CAMERA_FACTORY_FLASH_RANGE_Y (V4L2_CID_PRIVATE_BASE + 261)

#define V4L2_CID_CAMERA_FACTORY_WB_IN_RG_VALUE (V4L2_CID_PRIVATE_BASE + 262)
#define V4L2_CID_CAMERA_FACTORY_WB_IN_BG_VALUE (V4L2_CID_PRIVATE_BASE + 263)
#define V4L2_CID_CAMERA_FACTORY_WB_OUT_RG_VALUE	(V4L2_CID_PRIVATE_BASE + 264)
#define V4L2_CID_CAMERA_FACTORY_WB_OUT_BG_VALUE	(V4L2_CID_PRIVATE_BASE + 265)

#define V4L2_CID_CAMERA_FACTORY_AFLED_RANGE_DATA_START_X \
	(V4L2_CID_PRIVATE_BASE + 266)
#define V4L2_CID_CAMERA_FACTORY_AFLED_RANGE_DATA_END_X \
	(V4L2_CID_PRIVATE_BASE + 267)
#define V4L2_CID_CAMERA_FACTORY_AFLED_RANGE_DATA_START_Y \
	(V4L2_CID_PRIVATE_BASE + 268)
#define V4L2_CID_CAMERA_FACTORY_AFLED_RANGE_DATA_END_Y \
	(V4L2_CID_PRIVATE_BASE + 269)

#define V4L2_CID_CAMERA_FACTORY_AF_LED_TIME (V4L2_CID_PRIVATE_BASE + 270)

#define V4L2_CID_CAMERA_FACTORY_AF_DIFF_CHECK_MIN (V4L2_CID_PRIVATE_BASE + 271)
#define V4L2_CID_CAMERA_FACTORY_AF_DIFF_CHECK_MAX (V4L2_CID_PRIVATE_BASE + 272)

#define V4L2_CID_CAMERA_FACTORY_DEFECTPIXEL	(V4L2_CID_PRIVATE_BASE + 273)
enum set_Factory_DefectPixel_Cmd {
	FACTORY_DEFECTPIXEL_SCENARIO_6 = 0,
	FACTORY_DEFECTPIXEL_RUN = 1,
	FACTORY_DEFECTPIXEL_END_CHECK = 2,
	FACTORY_DEFECTPIXEL_LOG = 3,
	FACTORY_DEFECTPIXEL_CID_1 = 4,
	FACTORY_DEFECTPIXEL_CID_2 = 5,
	FACTORY_DEFECTPIXEL_CID_3 = 6,
	FACTORY_DEFECTPIXEL_WRITE_BLACK = 7,
	FACTORY_DEFECTPIXEL_WRITE_WHITE = 8,
	FACTORY_DEFECTPIXEL_CID_WRITE = 9,
};

#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_CAP (V4L2_CID_PRIVATE_BASE + 274)
#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_DR0 (V4L2_CID_PRIVATE_BASE + 275)
#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_DR1 (V4L2_CID_PRIVATE_BASE + 276)
#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_DR2 (V4L2_CID_PRIVATE_BASE + 277)
#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_DR_HS (V4L2_CID_PRIVATE_BASE + 278)

#define V4L2_CID_CAMERA_FACTORY_AF_LED_LV_MIN (V4L2_CID_PRIVATE_BASE + 279)
#define V4L2_CID_CAMERA_FACTORY_AF_LED_LV_MAX (V4L2_CID_PRIVATE_BASE + 280)

#define V4L2_CID_CAMERA_FACTORY_CAM_SYS_MODE (V4L2_CID_PRIVATE_BASE + 281)
enum set_Factory_Sysmode_Cmd {
	FACTORY_SYSMODE_CAPTURE = 0,
	FACTORY_SYSMODE_MONITOR = 1,
	FACTORY_SYSMODE_PARAM = 2,
};

#define V4L2_CID_CAMERA_FACTORY_ISP_FW_CHECK (V4L2_CID_PRIVATE_BASE + 282)
#define V4L2_CID_CAMERA_FACTORY_OIS_VER_CHECK (V4L2_CID_PRIVATE_BASE + 283)

#define V4L2_CID_CAMERA_SMART_SCENE_DETECT    (V4L2_CID_PRIVATE_BASE+284)
enum set_smartscenedetect_mode {
	SMART_SCENE_DETECT_OFF = 0,
	SMART_SCENE_DETECT_ON = 1,
};
#define V4L2_CID_CAMERA_SMART_MOVIE_RECORDING    (V4L2_CID_PRIVATE_BASE+285)
#define V4L2_CID_CAMERA_SMART_AUTO_S1_PUSH    (V4L2_CID_PRIVATE_BASE+286)

#define V4L2_CID_CAMERA_FACTORY_WB_RANGE_FLASH_WRITE \
	(V4L2_CID_PRIVATE_BASE + 287)

#define V4L2_CID_CAMERA_FACTORY_FLASH_CHR_CHK_TM \
	(V4L2_CID_PRIVATE_BASE + 288)

#define V4L2_CID_CAMERA_EXIF_AV (V4L2_CID_PRIVATE_BASE + 289)
#define V4L2_CID_CAMERA_FACE_DETECT_NUMBER (V4L2_CID_PRIVATE_BASE+290)
#define V4L2_CID_CAMERA_EXIF_FL (V4L2_CID_PRIVATE_BASE + 291)

#define V4L2_CID_CAMERA_SMART_ZOOM             (V4L2_CID_PRIVATE_BASE + 292)
enum set_Smart_Zoom {
	V4L2_SMART_ZOOM_OFF = 0,
	V4L2_SMART_ZOOM_ON = 1,
};

#define V4L2_CID_CAMERA_CAF             (V4L2_CID_PRIVATE_BASE + 293)

#define V4L2_CID_CAMERA_FACTORY_LIVEVIEW_OFFSET_MARK \
	(V4L2_CID_PRIVATE_BASE + 294)
#define V4L2_CID_CAMERA_FACTORY_LIVEVIEW_OFFSET_VAL \
	(V4L2_CID_PRIVATE_BASE + 295)

#define V4L2_CID_CAMERA_FACTORY_CAPTURE_GAIN_OFFSET_MARK \
	(V4L2_CID_PRIVATE_BASE + 296)
#define V4L2_CID_CAMERA_FACTORY_CAPTURE_GAIN_OFFSET_VAL \
	(V4L2_CID_PRIVATE_BASE + 297)

#define V4L2_CID_CAMERA_FACTORY_WB_RANGE (V4L2_CID_PRIVATE_BASE + 298)

#define V4L2_CID_CAMERA_LV		(V4L2_CID_PRIVATE_BASE + 299)

#define V4L2_CID_PHYSICAL_ROTATION		(V4L2_CID_PRIVATE_BASE + 300)

#define V4L2_CID_CAMERA_FOCUS_RANGE	(V4L2_CID_PRIVATE_BASE + 301)
enum set_fouce_range {
	V4L2_FOCUS_RANGE_AUTO = 0,
	V4L2_FOCUS_RANGE_MACRO = 1,
	V4L2_FOCUS_RANGE_AUTO_MACRO = 2,
};

#define V4L2_CID_CAMERA_TIME_INFO              (V4L2_CID_PRIVATE_BASE + 302)

#define V4L2_CID_CAMERA_AF_LED                 (V4L2_CID_PRIVATE_BASE + 303)
enum set_AF_LED {
	V4L2_AF_LED_OFF = 0,
	V4L2_AF_LED_ON = 1,
};

#define V4L2_CID_CAMERA_LENS_TIMER             (V4L2_CID_PRIVATE_BASE + 304)

#define V4L2_CID_CAMERA_FLASH_BATT_INFO        (V4L2_CID_PRIVATE_BASE + 305)
enum set_FLASH_BATT_INFO {
	V4L2_FLASH_NORMAL_BATT = 0,
	V4L2_FLASH_LOW_BATT = 1,
};

#define V4L2_CID_CAMERA_STREAM_PART2     (V4L2_CID_PRIVATE_BASE + 306)

#define V4L2_CID_CAMERA_WIDGET_MODE_LEVEL    (V4L2_CID_PRIVATE_BASE+307)
enum v4l2_widget_mode_level {
	V4L2_WIDGET_MODE_LEVEL_0 = 0,
	V4L2_WIDGET_MODE_LEVEL_1,
	V4L2_WIDGET_MODE_LEVEL_2,
};

#define V4L2_CID_CAMERA_SMART_READ1            (V4L2_CID_PRIVATE_BASE + 308)
#define V4L2_CID_CAMERA_SMART_READ2            (V4L2_CID_PRIVATE_BASE + 309)

#define V4L2_CID_CAMERA_PREVIEW_WIDTH     (V4L2_CID_PRIVATE_BASE + 310)
#define V4L2_CID_CAMERA_PREVIEW_HEIGHT     (V4L2_CID_PRIVATE_BASE + 311)
#define V4L2_CID_CAMERA_PREVIEW_SIZE     (V4L2_CID_PRIVATE_BASE + 312)

#define V4L2_CID_CAMERA_WARNING_CONDITION	(V4L2_CID_PRIVATE_BASE + 313)
#define V4L2_CID_CAMERA_EXIF_FL_35mm		 (V4L2_CID_PRIVATE_BASE + 314)

/*      Pixel format FOURCC depth  Description  */
enum v4l2_pix_format_mode {
	V4L2_PIX_FMT_MODE_PREVIEW,
	V4L2_PIX_FMT_MODE_CAPTURE,
	V4L2_PIX_FMT_MODE_HDR,
	V4L2_PIX_FMT_MODE_VT_MIRROR,
	V4L2_PIX_FMT_MODE_VT_NONMIRROR,
};

#define V4L2_CID_SET_CONTINUE_FPS		(V4L2_CID_PRIVATE_BASE + 500)
#define V4L2_CID_CONTINUESHOT_PROC	(V4L2_CID_PRIVATE_BASE + 501)
enum v4l2_continuecshot_proc_state {
	V4L2_INT_STATE_FRAME_SYNC = 0,
	V4L2_INT_STATE_CAPTURE_SYNC,
	V4L2_INT_STATE_CONTINUE_CANCEL,
	V4L2_INT_STATE_CONTINUE_END,
	V4L2_INT_STATE_START_CAPTURE,
};

#define V4L2_CID_CAMERA_GET_MODE	(V4L2_CID_PRIVATE_BASE + 502)

#define V4L2_CID_CAMERA_FACTORY_SEND_SETTING \
	(V4L2_CID_PRIVATE_BASE + 503)
#define V4L2_CID_CAMERA_FACTORY_SEND_VALUE \
	(V4L2_CID_PRIVATE_BASE + 504)

#define V4L2_CID_CAMERA_FACTORY_TILT_SCAN_MIN \
	(V4L2_CID_PRIVATE_BASE + 505)
#define V4L2_CID_CAMERA_FACTORY_TILT_SCAN_MAX \
	(V4L2_CID_PRIVATE_BASE + 506)
#define V4L2_CID_CAMERA_FACTORY_TILT_FIELD \
	(V4L2_CID_PRIVATE_BASE + 507)
#define V4L2_CID_CAMERA_FACTORY_TILT_AF_RANGE_MIN \
	(V4L2_CID_PRIVATE_BASE + 508)
#define V4L2_CID_CAMERA_FACTORY_TILT_AF_RANGE_MAX \
	(V4L2_CID_PRIVATE_BASE + 509)
#define V4L2_CID_CAMERA_FACTORY_TILT_DIFF_RANGE_MIN \
	(V4L2_CID_PRIVATE_BASE + 510)
#define V4L2_CID_CAMERA_FACTORY_TILT_DIFF_RANGE_MAX \
	(V4L2_CID_PRIVATE_BASE + 511)

#define V4L2_CID_CAMERA_FACTORY_IR_R_GAIN_MIN \
	(V4L2_CID_PRIVATE_BASE + 512)
#define V4L2_CID_CAMERA_FACTORY_IR_R_GAIN_MAX \
	(V4L2_CID_PRIVATE_BASE + 513)
#define V4L2_CID_CAMERA_FACTORY_IR_B_GAIN_MIN \
	(V4L2_CID_PRIVATE_BASE + 514)
#define V4L2_CID_CAMERA_FACTORY_IR_B_GAIN_MAX \
	(V4L2_CID_PRIVATE_BASE + 515)

#define V4L2_CID_CAMERA_FACTORY_FLASH_MAN_CHARGE \
	(V4L2_CID_PRIVATE_BASE + 516)
#define V4L2_CID_CAMERA_FACTORY_FLASH_MAN_EN \
	(V4L2_CID_PRIVATE_BASE + 517)

#define V4L2_CID_CAMERA_FACTORY_SEND_WORD_VALUE \
	(V4L2_CID_PRIVATE_BASE + 518)
#define V4L2_CID_CAMERA_FACTORY_SEND_LONG_VALUE \
	(V4L2_CID_PRIVATE_BASE + 519)

#define V4L2_CID_CAMERA_FACTORY_DFPX_NLV_DR1_HD \
	(V4L2_CID_PRIVATE_BASE + 520)

#define V4L2_CID_BURSTSHOT_PROC	(V4L2_CID_PRIVATE_BASE + 521)
enum v4l2_burst_proc_state {
	V4L2_INT_STATE_BURST_START = 0,
	V4L2_INT_STATE_BURST_SYNC,
	V4L2_INT_STATE_BURST_STOP,
};

#define V4L2_CID_CAMERA_FACTORY_TILT \
	(V4L2_CID_PRIVATE_BASE + 522)
enum set_Factory_Tilt {
	FACTORY_TILT_ONE_SCRIPT_RUN = 0,
	FACTORY_TILT_ONE_SCRIPT_DISP1,
	FACTORY_TILT_ONE_SCRIPT_DISP2,
	FACTORY_TILT_ONE_SCRIPT_DISP3,
	FACTORY_TILT_ONE_SCRIPT_DISP4,
	FACTORY_TILT_ONE_SCRIPT_DISP5,
};

#define V4L2_CID_CAMERA_FACTORY_IR_CHECK \
	(V4L2_CID_PRIVATE_BASE + 523)
enum set_Factory_IR_Check {
	FACTORY_IR_CHECK_LOG = 0,
};

/* ISP DEBUG CODE  */
#define V4L2_CID_ISP_DEBUG_READ	(V4L2_CID_FIMC_IS_ISP_DBG_BASE + 1)
#define V4L2_CID_ISP_DEBUG_WRITE (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 2)
#define V4L2_CID_ISP_DEBUG_READ_MEM (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 3)
#define V4L2_CID_ISP_DEBUG_WRITE_MEM (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 4)
#define V4L2_CID_ISP_DEBUG_READ_FILE (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 5)
#define V4L2_CID_ISP_DEBUG_WRITE_FILE (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 6)
#define V4L2_CID_ISP_DEBUG_LOGV (V4L2_CID_FIMC_IS_ISP_DBG_BASE + 7)

/* 12  Y/CbCr 4:2:0 64x32 macroblocks */
#define V4L2_PIX_FMT_NV12T    v4l2_fourcc('T', 'V', '1', '2')
#define V4L2_PIX_FMT_NV21T    v4l2_fourcc('T', 'V', '2', '1')
#define V4L2_PIX_FMT_INTERLEAVED    v4l2_fourcc('I', 'T', 'L', 'V')

/*
 *  * V4L2 extention for digital camera
 *   */
/* Strobe flash light */
enum v4l2_strobe_control {
	/* turn off the flash light */
	V4L2_STROBE_CONTROL_OFF		= 0,
	/* turn on the flash light */
	V4L2_STROBE_CONTROL_ON		= 1,
	/* act guide light before splash */
	V4L2_STROBE_CONTROL_AFGUIDE	= 2,
	/* charge the flash light */
	V4L2_STROBE_CONTROL_CHARGE	= 3,
};

enum v4l2_strobe_conf {
	V4L2_STROBE_OFF			= 0,	/* Always off */
	V4L2_STROBE_ON			= 1,	/* Always splashes */
	/* Auto control presets */
	V4L2_STROBE_AUTO		= 2,
	V4L2_STROBE_REDEYE_REDUCTION	= 3,
	V4L2_STROBE_SLOW_SYNC		= 4,
	V4L2_STROBE_FRONT_CURTAIN	= 5,
	V4L2_STROBE_REAR_CURTAIN	= 6,
	/* Extra manual control presets */
	/* keep turned on until turning off */
	V4L2_STROBE_PERMANENT		= 7,
	V4L2_STROBE_EXTERNAL		= 8,
};

enum v4l2_strobe_status {
	V4L2_STROBE_STATUS_OFF		= 0,
	/* while processing configurations */
	V4L2_STROBE_STATUS_BUSY		= 1,
	V4L2_STROBE_STATUS_ERR		= 2,
	V4L2_STROBE_STATUS_CHARGING	= 3,
	V4L2_STROBE_STATUS_CHARGED	= 4,
};

/* capabilities field */
/* No strobe supported */
#define V4L2_STROBE_CAP_NONE		0x0000
/* Always flash off mode */
#define V4L2_STROBE_CAP_OFF		0x0001
/* Always use flash light mode */
#define V4L2_STROBE_CAP_ON		0x0002
/* Flashlight works automatic */
#define V4L2_STROBE_CAP_AUTO		0x0004
/* Red-eye reduction */
#define V4L2_STROBE_CAP_REDEYE		0x0008
/* Slow sync */
#define V4L2_STROBE_CAP_SLOWSYNC	0x0010
/* Front curtain */
#define V4L2_STROBE_CAP_FRONT_CURTAIN	0x0020
/* Rear curtain */
#define V4L2_STROBE_CAP_REAR_CURTAIN	0x0040
/* keep turned on until turning off */
#define V4L2_STROBE_CAP_PERMANENT	0x0080
/* use external strobe */
#define V4L2_STROBE_CAP_EXTERNAL	0x0100

/* Set mode and Get status */
struct v4l2_strobe {
	/* off/on/charge:0/1/2 */
	enum	v4l2_strobe_control control;
	/* supported strobe capabilities */
	__u32	capabilities;
	enum	v4l2_strobe_conf mode;
	enum	v4l2_strobe_status status;	/* read only */
/* default is 0 and range of value varies from each models */
	__u32	flash_ev;
	__u32	reserved[4];
};

#define VIDIOC_S_STROBE     _IOWR('V', 83, struct v4l2_strobe)
#define VIDIOC_G_STROBE     _IOR('V', 84, struct v4l2_strobe)

/* Object recognition and collateral actions */
enum v4l2_recog_mode {
	V4L2_RECOGNITION_MODE_OFF	= 0,
	V4L2_RECOGNITION_MODE_ON	= 1,
	V4L2_RECOGNITION_MODE_LOCK	= 2,
};

enum v4l2_recog_action {
	V4L2_RECOGNITION_ACTION_NONE	= 0,	/* only recognition */
	V4L2_RECOGNITION_ACTION_BLINK	= 1,	/* Capture on blinking */
	V4L2_RECOGNITION_ACTION_SMILE	= 2,	/* Capture on smiling */
};

enum v4l2_recog_pattern {
	V4L2_RECOG_PATTERN_FACE		= 0, /* Face */
	V4L2_RECOG_PATTERN_HUMAN	= 1, /* Human */
	V4L2_RECOG_PATTERN_CHAR		= 2, /* Character */
};

struct v4l2_recog_rect {
	enum	v4l2_recog_pattern  p;	/* detected pattern */
	struct	v4l2_rect  o;	/* detected area */
	__u32	reserved[4];
};

struct v4l2_recog_data {
	__u8	detect_cnt;		/* detected object counter */
	struct	v4l2_rect	o;	/* detected area */
	__u32	reserved[4];
};

struct v4l2_recognition {
	enum v4l2_recog_mode	mode;

	/* Which pattern to detect */
	enum v4l2_recog_pattern  pattern;

	/* How many object to detect */
	__u8	obj_num;

	/* select detected object */
	__u32	detect_idx;

	/* read only :Get object coordination */
	struct v4l2_recog_data	data;

	enum v4l2_recog_action	action;
	__u32	reserved[4];
};

#define VIDIOC_S_RECOGNITION	_IOWR('V', 85, struct v4l2_recognition)
#define VIDIOC_G_RECOGNITION	_IOR('V', 86, struct v4l2_recognition)

#endif /* __LINUX_VIDEODEV2_SAMSUNG_H */
