#ifndef __DALI_KEY_H__
#define __DALI_KEY_H__

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// EXTERNAL INCLUDES

#include <dali/public-api/events/key-event.h>

namespace Dali
{
/**
 * @addtogroup dali_adaptor_framework
 * @{
 */

/**
 * @brief Mapping of keyboard and mouse button event keycodes to platform specific codes.
 * @since_tizen 2.4
 */

enum KEY
{
  DALI_KEY_INVALID          = -1,	///< Invalid key value @since_tizen 2.4
  DALI_KEY_ESCAPE           = 9,	///< Escape key @since_tizen 2.4
  DALI_KEY_BACKSPACE        = 22,	///< Backspace key @since_tizen 2.4
  DALI_KEY_SHIFT_LEFT       = 50,	///< Shift Left key @since_tizen 2.4 
  DALI_KEY_SHIFT_RIGHT      = 62,	///< Shift Right key @since_tizen 2.4
  DALI_KEY_CURSOR_UP        = 111,	///< Cursor up key @since_tizen 2.4
  DALI_KEY_CURSOR_LEFT      = 113,	///< Cursor left key @since_tizen 2.4
  DALI_KEY_CURSOR_RIGHT     = 114,	///< Cursor right key @since_tizen 2.4
  DALI_KEY_CURSOR_DOWN      = 116,	///< Cursor down key @since_tizen 2.4
  DALI_KEY_BACK             = 166,	///< Back key @since_tizen 2.4
  DALI_KEY_CAMERA           = 167,	///< Camera key @since_tizen 2.4
  DALI_KEY_CONFIG           = 168,	///< Config key @since_tizen 2.4
  DALI_KEY_POWER            = 169,	///< Power key @since_tizen 2.4
  DALI_KEY_PAUSE            = 170,	///< Pause key @since_tizen 2.4
  DALI_KEY_CANCEL           = 171,	///< Cancel key @since_tizen 2.4
  DALI_KEY_PLAY_CD          = 172,	///< Play CD key @since_tizen 2.4
  DALI_KEY_STOP_CD          = 173,	///< Stop CD key @since_tizen 2.4
  DALI_KEY_PAUSE_CD         = 174,	///< Pause CD key @since_tizen 2.4
  DALI_KEY_NEXT_SONG        = 175,	///< Next song key @since_tizen 2.4
  DALI_KEY_PREVIOUS_SONG    = 176,	///< Previous song key @since_tizen 2.4
  DALI_KEY_REWIND           = 177,	///< Rewind key @since_tizen 2.4
  DALI_KEY_FASTFORWARD      = 178,	///< Fastforward key @since_tizen 2.4
  DALI_KEY_MEDIA            = 179,	///< Media key @since_tizen 2.4
  DALI_KEY_PLAY_PAUSE       = 180,	///< Play pause key @since_tizen 2.4
  DALI_KEY_MUTE             = 181,	///< Mute key @since_tizen 2.4
  DALI_KEY_MENU             = 182,	///< Menu key @since_tizen 2.4
  DALI_KEY_HOME             = 183,	///< Home key @since_tizen 2.4
  DALI_KEY_HOMEPAGE         = 187,	///< Homepage key @since_tizen 2.4
  DALI_KEY_WEBPAGE          = 188,	///< Webpage key @since_tizen 2.4
  DALI_KEY_MAIL             = 189,	///< Mail key @since_tizen 2.4
  DALI_KEY_SCREENSAVER      = 190,	///< Screensaver key @since_tizen 2.4
  DALI_KEY_BRIGHTNESS_UP    = 191,	///< Brightness up key @since_tizen 2.4
  DALI_KEY_BRIGHTNESS_DOWN  = 192,	///< Brightness down key @since_tizen 2.4
  DALI_KEY_SOFT_KBD         = 193,	///< Soft KBD key @since_tizen 2.4
  DALI_KEY_QUICK_PANEL      = 194,	///< Quick panel key @since_tizen 2.4
  DALI_KEY_TASK_SWITCH      = 195,	///< Task switch key @since_tizen 2.4
  DALI_KEY_APPS             = 196,	///< Apps key @since_tizen 2.4
  DALI_KEY_SEARCH           = 197,	///< Search key @since_tizen 2.4
  DALI_KEY_VOICE            = 198,	///< Voice key @since_tizen 2.4
  DALI_KEY_LANGUAGE         = 199,	///< Language key @since_tizen 2.4
  DALI_KEY_VOLUME_UP        = 200,	///< Volume up key @since_tizen 2.4
  DALI_KEY_VOLUME_DOWN      = 201	///< Volume down key @since_tizen 2.4
};

/**
 * @brief Check if a key event is for a specific DALI KEY.
 *
 * @since_tizen 2.4
 * @param keyEvent reference to a keyEvent structure
 * @param daliKey dali key enum
 * @return True if the key is matched, false if not
 */
DALI_IMPORT_API bool IsKey( const Dali::KeyEvent& keyEvent, Dali::KEY daliKey);

/**
 * @}
 */
} // namespace Dali

#endif // __DALI_KEY_H__
