#ifndef _ELM_COLOR_ITEM_EO_H_
#define _ELM_COLOR_ITEM_EO_H_

#ifndef _ELM_COLOR_ITEM_EO_CLASS_TYPE
#define _ELM_COLOR_ITEM_EO_CLASS_TYPE

typedef Eo Elm_Color_Item;

#endif

#ifndef _ELM_COLOR_ITEM_EO_TYPES
#define _ELM_COLOR_ITEM_EO_TYPES


#endif
#define ELM_COLOR_ITEM_CLASS elm_color_item_class_get()

const Eo_Class *elm_color_item_class_get(void) EINA_CONST;

/**
 *
 * @internal
 *
 * Set Palette item's color.
 *
 * @ingroup Colorselector
 *
 * @param[in] r red-value of color
 * @param[in] g green-value of color
 * @param[in] b blue-value of color
 * @param[in] a alpha-value of color
 *
 */
EOAPI void  elm_obj_color_item_color_set(int r, int g, int b, int a);

/**
 *
 * @internal
 *
 * Get Palette item's color.
 *
 * @ingroup Colorselector
 *
 * @param[out] r red-value of color
 * @param[out] g green-value of color
 * @param[out] b blue-value of color
 * @param[out] a alpha-value of color
 *
 */
EOAPI void  elm_obj_color_item_color_get(int *r, int *g, int *b, int *a);

/**
 *
 * @internal
 *
 * Set the selected state of color palette item
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 * @param[in] selected @c EINA_TRUE if selected @c EINA_FALSE otherwise
 *
 */
EOAPI void  elm_obj_color_item_selected_set(Eina_Bool selected);

/**
 *
 * @internal
 *
 * Get the selected state of color palette item
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 *
 */
EOAPI Eina_Bool  elm_obj_color_item_selected_get(void);


#endif
