/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.TimerTask;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.tizen.ecp.location.LocationCommonControl;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationInjector;
import org.tizen.ecp.location.LocationPane;
import org.tizen.ecp.location.model.GeoLocation;
import org.tizen.ecp.location.model.GeoLocationVO;
import org.tizen.ecp.utils.LogUtil;

public class LocationManualController
extends LocationCommonControl {
    Logger logger = LogUtil.getECPLogger(LocationManualController.class).getLogger();
    @FXML
    AnchorPane rootPane;
    @FXML
    TextField textLatitude;
    @FXML
    TextField textLongitude;
    @FXML
    TextField textAltitude;
    @FXML
    TextField textHorizontal;
    @FXML
    Button buttonInjectMaunalLocation;
    @FXML
    Button buttonResetManualLocation;
    @FXML
    Button buttonCancelManualLocation;
    private InjectTask task = null;
    private LocationInjector injector = null;
    private ArrayList<GeoLocationVO> locationVO = new ArrayList();

    @FXML
    public void OnClickInjectManualLocation(ActionEvent actionEvent) {
        this.buttonInjectMaunalLocation.setDisable(true);
        this.textLatitude.getText();
        Double d = Double.parseDouble(this.textLatitude.getText().trim());
        Double d2 = Double.parseDouble(this.textLongitude.getText().trim());
        Double d3 = Double.parseDouble(this.textAltitude.getText().trim());
        Double d4 = Double.parseDouble(this.textHorizontal.getText().trim());
        this.logger.info("latitude: " + d + ", longitude: " + d2 + ", altitude: " + d3 + ", accuracy: " + d4);
        String string = LocationConstants.DF.format(d);
        String string2 = LocationConstants.DF.format(d2);
        String string3 = LocationConstants.DF.format(d3);
        String string4 = LocationConstants.DF.format(d4);
        GeoLocationVO geoLocationVO = new GeoLocationVO();
        GeoLocation geoLocation = new GeoLocation(string, string2, string3, string4);
        geoLocationVO.setLocation(geoLocation);
        this.locationVO.add(geoLocationVO);
        this.task = new InjectTask();
        this.startTask(this.task);
        this.buttonCancelManualLocation.setDisable(false);
        LocationPane.logController.rootPane.setDisable(true);
        LocationPane.mapController.rootPane.setDisable(true);
        this.setTextFieldsDisabled(true);
        this.buttonResetManualLocation.setDisable(true);
    }

    private void setTextFieldsDisabled(boolean bl) {
        this.textLatitude.setDisable(bl);
        this.textLongitude.setDisable(bl);
        this.textAltitude.setDisable(bl);
        this.textHorizontal.setDisable(bl);
    }

    @FXML
    public void OnClickResetManualLocation(ActionEvent actionEvent) {
        this.textLatitude.clear();
        this.textLongitude.clear();
        this.textAltitude.clear();
        this.textHorizontal.clear();
        this.buttonResetManualLocation.setDisable(true);
    }

    @FXML
    public void OnClickCancelManualLocation(ActionEvent actionEvent) {
        this.stopTask();
        this.buttonInjectMaunalLocation.setDisable(!this.validateManualValues());
        this.buttonCancelManualLocation.setDisable(true);
        LocationPane.logController.rootPane.setDisable(false);
        LocationPane.mapController.rootPane.setDisable(false);
        this.buttonResetManualLocation.setDisable(false);
        this.setTextFieldsDisabled(false);
        this.buttonResetManualLocation.setDisable(false);
    }

    private void verifyText(TextField textField, String string, String string2, int n, int n2) {
        block7: {
            char[] cArray = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '+' || cArray[i] == '-') continue;
                textField.setText(string);
                break;
            }
            if (string2.isEmpty()) {
                return;
            }
            char[] cArray2 = string2.toCharArray();
            try {
                int n3 = 0;
                int n4 = 0;
                double d = Double.valueOf(string2);
                for (int i = 0; i < cArray2.length; ++i) {
                    if (cArray2[i] != '.') continue;
                    n3 = i;
                    break;
                }
                if ((n4 = cArray2.length - n3) > 7) {
                    textField.setText(string);
                    return;
                }
                if (d < (double)n || d > (double)n2) {
                    textField.setText(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (cArray2[0] == '-' || cArray2[0] == '+') break block7;
                textField.setText(string);
            }
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.buttonCancelManualLocation.setDisable(true);
        this.buttonInjectMaunalLocation.setDisable(true);
        this.buttonResetManualLocation.setDisable(true);
        this.textLatitude.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                LocationManualController.this.verifyText(LocationManualController.this.textLatitude, string, string2, -90, 90);
                LocationManualController.this.buttonInjectMaunalLocation.setDisable(!LocationManualController.this.validateManualValues());
                if (LocationManualController.this.validateManualValues(LocationManualController.this.textLatitude, -90, 90)) {
                    LocationManualController.this.buttonResetManualLocation.setDisable(false);
                }
            }
        });
        this.textLongitude.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                LocationManualController.this.verifyText(LocationManualController.this.textLongitude, string, string2, -180, 180);
                LocationManualController.this.buttonInjectMaunalLocation.setDisable(!LocationManualController.this.validateManualValues());
                if (LocationManualController.this.validateManualValues(LocationManualController.this.textLongitude, -180, 180)) {
                    LocationManualController.this.buttonResetManualLocation.setDisable(false);
                }
            }
        });
        this.textAltitude.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                LocationManualController.this.verifyText(LocationManualController.this.textAltitude, string, string2, -300, 100000);
                LocationManualController.this.buttonInjectMaunalLocation.setDisable(!LocationManualController.this.validateManualValues());
                if (LocationManualController.this.validateManualValues(LocationManualController.this.textAltitude, -300, 100000)) {
                    LocationManualController.this.buttonResetManualLocation.setDisable(false);
                }
            }
        });
        this.textHorizontal.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                LocationManualController.this.verifyText(LocationManualController.this.textHorizontal, string, string2, 0, 100000);
                LocationManualController.this.buttonInjectMaunalLocation.setDisable(!LocationManualController.this.validateManualValues());
                if (LocationManualController.this.validateManualValues(LocationManualController.this.textHorizontal, 0, 100000)) {
                    LocationManualController.this.buttonResetManualLocation.setDisable(false);
                }
            }
        });
    }

    private boolean validateManualValues(TextField textField, int n, int n2) {
        double d;
        if (textField == null) {
            return false;
        }
        if (!textField.getText().matches("[+|-]*[0-9]*[.]?[0-9]+")) {
            this.buttonInjectMaunalLocation.setDisable(true);
            return false;
        }
        try {
            d = Double.parseDouble(this.textLatitude.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return !(d > (double)n2) && !(d < (double)n);
    }

    private boolean validateManualValues() {
        if (!this.validateManualValues(this.textLatitude, -90, 90)) {
            return false;
        }
        if (!this.validateManualValues(this.textLongitude, -180, 180)) {
            return false;
        }
        if (!this.validateManualValues(this.textAltitude, -300, 100000)) {
            return false;
        }
        return this.validateManualValues(this.textHorizontal, 0, 100000);
    }

    protected void setLocation(String string, String string2, String string3, String string4) {
        if (this.textLatitude.isDisabled()) {
            this.logger.info("text field is disabled");
            return;
        }
        if (string == null) {
            this.textLatitude.clear();
        } else {
            this.checkSameAndInsert(this.textLatitude, string);
        }
        if (string2 == null) {
            this.textLongitude.clear();
        } else {
            this.checkSameAndInsert(this.textLongitude, string2);
        }
        if (string3 == null) {
            this.textAltitude.clear();
        } else {
            this.checkSameAndInsert(this.textAltitude, string3);
        }
        if (string4 == null) {
            this.textHorizontal.clear();
        } else {
            this.checkSameAndInsert(this.textHorizontal, string4);
        }
    }

    private void checkSameAndInsert(TextField textField, String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = Double.parseDouble(textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (d != d2) {
            textField.setText(string);
        }
    }

    class InjectTask
    extends TimerTask {
        InjectTask() {
        }

        @Override
        public void run() {
            LocationManualController.this.injector = new LocationInjector();
            if (!LocationManualController.this.injector.inject(LocationManualController.this.locationVO)) {
                LocationManualController.this.stopTask();
            }
        }
    }
}

