/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import org.tizen.ecp.nfc.ui.FileListingService;
import org.tizen.ecp.nfc.ui.FileTreeData;

class ItemAddWorker
extends Thread {
    TreeItem<FileTreeData> parent;
    FileListingService.FileEntry fileEntry;
    List<FileListingService.FileEntry> entries = new ArrayList<FileListingService.FileEntry>();
    Thread fileListingWorker = new Thread(new Runnable(){

        @Override
        public void run() {
            FileListingService.FileEntry[] fileEntryArray;
            for (FileListingService.FileEntry fileEntry : fileEntryArray = ItemAddWorker.this.fileEntry.getFileListingService().getChildren(ItemAddWorker.this.fileEntry, true, null)) {
                ItemAddWorker.this.entries.add(fileEntry);
            }
        }
    });
    Runnable treeAddWorker = new Runnable(){

        @Override
        public void run() {
            ItemAddWorker.this.parent.getChildren().clear();
            for (FileListingService.FileEntry fileEntry : ItemAddWorker.this.entries) {
                TreeItem treeItem = new TreeItem((Object)new FileTreeData(fileEntry));
                ItemAddWorker.this.parent.getChildren().add((Object)treeItem);
                if (((FileTreeData)treeItem.getValue()).isDirectory()) {
                    treeItem.getChildren().add((Object)new TreeItem());
                }
                ItemAddWorker.this.addExpandListener((TreeItem<FileTreeData>)treeItem);
            }
            ((FileTreeData)ItemAddWorker.this.parent.getValue()).setTreeItemState(FileTreeData.TreeItemState.CHILD_CHECKED);
        }
    };

    public ItemAddWorker(FileListingService.FileEntry fileEntry, TreeItem<FileTreeData> treeItem) {
        this.fileEntry = fileEntry;
        this.parent = treeItem;
    }

    @Override
    public void run() {
        this.fileListingWorker.start();
        try {
            this.fileListingWorker.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Platform.runLater((Runnable)this.treeAddWorker);
    }

    private void addExpandListener(final TreeItem<FileTreeData> treeItem) {
        treeItem.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2 == null || ((FileTreeData)treeItem.getValue()).isChildChecking() || ((FileTreeData)treeItem.getValue()).isChildChecked()) {
                    return;
                }
                if (bl2.booleanValue()) {
                    ((FileTreeData)treeItem.getValue()).setTreeItemState(FileTreeData.TreeItemState.CHILD_CHECKING);
                    new ItemAddWorker(((FileTreeData)treeItem.getValue()).getFileEntry(), (TreeItem<FileTreeData>)treeItem).start();
                }
            }
        });
    }
}

