/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sdcard.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sdcard.SDCardAttachHelper;
import org.tizen.ecp.sdcard.ui.SDCardController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class SDCardPane
extends ECPPopupPane {
    private static final URL SDCARD_CSS = SDCardPane.class.getResource("SDCard.css");
    Logger logger = LogUtil.getECPLogger(SDCardPane.class).getLogger();
    SDCardController controller;

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sdcard", (ILsn)this);
        this.sendStatus();
    }

    public void onShow() {
        this.sendStatus();
    }

    public void sendStatus() {
        SDCardAttachHelper.getInstance().sendSDcard("2\n");
    }

    public Pane create() {
        AnchorPane anchorPane;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("SDCardPopup.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
            anchorPane.getStylesheets().add((Object)SDCARD_CSS.toExternalForm());
            this.controller = (SDCardController)eCPFXMLLoader.getController();
        }
        catch (IOException iOException) {
            this.logger.warning(iOException.getMessage());
            return null;
        }
        return anchorPane;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        long l = deviceNtf.getGroup();
        long l2 = deviceNtf.getAction();
        String string2 = deviceNtf.getData().toStringUtf8();
        if (l == 11L) {
            this.logger.info("action: " + l2);
            switch ((int)l2) {
                case 0: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.setCardDescription("");
                    this.logger.info("detached: " + string2);
                    this.controller.setAttached(false);
                    this.controller.umntButtonClick();
                    break;
                }
                case 1: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("attached: " + string2);
                    int n = string2.indexOf("_");
                    int n2 = string2.indexOf(".");
                    this.setCardDescription(string2.substring(n + 1, n2));
                    if (this.controller == null) break;
                    this.controller.setAttached(true);
                    try {
                        Thread.sleep(2000L);
                        this.controller.setComboValue(string2);
                        this.controller.mntButtonClick();
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.severe(interruptedException.getMessage());
                    }
                    break;
                }
                case 2: {
                    this.logger.info("detached status: ");
                    this.setCardDescription("");
                    if (this.controller == null) break;
                    this.controller.setAttached(false);
                    SDCardAttachHelper.getInstance().setDataWaiting(false);
                    this.controller.umntButtonClick();
                    break;
                }
                case 3: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("attached status: " + string2);
                    if (string2.equals("detached")) {
                        this.setCardDescription("");
                        if (this.controller == null) break;
                        this.controller.umntButtonClick();
                        this.controller.setAttached(false);
                        SDCardAttachHelper.getInstance().setDataWaiting(false);
                        break;
                    }
                    String string3 = string2.split("\\r?\\n")[1];
                    this.logger.info("sdcard is " + string3);
                    int n = string3.lastIndexOf(File.separator);
                    String string4 = string3.substring(n + 1);
                    int n3 = string4.indexOf("_");
                    int n4 = string4.indexOf(".");
                    this.setCardDescription(string4.substring(n3 + 1, n4));
                    if (this.controller == null) break;
                    this.controller.setAttached(true);
                    this.controller.setComboValue(string4);
                    SDCardAttachHelper.getInstance().setDataWaiting(false);
                    this.controller.mntButtonClick();
                    break;
                }
                case 4: {
                    this.logger.info("detach failed");
                    this.controller.setAttached(false);
                    MessageBox.error((String)(DeviceMessages.getString("SDCardDisplay.22") + this.controller.getComboValue() + DeviceMessages.getString("SDCardDisplay.23")));
                    this.controller.mntButtonClick();
                    break;
                }
                case 5: {
                    if (this.controller.isAttached()) {
                        this.logger.info("attach failed, but ignore");
                        this.controller.umntButtonClick();
                        break;
                    }
                    this.logger.info("attach failed");
                    MessageBox.error((String)(string2 + DeviceMessages.getString("SDCardDisplay.25")));
                    this.controller.umntButtonClick();
                    break;
                }
                case 6: {
                    this.logger.info("detach failed");
                    break;
                }
                default: {
                    this.logger.severe("wrong action value: " + l2);
                }
            }
        }
    }
}

