/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.pedometer;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.Pane;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.pedometer.PedometerModel;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class PedometerPane
extends ECPPopupPane {
    private static Logger logger = LogUtil.getECPLogger(PedometerPane.class).getLogger();
    private PedometerModel model = new PedometerModel();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 119);
    }

    public void onShow() {
        int n = this.model.getStatus().get();
        if (n == 1) {
            this.model.getStop().setSelected(true);
        } else if (n == 2) {
            this.model.getWalk_slow().setSelected(true);
        } else if (n == 3) {
            this.model.getWalk().setSelected(true);
        } else if (n == 4) {
            this.model.getRun_slow().setSelected(true);
        } else if (n == 5) {
            this.model.getRun().setSelected(true);
        } else {
            logger.warning("Unsupported value: " + n);
        }
    }

    public Pane create() {
        Pane pane = null;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/sensor/pedometer/Pedometer.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[]{this.model});
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return pane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (generatedMessage instanceof Ecs.DeviceNtf && 119 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction()) {
            String string = deviceNtf.getData().toStringUtf8();
            if (string.equals(Integer.toString(1))) {
                this.model.setStatus(1);
                this.setCardDescription("Stop");
            } else if (string.equals(Integer.toString(2))) {
                this.model.setStatus(2);
                this.setCardDescription("Walk Slowly");
            } else if (string.equals(Integer.toString(3))) {
                this.model.setStatus(3);
                this.setCardDescription("Walk");
            } else if (string.equals(Integer.toString(4))) {
                this.model.setStatus(4);
                this.setCardDescription("Run Slowly");
            } else if (string.equals(Integer.toString(5))) {
                this.model.setStatus(5);
                this.setCardDescription("Run");
            } else {
                logger.warning("unsupported data: " + string);
            }
        }
    }
}

