/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.hds.cli;

import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class HDSMountCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(HDSMountCLI.class).getLogger();
    @Argument(index=0, required=true)
    String hostPath;
    @Argument(index=1, required=true)
    String guestPath;
    @Argument(index=2, required=false)
    String hidden;

    public HDSMountCLI() {
        this.messageType = "hds";
    }

    public int execute() {
        int n = 0;
        if (this.hostPath == null || this.hostPath.isEmpty() || this.guestPath == null || this.guestPath.isEmpty()) {
            OutputUtil.printHelpError((String)DeviceMessages.getString("HDSMountCLI.2"), (String)this.help);
            return 25;
        }
        File file = new File(this.hostPath);
        if (!file.exists()) {
            OutputUtil.printHelpError((String)(DeviceMessages.getString("HDSMountCLI.3") + this.hostPath + DeviceMessages.getString("HDSMountCLI.4")), (String)this.help);
            return 25;
        }
        if (!file.isDirectory()) {
            OutputUtil.printHelpError((String)(DeviceMessages.getString("HDSMountCLI.5") + this.hostPath + DeviceMessages.getString("HDSMountCLI.6")), (String)this.help);
            return 25;
        }
        if (!this.guestPath.startsWith("/mnt/") || this.guestPath.length() <= 5) {
            OutputUtil.printHelpError((String)(DeviceMessages.getString("HDSMountCLI.7") + DeviceMessages.getString("HDSMountCLI.8") + this.guestPath), (String)this.help);
            return 25;
        }
        if (this.hidden != null && "hidden".equals(this.hidden)) {
            n = 1;
        }
        String string = file.getAbsolutePath() + "\n" + this.guestPath + "\n" + n + "\n";
        MessageSender.getInstance().sendDeviceReq("hds", 100, 1, string);
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (generatedMessage instanceof Ecs.DeviceNtf && 100 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getGroup()) {
            int n = deviceNtf.getAction();
            logger.info("HDSMountCLI action: " + n);
            switch (n) {
                case 1: {
                    OutputUtil.printOK();
                    MessageSender.getInstance().sendDeviceReq("hds", 15, 99);
                    break;
                }
                case 2: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.14"));
                    this.returnValue = 25;
                    break;
                }
                case 11: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.15"), (String)DeviceMessages.getString("HDSMountCLI.16"));
                    this.returnValue = 25;
                    break;
                }
                case 12: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.17"), (String)DeviceMessages.getString("HDSMountCLI.18"));
                    this.returnValue = 25;
                    break;
                }
                case 21: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.19"));
                    this.returnValue = 25;
                    break;
                }
                case 22: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.20"));
                    this.returnValue = 25;
                    break;
                }
                case 23: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSMountCLI.21"));
                    this.returnValue = 25;
                    break;
                }
                case 98: {
                    return;
                }
                default: {
                    logger.info("HDSMountCLI unknown action notification: " + n);
                    this.returnValue = 128;
                }
            }
            this.stopRunning();
        }
    }
}

