/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.cli;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.cli.NFCCLIHelper;
import org.tizen.ecp.nfc.cli.NFCTagType;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class NFCTagCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(NFCTagCLI.class).getLogger();
    @Argument(required=true, index=0, metaVar="attach detach")
    String event;
    @Argument(required=false, index=1)
    String type;
    @Argument(required=false, index=2)
    String message;

    public NFCTagCLI() {
        this.messageType = "nfc";
    }

    public void printHelp() {
        super.printHelp();
    }

    public int execute() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
        this.startRunning();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        block10: {
            if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
                return;
            }
            NFCCLIHelper nFCCLIHelper = null;
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            String string = deviceNtf.getData().toStringUtf8();
            boolean bl = true;
            try {
                nFCCLIHelper = new NFCCLIHelper(string);
                if (this.event.equals("attach")) {
                    nFCCLIHelper.sendTagDiscovered(this.getTagType(), this.message);
                    break block10;
                }
                if (this.event.equals("detach")) {
                    if (this.message != null || this.type != null) {
                        throw new NFCEventException(NFCErrorString.WrongArgument);
                    }
                    nFCCLIHelper.sendTagDetached();
                    break block10;
                }
                throw new NFCEventException(NFCErrorString.WrongArgument);
            }
            catch (NFCEventException nFCEventException) {
                bl = false;
                OutputUtil.printError((String)nFCEventException.getMessage());
                this.returnValue = 1;
            }
            finally {
                if (bl) {
                    MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
                }
                this.message = null;
                this.type = null;
                this.stopRunning();
            }
        }
    }

    private NFCTagType getTagType() throws NFCEventException {
        NFCTagType nFCTagType = null;
        for (NFCTagType nFCTagType2 : NFCTagType.values()) {
            if (!nFCTagType2.getShortName().equals(this.type)) continue;
            nFCTagType = nFCTagType2;
            break;
        }
        if (nFCTagType == null) {
            throw new NFCEventException(NFCErrorString.WrongTagType);
        }
        return nFCTagType;
    }
}

