/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.tizen.ecp.nfc.ui.FileTreeData;
import org.tizen.ecp.resources.Images;

public class FileTreeCell
extends TreeCell<FileTreeData> {
    static final Color TEXT_FILL_NORMAL = Color.web((String)"#585858");
    Label iconLabel;
    Label pathLabel;
    FileTreeData treeData;
    private HBox hBox;

    protected void updateItem(FileTreeData fileTreeData, boolean bl) {
        super.updateItem((Object)fileTreeData, bl);
        this.setGraphic(null);
        if (bl) {
            return;
        }
        this.hBox = new HBox();
        this.hBox.setAlignment(Pos.CENTER_LEFT);
        if (fileTreeData == null) {
            ProgressIndicator progressIndicator = new ProgressIndicator();
            progressIndicator.setProgress(-1.0);
            progressIndicator.setPrefSize(15.0, 15.0);
            this.hBox.getChildren().addAll((Object[])new Node[]{progressIndicator, new Label(" (listing files...)  ")});
            this.setGraphic((Node)this.hBox);
            return;
        }
        this.treeData = fileTreeData;
        this.iconLabel = new Label();
        this.pathLabel = new Label(fileTreeData.getFileName());
        this.hBox.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.pathLabel});
        this.pathLabel.setTextFill((Paint)TEXT_FILL_NORMAL);
        int n = fileTreeData.getFileType();
        switch (n) {
            case 5: {
                this.iconLabel.setGraphic((Node)Images.getImageView((String)"NFC", (String)"file_link.gif"));
                break;
            }
            case 1: {
                this.iconLabel.setGraphic((Node)Images.getImageView((String)"NFC", (String)"directory.gif"));
                break;
            }
            case 2: {
                this.iconLabel.setGraphic((Node)Images.getImageView((String)"NFC", (String)"directory_link.gif"));
                break;
            }
            default: {
                this.iconLabel.setGraphic((Node)Images.getImageView((String)"NFC", (String)"file.gif"));
            }
        }
        this.setGraphic((Node)this.hBox);
    }

    static Callback<TreeView<FileTreeData>, TreeCell<FileTreeData>> extractor() {
        return new Callback<TreeView<FileTreeData>, TreeCell<FileTreeData>>(){

            public TreeCell<FileTreeData> call(TreeView<FileTreeData> treeView) {
                return new FileTreeCell();
            }
        };
    }
}

