/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.cli;

import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.call.G02A31;

public class TelephonyMessage {
    private boolean isInitialized = false;
    private static TelephonyMessage instance = new TelephonyMessage();
    private boolean rssiStatus = true;

    public static TelephonyMessage getInstance() {
        return instance;
    }

    public void setRssiStatus(boolean bl) {
        this.rssiStatus = bl;
        if (!bl) {
            // empty if block
        }
    }

    public boolean getRssiStatus() {
        return this.rssiStatus;
    }

    public void init() {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
        this.sendNetStatus(true);
        this.sendAskData();
    }

    public void sendInitialize() {
        byte[] byArray = new byte[]{22, 0, 0, 0};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 65, byArray);
        byte[] byArray2 = new byte[]{0, 0, 64, 66};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 71, byArray2);
        this.isInitialized = true;
    }

    public void sendNetStatus(boolean bl) {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        int n = 2;
        int n2 = 1;
        int n3 = bl ? 1 : 0;
        int n4 = 0;
        int n5 = 17;
        int n6 = 32;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 10;
        int n11 = 0;
        G02A31 g02A31 = new G02A31();
        g02A31.intialize();
        StructureGA structureGA = g02A31.getBody();
        structureGA.setInt("NET_ACT_TYPE", n);
        structureGA.setInt("NET_SVC_DOMAIN", n2);
        structureGA.setInt("NET_REG_STATUS", n3);
        structureGA.setInt("NET_EDGE_SUPPORT", n4);
        structureGA.setInt("LAC0", n5);
        structureGA.setInt("LAC1", n6);
        structureGA.setInt("CELL_ID0", n7);
        structureGA.setInt("CELL_ID1", n8);
        structureGA.setInt("CELL_ID2", n9);
        structureGA.setInt("CELL_ID3", n10);
        structureGA.setInt("REJ_CAUSE", n11);
        byte[] byArray = g02A31.makePacket();
        try {
            MessageSender.getInstance().sendInjectorReq("telephony", 49, 2, byArray);
            this.setRssiStatus(bl);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean send(AbstractGA abstractGA) {
        return MessageSender.getInstance().sendInjectorReq("telephony", abstractGA.getGroupID(), abstractGA.getActionID(), abstractGA.makePacket());
    }

    public boolean sendAskData() {
        int n = 17;
        int n2 = 91;
        String string = "";
        this.isInitialized = true;
        boolean bl = MessageSender.getInstance().sendInjectorReq("telephony", n, n2, string);
        return bl;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

