/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.accelerometer;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.tizen.ecp.control.TizenTextField;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.axis.accelerometer.AccConstants;
import org.tizen.ecp.sensor.axis.accelerometer.AccelFileOperation;
import org.tizen.ecp.sensor.axis.fxml.FXMLSensorViewController;
import org.tizen.ecp.sensor.axis.fxml.SliderChangeListener;
import org.tizen.ecp.sock.MessageSender;

public class AccelViewController
extends FXMLSensorViewController {
    private DecimalFormat df = new DecimalFormat("0.##");
    private int ACCEL_ADJUST = 100000;
    private double G = 9.80665;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.initialize();
        this.fxNameLab.setText("Acceleration");
        String string = "[0-9.-]";
        this.fxXTxt.setMatchStr(string);
        this.fxYTxt.setMatchStr(string);
        this.fxZTxt.setMatchStr(string);
        this.fxXTxt.setMaxLen(5);
        this.fxYTxt.setMaxLen(5);
        this.fxZTxt.setMaxLen(5);
        this.fxXUnitLab.setText("[g]");
        this.fxYUnitLab.setText("[g]");
        this.fxZUnitLab.setText("[g]");
        this.createSlider(this.fxXSlider);
        this.createSlider(this.fxYSlider);
        this.createSlider(this.fxZSlider);
        this.fxXTxt.setText(this.df.format(this.fxXSlider.getValue()));
        this.fxYTxt.setText(this.df.format(this.fxYSlider.getValue()));
        this.fxZTxt.setText(this.df.format(this.fxZSlider.getValue()));
        this.setFileOperation(new AccelFileOperation());
        this.addListener();
    }

    private void addListener() {
        this.fxXSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxXTxt, this.df));
        this.fxYSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxYTxt, this.df));
        this.fxZSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxZTxt, this.df));
    }

    @Override
    protected void onEnterToTextField(TizenTextField tizenTextField, Slider slider) {
        String string = tizenTextField.getText();
        try {
            Double d = Double.parseDouble(string);
            if (d < -2.0 || d > 2.0) {
                throw new Exception();
            }
            slider.setValue(d.doubleValue());
        }
        catch (Exception exception) {
            String string2 = AccConstants.INFO_RANGE_OUT_BEGIN + -2.0 + AccConstants.INFO_RANGE_OUT_TO + 2.0 + ".";
            MessageBox.error((String)"Emulator Control Panel", (String)string2);
            tizenTextField.setText(this.df.format(slider.getValue()));
            return;
        }
    }

    private void createSlider(Slider slider) {
        slider.setMin(-2.0);
        slider.setMax(2.0);
        slider.setValue(0.0);
    }

    @Override
    public void sendMessage() {
        double d = (double)Math.round(this.fxXSlider.getValue() * 100.0) / 100.0;
        double d2 = (double)Math.round(this.fxYSlider.getValue() * 100.0) / 100.0;
        double d3 = (double)Math.round(this.fxZSlider.getValue() * 100.0) / 100.0;
        InjectorMessage injectorMessage = new InjectorMessage(d * this.G * (double)this.ACCEL_ADJUST, d2 * this.G * (double)this.ACCEL_ADJUST, d3 * this.G * (double)this.ACCEL_ADJUST);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "1\n" + injectorMessage.getMessage());
    }

    @Override
    public void setStatus(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        int n = 980665;
        String[] stringArray = string.split(",");
        Double d = Double.parseDouble(stringArray[0]) / (double)n;
        Double d2 = Double.parseDouble(stringArray[1]) / (double)n;
        Double d3 = Double.parseDouble(stringArray[2]) / (double)n;
        double d4 = (double)Math.round(d * 100.0) / 100.0;
        double d5 = (double)Math.round(d2 * 100.0) / 100.0;
        double d6 = (double)Math.round(d3 * 100.0) / 100.0;
        this.fxXSlider.setValue(d4);
        this.fxYSlider.setValue(d5);
        this.fxZSlider.setValue(d6);
    }
}

