/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.cli.sms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.cli.TelephonyData;
import org.tizen.ecp.telephony.cli.TelephonyMessage;
import org.tizen.ecp.telephony.cli.TelephonyStringResources;
import org.tizen.ecp.telephony.cli.sms.MMSStatus;
import org.tizen.ecp.telephony.cli.sms.SMSEvent;
import org.tizen.ecp.telephony.cli.sms.SMSStatus;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.sms.G04A01;
import org.tizen.ecp.telephony.protocol.sms.G04A05;
import org.tizen.ecp.telephony.protocol.sms.crytography.DecodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.EncodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.SMS_USERDATA;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsAddressInfo;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_SUBMIT;
import org.tizen.ecp.telephony.protocol.sms.crytography.TapiNetTextCodingScheme;
import org.tizen.ecp.telephony.protocol.sms.crytography.TmDateTime;
import org.tizen.ecp.utils.LogUtil;

public class TelephonySMSData {
    private static TelephonySMSData instance = new TelephonySMSData();
    private boolean isMsgReceived = false;
    Logger logger = LogUtil.getECPLogger(TelephonySMSData.class).getLogger();
    private SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    private SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
    private SimpleDateFormat dayFormat = new SimpleDateFormat("dd");
    private SimpleDateFormat hourFormat = new SimpleDateFormat("HH");
    private SimpleDateFormat minuteFormat = new SimpleDateFormat("mm");
    private SimpleDateFormat secondFormat = new SimpleDateFormat("ss");
    private SmsAddressInfo SCA = null;
    private final char[] SMSC_NUM = new char[]{'\b', '\u0002', '\u0001', '\u0000', '\t', '\u0001', '\u0001', '\u0001', '\u0001'};

    public boolean sendStatus(SMSStatus sMSStatus) throws IOException {
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", sMSStatus.getValue() & 0xFF);
        structureGA.setInt("DATA2", sMSStatus.getValue() >> 8 & 0xFF);
        TelephonyMessage.getInstance().send(g04A05);
        return true;
    }

    public static TelephonySMSData getInstance() {
        return instance;
    }

    public boolean sendStatus(MMSStatus mMSStatus) throws IOException {
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", mMSStatus.getValue() & 0xFF);
        structureGA.setInt("DATA2", mMSStatus.getValue() >> 8 & 0xFF);
        TelephonyMessage.getInstance().send(g04A05);
        return true;
    }

    private TmDateTime getDateTime() {
        Date date = new Date();
        TmDateTime tmDateTime = new TmDateTime();
        tmDateTime.year = Integer.parseInt(this.yearFormat.format(date).trim());
        tmDateTime.month = Integer.parseInt(this.monthFormat.format(date).trim());
        tmDateTime.day = Integer.parseInt(this.dayFormat.format(date).trim());
        tmDateTime.hour = Integer.parseInt(this.hourFormat.format(date).trim());
        tmDateTime.minute = Integer.parseInt(this.minuteFormat.format(date).trim());
        tmDateTime.second = Integer.parseInt(this.secondFormat.format(date).trim());
        return tmDateTime;
    }

    private TapiNetTextCodingScheme getScheme() {
        TapiNetTextCodingScheme tapiNetTextCodingScheme = new TapiNetTextCodingScheme();
        tapiNetTextCodingScheme.bCompressed = false;
        tapiNetTextCodingScheme.bMsgClassSet = false;
        tapiNetTextCodingScheme.bMsgIndActive = false;
        tapiNetTextCodingScheme.codingGroupType = 0;
        tapiNetTextCodingScheme.waitingType = 0;
        tapiNetTextCodingScheme.alphabetType = 2;
        tapiNetTextCodingScheme.classType = 0;
        tapiNetTextCodingScheme.codingGroup = 0;
        tapiNetTextCodingScheme.code = 0;
        return tapiNetTextCodingScheme;
    }

    private SmsAddressInfo getSCA() {
        if (this.SCA == null) {
            this.SCA = new SmsAddressInfo();
            this.SCA.diallingNum = this.SMSC_NUM;
            this.SCA.dialnumlen = this.SCA.diallingNum.length;
        }
        return this.SCA;
    }

    private ArrayList<SMS_USERDATA> getUserData(String string) {
        ArrayList<SMS_USERDATA> arrayList = new ArrayList<SMS_USERDATA>();
        int n = 60;
        int n2 = string.length() / n;
        ++n2;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
            try {
                int n4 = n3 + n > string.length() - n3 ? string.length() - n3 : n3 + n;
                sMS_USERDATA.data = string.substring(n3, n3 + n4).getBytes("ISO-10646-UCS-2");
                sMS_USERDATA.length = sMS_USERDATA.data.length;
                sMS_USERDATA.headerCnt = 1;
                sMS_USERDATA.setSMSUDH('\u0000', (short)0, (char)n2, (char)(i + 1));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                continue;
            }
            if (n2 == 1) {
                sMS_USERDATA.headerCnt = 0;
            }
            arrayList.add(sMS_USERDATA);
            n3 += n;
        }
        return arrayList;
    }

    private byte[] convertToByte(char[] cArray, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    private char[] convertToChar(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i < n) continue;
            cArray[n3++] = (char)byArray[i];
            if (n3 >= n2) break;
        }
        return cArray;
    }

    void fireSMSEvent(AbstractGA abstractGA) throws IOException {
        StructureGA structureGA = abstractGA.getBody();
        TPDU_SMS_SUBMIT tPDU_SMS_SUBMIT = new TPDU_SMS_SUBMIT();
        byte[] byArray = structureGA.getByteArray("DATA");
        if (byArray.length == 0) {
            return;
        }
        DecodeMsg decodeMsg = new DecodeMsg();
        char[] cArray = this.convertToChar(byArray, 3, byArray.length - 3);
        if (!decodeMsg.DecodeSmsSubmitTpdu(tPDU_SMS_SUBMIT, 500, cArray)) {
            return;
        }
        SMSEvent sMSEvent = new SMSEvent();
        sMSEvent.setNumber(String.valueOf(tPDU_SMS_SUBMIT.destAddr.diallingNum).trim());
        if (DecodeMsg.relayedsms) {
            sMSEvent.setMessage(String.valueOf(DecodeMsg.smsbuffer).trim());
            if (--DecodeMsg.relay_cnt == 0) {
                for (int i = 0; i < DecodeMsg.smsbuffer_index; ++i) {
                    DecodeMsg.smsbuffer[i] = '\u0000';
                }
                DecodeMsg.smsbuffer_index = 0;
                DecodeMsg.relayedsms = false;
            }
        } else {
            sMSEvent.setMessage(String.valueOf(tPDU_SMS_SUBMIT.userData).trim());
        }
        if (DecodeMsg.deliveryReport) {
            if (DecodeMsg.relayedsms) {
                if (tPDU_SMS_SUBMIT.udl < 255) {
                    this.sendDeliveryReport();
                }
            } else {
                this.sendDeliveryReport();
            }
        }
    }

    public void fireMsgReceived(boolean bl) {
        this.setMsgReceived(bl);
    }

    private void sendDeliveryReport() throws IOException {
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        String string = DecodeMsg.deliveryReportNum_set.iterator().next();
        DecodeMsg.deliveryReportNum_set.remove(string);
        smsAddressInfo.diallingNum = String.format(string, new Object[0]).toCharArray();
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = this.getDateTime();
        tPDU_SMS_DELIVER.dcs = this.getScheme();
        tPDU_SMS_DELIVER.udl = 0;
        String string2 = DeviceMessages.getString("TelephonySMSData.12");
        SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
        try {
            sMS_USERDATA.data = string2.getBytes("ISO-10646-UCS-2");
            sMS_USERDATA.length = sMS_USERDATA.data.length;
            sMS_USERDATA.headerCnt = 0;
            sMS_USERDATA.setSMSUDH('\u0000', (short)0, '\u0002', '\u0001');
            tPDU_SMS_DELIVER.userData = sMS_USERDATA;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.info("Failed to set SMS USER DATA.");
            return;
        }
        int n3 = encodeMsg.EncodeSmsDeliverTpdu(this.getSCA(), tPDU_SMS_DELIVER, cArray, n, n2);
        if (n3 == -1) {
            return;
        }
        final byte[] byArray = this.convertToByte(cArray, n3);
        G04A01 g04A01 = new G04A01(){

            @Override
            protected void makeBody() {
                StructureGA structureGA = this.getBody();
                structureGA.addByteArrayItem("DATA", byArray.length);
            }
        };
        g04A01.intialize();
        StructureGA structureGA = g04A01.getBody();
        structureGA.setByteArray("DATA", byArray);
        TelephonyMessage.getInstance().send(g04A01);
    }

    public boolean sendMessage(String string, String string2) throws IOException {
        if (!TelephonyMessage.getInstance().getRssiStatus()) {
            System.out.println(TelephonyStringResources.RSSIIsZero);
            return false;
        }
        if (!TelephonyData.getInstance().checkNumber(string)) {
            return false;
        }
        if (string2.length() > 80) {
            System.out.println(TelephonyStringResources.MessageIsTooLong);
            return false;
        }
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        smsAddressInfo.diallingNum = string.toCharArray();
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = this.getDateTime();
        tPDU_SMS_DELIVER.dcs = this.getScheme();
        tPDU_SMS_DELIVER.udl = 0;
        ArrayList<SMS_USERDATA> arrayList = this.getUserData(string2);
        if (arrayList.size() > 1) {
            tPDU_SMS_DELIVER.udhi = true;
        }
        Iterator<SMS_USERDATA> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SMS_USERDATA sMS_USERDATA;
            tPDU_SMS_DELIVER.userData = sMS_USERDATA = iterator.next();
            int n3 = encodeMsg.EncodeSmsDeliverTpdu(this.getSCA(), tPDU_SMS_DELIVER, cArray, n, n2);
            if (n3 == -1) continue;
            final byte[] byArray = this.convertToByte(cArray, n3);
            G04A01 g04A01 = new G04A01(){

                @Override
                protected void makeBody() {
                    StructureGA structureGA = this.getBody();
                    structureGA.addByteArrayItem("DATA", byArray.length);
                }
            };
            g04A01.intialize();
            StructureGA structureGA = g04A01.getBody();
            structureGA.setByteArray("DATA", byArray);
            this.setMsgReceived(false);
            TelephonyMessage.getInstance().send(g04A01);
        }
        return true;
    }

    public boolean isMsgReceived() {
        return this.isMsgReceived;
    }

    public void setMsgReceived(boolean bl) {
        this.logger.info("sms received: " + bl);
        this.isMsgReceived = bl;
    }
}

