/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.protocol.sms.crytography;

import java.util.logging.Logger;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsAddressInfo;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.protocol.sms.crytography.TapiNetTextCodingScheme;
import org.tizen.ecp.telephony.protocol.sms.crytography.TmDateTime;
import org.tizen.ecp.utils.LogUtil;

public class EncodeMsg {
    int index;
    Logger logger = LogUtil.getECPLogger(EncodeMsg.class).getLogger();

    public int EncodeSmsDeliverTpdu(SmsAddressInfo smsAddressInfo, TPDU_SMS_DELIVER tPDU_SMS_DELIVER, char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        char[] cArray2 = new char[21];
        char[] cArray3 = new char[21];
        char[] cArray4 = new char[21];
        this.index = 0;
        if (smsAddressInfo.diallingNum[0] == '+') {
            smsAddressInfo.ton = 1;
            smsAddressInfo.npi = 1;
            for (n5 = 0; n5 < smsAddressInfo.dialnumlen - 1; ++n5) {
                cArray3[n5] = smsAddressInfo.diallingNum[n5 + 1];
            }
            n4 = smsAddressInfo.dialnumlen - 1;
            cArray3[n4] = '\u0000';
        } else {
            smsAddressInfo.ton = 0;
            smsAddressInfo.npi = 0;
            for (n5 = 0; n5 < smsAddressInfo.dialnumlen; ++n5) {
                cArray3[n5] = smsAddressInfo.diallingNum[n5];
            }
            n4 = smsAddressInfo.dialnumlen;
            cArray3[n4] = '\u0000';
        }
        if (!this.SmsUtilEncodeAddrField_sca(cArray, cArray3, n4, smsAddressInfo.ton, smsAddressInfo.npi)) {
            return -1;
        }
        tPDU_SMS_DELIVER.msgType = 0;
        cArray[this.index] = (char)tPDU_SMS_DELIVER.msgType;
        int n6 = this.index;
        cArray[n6] = (char)(cArray[n6] | (tPDU_SMS_DELIVER.mms ? 4 : 0));
        int n7 = this.index;
        cArray[n7] = (char)(cArray[n7] | (tPDU_SMS_DELIVER.sri ? 32 : 0));
        int n8 = this.index;
        cArray[n8] = (char)(cArray[n8] | (tPDU_SMS_DELIVER.udhi ? 64 : 0));
        int n9 = this.index;
        cArray[n9] = (char)(cArray[n9] | (tPDU_SMS_DELIVER.rp ? 128 : 0));
        ++this.index;
        if (tPDU_SMS_DELIVER.orgAddr.diallingNum[0] == '+') {
            tPDU_SMS_DELIVER.orgAddr.ton = 1;
            tPDU_SMS_DELIVER.orgAddr.npi = 1;
            for (n5 = 0; n5 < tPDU_SMS_DELIVER.orgAddr.dialnumlen - 1; ++n5) {
                cArray4[n5] = tPDU_SMS_DELIVER.orgAddr.diallingNum[n5 + 1];
            }
            n3 = tPDU_SMS_DELIVER.orgAddr.dialnumlen - 1;
            cArray4[n3] = '\u0000';
        } else {
            tPDU_SMS_DELIVER.orgAddr.ton = 0;
            tPDU_SMS_DELIVER.orgAddr.npi = 0;
            for (n5 = 0; n5 < tPDU_SMS_DELIVER.orgAddr.dialnumlen; ++n5) {
                cArray4[n5] = tPDU_SMS_DELIVER.orgAddr.diallingNum[n5];
            }
            n3 = tPDU_SMS_DELIVER.orgAddr.dialnumlen;
            cArray4[n3] = '\u0000';
        }
        if (!this.SmsUtilEncodeAddrField_dst(cArray, cArray4, n3, tPDU_SMS_DELIVER.orgAddr.ton, tPDU_SMS_DELIVER.orgAddr.npi)) {
            return -1;
        }
        cArray[this.index++] = (char)n;
        char c = this.SmsUtilEncodeDCS(tPDU_SMS_DELIVER.dcs);
        cArray[this.index++] = c;
        if (!this.SmsUtilEncodeTimeStamp(tPDU_SMS_DELIVER.scts, cArray2)) {
            return -1;
        }
        for (n5 = 0; n5 < 7; ++n5) {
            cArray[this.index++] = cArray2[n5];
        }
        switch (tPDU_SMS_DELIVER.dcs.alphabetType) {
            case 0: {
                cArray[this.index++] = (char)tPDU_SMS_DELIVER.userData.data.length;
                this.SmsUtilPackGSMCode(cArray, new String(tPDU_SMS_DELIVER.userData.data).toCharArray(), tPDU_SMS_DELIVER.userData.data.length);
                break;
            }
            case 1: {
                cArray[this.index++] = (char)tPDU_SMS_DELIVER.userData.data.length;
                this.SmsUtilPackGSM8Code(cArray, new String(tPDU_SMS_DELIVER.userData.data).toCharArray(), tPDU_SMS_DELIVER.userData.data.length);
                break;
            }
            case 2: {
                int n10 = 0;
                int n11 = 0;
                int n12 = this.index++;
                if (tPDU_SMS_DELIVER.userData.headerCnt > 0) {
                    this.index += 2;
                }
                int n13 = 6;
                if (tPDU_SMS_DELIVER.ported) {
                    ++this.index;
                    cArray[this.index++] = 5;
                    cArray[this.index++] = 4;
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.port >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.port & 0xFF);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.port >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.port & 0xFF);
                    n10 += n13;
                }
                for (n5 = 0; n5 < tPDU_SMS_DELIVER.userData.headerCnt; ++n5) {
                    cArray[this.index++] = 8;
                    cArray[this.index++] = 4;
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.userData.smsUDH.msgRef >> 8);
                    cArray[this.index++] = (char)(tPDU_SMS_DELIVER.userData.smsUDH.msgRef & 0xFF);
                    cArray[this.index++] = tPDU_SMS_DELIVER.userData.smsUDH.totalSeg;
                    cArray[this.index++] = tPDU_SMS_DELIVER.userData.smsUDH.seqNum;
                    n10 += n13;
                }
                if (n10 > 0) {
                    cArray[n12] = (char)(n10 + 1 + n11 + tPDU_SMS_DELIVER.userData.length);
                    cArray[n12 + 1] = (char)n10;
                } else {
                    cArray[n12] = (char)tPDU_SMS_DELIVER.userData.length;
                }
                for (int i = 0; i < tPDU_SMS_DELIVER.userData.length; ++i) {
                    cArray[this.index++] = (char)tPDU_SMS_DELIVER.userData.data[i];
                }
                break;
            }
            default: {
                this.logger.warning("Unsupported alphabetType while decoding SMS userdata");
            }
        }
        return this.index;
    }

    private void SmsUtilPackGSMCode(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[this.index] = (char)(cArray2[i] >> n2);
            if (i + 1 < n) {
                int n3 = this.index;
                cArray[n3] = (char)(cArray[n3] | cArray2[i + 1] << 7 - n2);
                int n4 = this.index;
                cArray[n4] = (char)(cArray[n4] & 0xFF);
                if (++n2 == 7) {
                    n2 = 0;
                    ++i;
                }
            }
            ++this.index;
        }
    }

    private void SmsUtilPackGSM8Code(char[] cArray, char[] cArray2, int n) {
        for (int i = 0; i < n; ++i) {
            cArray[this.index++] = cArray2[i];
        }
    }

    private boolean SmsUtilEncodeTimeStamp(TmDateTime tmDateTime, char[] cArray) {
        char[] cArray2 = new char[3];
        char[] cArray3 = new char[20];
        for (int i = 0; i < 7; ++i) {
            cArray[i] = '\u0000';
        }
        int n = tmDateTime.year - 2000;
        if (n < 0) {
            n += 100;
        }
        if (!this.SmsUtilConvertDigit2BCD(cArray3, cArray2 = String.format("%02d", n).toCharArray(), 2L)) {
            return false;
        }
        cArray[0] = cArray3[0];
        cArray2 = String.format("%02d", tmDateTime.month).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[1] = cArray3[0];
        cArray2 = String.format("%02d", tmDateTime.day).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[2] = cArray3[0];
        cArray2 = String.format("%02d", tmDateTime.hour).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[3] = cArray3[0];
        cArray2 = String.format("%02d", tmDateTime.minute).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[4] = cArray3[0];
        cArray2 = String.format("%02d", tmDateTime.second).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[5] = cArray3[0];
        cArray2 = String.format("%02d", 0).toCharArray();
        this.SmsUtilConvertDigit2BCD(cArray3, cArray2, 2L);
        cArray[6] = cArray3[0];
        return true;
    }

    private char SmsUtilEncodeDCS(TapiNetTextCodingScheme tapiNetTextCodingScheme) {
        char c = '\u0000';
        block0 : switch (tapiNetTextCodingScheme.codingGroupType) {
            case 0: {
                if (tapiNetTextCodingScheme.bCompressed) {
                    c = (char)(c | 0x20);
                }
                if (tapiNetTextCodingScheme.bMsgClassSet) {
                    c = (char)(c | 0x10);
                    switch (tapiNetTextCodingScheme.classType) {
                        case 0: {
                            c = (char)(c | '\u0000');
                            break;
                        }
                        case 1: {
                            c = (char)(c | '\u0001');
                            break;
                        }
                        case 2: {
                            c = (char)(c | 2);
                            break;
                        }
                        case 3: {
                            c = (char)(c | 3);
                            break;
                        }
                    }
                }
                switch (tapiNetTextCodingScheme.alphabetType) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | 4);
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 8);
                        break block0;
                    }
                }
                c = (char)(c | 0xC);
                break;
            }
            case 7: {
                c = (char)(c | 0xC0);
                break;
            }
            case 8: {
                c = (char)(c | 0xD0);
                if (tapiNetTextCodingScheme.bMsgIndActive) {
                    c = (char)(c | 8);
                }
                switch (tapiNetTextCodingScheme.waitingType) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                c = (char)(c | 0xE0);
                if (tapiNetTextCodingScheme.bMsgIndActive) {
                    c = (char)(c | 8);
                }
                switch (tapiNetTextCodingScheme.waitingType) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                c = (char)(c | 0xF0);
                switch (tapiNetTextCodingScheme.alphabetType) {
                    case 0: {
                        c = (char)(c | '\u0000');
                        break;
                    }
                    case 1: {
                        c = (char)(c | 4);
                        break;
                    }
                }
                switch (tapiNetTextCodingScheme.classType) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        c = (char)(c | '\u0001');
                        break block0;
                    }
                    case 2: {
                        c = (char)(c | 2);
                        break block0;
                    }
                    case 3: {
                        c = (char)(c | 3);
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                c = (char)(tapiNetTextCodingScheme.codingGroup << 4 & 0xF0);
                c = (char)(c | tapiNetTextCodingScheme.code & 0xF);
                break;
            }
        }
        return c;
    }

    private boolean SmsUtilEncodeAddrField_sca(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (cArray == null || cArray2 == null) {
            this.logger.info(DeviceMessages.getString("EncodeMsg.0"));
            return false;
        }
        if (n2 != 5) {
            cArray[this.index++] = n % 2 != 0 ? (char)(n / 2 + 1 + 1) : (char)(n / 2 + 1);
        } else {
            cArray[this.index] = (char)((n * 7 + 7) / 8 * 2);
            if (n * 7 % 8 <= 4) {
                int n4 = this.index;
                cArray[n4] = (char)(cArray[n4] - '\u0001');
            }
            ++this.index;
        }
        cArray[this.index] = 128;
        int n5 = this.index;
        cArray[n5] = (char)(cArray[n5] | (n2 & 7) << 4);
        int n6 = this.index++;
        cArray[n6] = (char)(cArray[n6] | n3 & 0xF);
        if (n2 != 5) {
            char[] cArray3 = new char[n];
            if (!this.SmsUtilConvertDigit2BCD(cArray3, cArray2, n)) {
                return false;
            }
            int n7 = this.index;
            this.index = n % 2 != 0 ? (this.index += n / 2 + 1) : (this.index += n / 2);
            int n8 = n7;
            int n9 = 0;
            while (n8 < this.index) {
                cArray[n8] = cArray3[n9];
                ++n8;
                ++n9;
            }
        } else {
            this.SmsUtilPackGSMCode(cArray, cArray2, n);
        }
        return true;
    }

    private boolean SmsUtilEncodeAddrField_dst(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (cArray == null || cArray2 == null) {
            this.logger.warning(DeviceMessages.getString("EncodeMsg.1"));
            return false;
        }
        if (n2 != 5) {
            cArray[this.index++] = (char)n;
        } else {
            cArray[this.index] = (char)((n * 7 + 7) / 8 * 2);
            if (n * 7 % 8 <= 4) {
                int n4 = this.index;
                cArray[n4] = (char)(cArray[n4] - '\u0001');
            }
            ++this.index;
        }
        cArray[this.index] = 128;
        int n5 = this.index;
        cArray[n5] = (char)(cArray[n5] | (n2 & 7) << 4);
        int n6 = this.index++;
        cArray[n6] = (char)(cArray[n6] | n3 & 0xF);
        if (n2 != 5) {
            int n7;
            char[] cArray3 = new char[n];
            for (n7 = 0; n7 < n; ++n7) {
                cArray3[n7] = '\u0000';
            }
            if (!this.SmsUtilConvertDigit2BCD(cArray3, cArray2, n)) {
                return false;
            }
            int n8 = this.index;
            this.index = n % 2 != 0 ? (this.index += n / 2 + 1) : (this.index += n / 2);
            n7 = n8;
            int n9 = 0;
            while (n7 < this.index) {
                cArray[n7] = cArray3[n9];
                ++n7;
                ++n9;
            }
        } else {
            this.SmsUtilPackGSMCode(cArray, cArray2, n);
        }
        return true;
    }

    private boolean SmsUtilConvertDigit2BCD(char[] cArray, char[] cArray2, long l) {
        if (cArray == null || cArray2 == null) {
            this.logger.warning(DeviceMessages.getString("EncodeMsg.2"));
            return false;
        }
        int n = 0;
        int n2 = 0;
        while ((long)n < l) {
            int n3;
            int n4 = cArray2[n] == '*' ? 10 : (cArray2[n] == '#' ? 11 : (this.AcToupper(cArray2[n]) == 80 ? 12 : cArray2[n] - 48));
            char c = (char)(n4 & 0xF);
            if (l != (long)(n + 1)) {
                n4 = cArray2[n + 1] == '*' ? 10 : (cArray2[n + 1] == '#' ? 11 : (this.AcToupper(cArray2[n + 1]) == 80 ? 12 : cArray2[n + 1] - 48));
                n3 = (char)(n4 & 0xF);
            } else {
                n3 = 255;
            }
            cArray[n2] = (char)(n3 << 4 | c);
            int n5 = n2++;
            cArray[n5] = (char)(cArray[n5] & 0xFF);
            n += 2;
        }
        return true;
    }

    private int AcToupper(int n) {
        return 97 <= n && n <= 122 ? n - 32 : n;
    }
}

