/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.TizenCheckBox;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.AbstractInjectorReceiver;
import org.tizen.ecp.telephony.protocol.ProtocolBuilder;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.call.G01A21MO;
import org.tizen.ecp.telephony.protocol.call.G01A22;
import org.tizen.ecp.telephony.protocol.call.G01A26;
import org.tizen.ecp.telephony.protocol.call.G01A29;
import org.tizen.ecp.telephony.protocol.sms.G04A01;
import org.tizen.ecp.telephony.protocol.sms.crytography.DecodeMsg;
import org.tizen.ecp.telephony.ui.CallInfo;
import org.tizen.ecp.telephony.ui.TelephonyConstants;
import org.tizen.ecp.utils.LogUtil;

public class TelephonyController
implements Initializable {
    Logger logger = LogUtil.getECPLogger(TelephonyController.class).getLogger();
    ProtocolBuilder protocolBuilder = ProtocolBuilder.getInstance();
    @FXML
    GridPane fx_hidden_checkbox;
    @FXML
    ComboBox<String> fx_MT_Call_combo;
    @FXML
    ComboBox<String> fx_MO_Call_combo;
    @FXML
    Button fx_connect_btn;
    @FXML
    Button fx_MT_disconnect_btn;
    @FXML
    Button fx_MO_disconnect_btn;
    @FXML
    TextField fx_MT_number_tf;
    @FXML
    TableView<CallInfo> fx_callList_table;
    @FXML
    Label fx_MO_callID_lbl;
    @FXML
    Label fx_MO_number_lbl;
    @FXML
    Label fx_MO_callType_lbl;
    @FXML
    TableColumn<CallInfo, Number> fx_callID_column;
    @FXML
    TableColumn<CallInfo, String> fx_status_column;
    @FXML
    TableColumn<CallInfo, String> fx_momt_column;
    @FXML
    TableColumn<CallInfo, String> fx_multiparty_column;
    @FXML
    TableColumn<CallInfo, String> fx_number_column;
    TizenCheckBox hidden_cb;
    @FXML
    GridPane fx_port_checkbox;
    @FXML
    ComboBox<String> fx_originAddress_combo;
    @FXML
    ComboBox<String> fx_message_combo;
    @FXML
    ComboBox<String> fx_SMS_status_combo;
    @FXML
    ComboBox<String> fx_MMS_status_combo;
    @FXML
    Button fx_sendMsg_btn;
    @FXML
    Button fx_SMS_set_btn;
    @FXML
    Button fx_MMS_set_btn;
    @FXML
    TextField fx_message_textfield;
    @FXML
    TextField fx_port_textfield;
    @FXML
    Label fx_received_msg_lbl;
    @FXML
    Label fx_received_callNumber_lbl;
    TizenCheckBox port_cb;
    HashMap<String, AbstractInjectorReceiver> receiverMap = null;
    ObservableList<CallInfo> callList = FXCollections.observableArrayList();
    boolean isbtenabled = true;
    boolean callWaiting = true;
    boolean isMsgReceived = false;
    boolean rssiStatus = true;
    boolean isInitialized = false;
    boolean listfull = false;
    boolean incoming = false;
    boolean dialing = false;
    boolean calling = false;
    private ObservableList<String> mtCall_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> moCall_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> originatingAddress_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> mmsStatus_ComboData = FXCollections.observableArrayList();
    private ObservableList<String> smsStatus_ComboData = FXCollections.observableArrayList();
    private static ArrayList<AbstractInjectorReceiver> receiverList = new ArrayList();

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.hidden_cb = new TizenCheckBox("Hidden");
        this.hidden_cb.setAlignment(Pos.CENTER_LEFT);
        this.fx_hidden_checkbox.add((Node)this.hidden_cb, 0, 0);
        this.port_cb = new TizenCheckBox("Port");
        this.port_cb.setAlignment(Pos.CENTER_LEFT);
        this.fx_port_checkbox.add((Node)this.port_cb, 0, 0);
        this.mtCall_ComboData.add((Object)"CALL OK (Success)");
        this.fx_MT_Call_combo.setItems(this.mtCall_ComboData);
        this.fx_MT_Call_combo.setValue((Object)"CALL OK (Success)");
        this.moCall_ComboData.add((Object)"CALL OK (Success)");
        this.fx_MO_Call_combo.setItems(this.moCall_ComboData);
        this.fx_MO_Call_combo.setValue((Object)"CALL OK (Success)");
        this.fx_MO_disconnect_btn.setUserData((Object)1);
        this.fx_originAddress_combo.setEditable(true);
        this.originatingAddress_ComboData.add((Object)"+821030014180");
        this.fx_originAddress_combo.setItems(this.originatingAddress_ComboData);
        this.fx_originAddress_combo.setValue((Object)"+821030014180");
        this.mmsStatus_ComboData.add((Object)"MMS OK(Success)");
        this.mmsStatus_ComboData.add((Object)"MMS Failure");
        this.fx_MMS_status_combo.setItems(this.mmsStatus_ComboData);
        this.fx_MMS_status_combo.setValue((Object)"MMS OK(Success)");
        this.smsStatus_ComboData.add((Object)"SMS OK(Success)");
        this.smsStatus_ComboData.add((Object)"SMS Not Available");
        this.fx_SMS_status_combo.setItems(this.smsStatus_ComboData);
        this.fx_SMS_status_combo.setValue((Object)"SMS OK(Success)");
        this.fx_callID_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getCallIDProperty());
        this.fx_status_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getStatusProperty());
        this.fx_momt_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getMomtProperty());
        this.fx_multiparty_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getMultipartyProperty());
        this.fx_number_column.setCellValueFactory(cellDataFeatures -> ((CallInfo)cellDataFeatures.getValue()).getNumberProperty());
        this.receiverMap = new HashMap();
        this.registerReceivers();
        this.addInjectorReceiver(receiverList);
        this.fx_callList_table.getSelectionModel().selectedItemProperty().addListener((observableValue, callInfo, callInfo2) -> this.fx_MT_disconnect_btn.setDisable(false));
        this.fx_port_textfield.textProperty().addListener((observableValue, string, string2) -> {
            if (!string2.matches("[0-9]*")) {
                this.fx_port_textfield.setText(string);
            }
        });
        this.onActivate();
    }

    public void onActivate() {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        this.protocolBuilder.sendActivation();
        this.isInitialized = true;
    }

    @FXML
    public void onConnectAction(ActionEvent actionEvent) {
        this.setConnectMTButtonStatus(true);
        String string = this.checkStatus();
        if (string != null) {
            this.mtConnect(string);
        }
    }

    @FXML
    public void onMTDisconnectAction(ActionEvent actionEvent) {
        this.callEnd(false);
    }

    @FXML
    public void onMODisconnectAction(ActionEvent actionEvent) {
        int n = (Integer)this.fx_MO_disconnect_btn.getUserData();
        switch (n) {
            case 0: {
                this.moAlert();
                break;
            }
            case 1: {
                this.moConnect();
                break;
            }
            case 2: {
                this.moDisconnect();
            }
        }
    }

    @FXML
    public void onNumberChanged(ActionEvent actionEvent) {
        String string = this.fx_MT_number_tf.getText();
        if (TelephonyController.checkNumberFormat(string)) {
            this.fx_MT_number_tf.setText(string);
        }
    }

    @FXML
    public void onSetSMS() {
        int n = this.get_error_code_from_ui_index(this.fx_SMS_status_combo.getSelectionModel().getSelectedIndex());
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        this.protocolBuilder.sendSMSOrMMS(n2, n3);
    }

    @FXML
    public void onSetMMS(ActionEvent actionEvent) {
        int n = this.get_error_code_from_ui_index(this.fx_MMS_status_combo.getSelectionModel().getSelectedIndex());
        int n2 = n + 10 & 0xFF;
        int n3 = n + 10 >> 8 & 0xFF;
        this.protocolBuilder.sendSMSOrMMS(n2, n3);
    }

    @FXML
    public void onSendMsg(ActionEvent actionEvent) {
        if (!this.checkRSSI()) {
            return;
        }
        String string = (String)this.fx_originAddress_combo.getValue();
        if (string == null || string.length() == 0) {
            MessageBox.error((String)"Input phone number.");
            return;
        }
        if (string.length() > 15) {
            MessageBox.error((String)"The maximum length of a phone number is 15.");
            return;
        }
        if (TelephonyController.checkNumberFormat(string)) {
            MessageBox.error((String)"This is an invalid number. ");
            return;
        }
        if (!this.originatingAddress_ComboData.contains((Object)string)) {
            this.originatingAddress_ComboData.add((Object)string);
        }
        short s = -1;
        if (this.port_cb.isSelected() && this.fx_port_textfield.getText() != null) {
            s = Short.parseShort(this.fx_port_textfield.getText());
        }
        this.protocolBuilder.sendMSG(string, s, this.fx_message_textfield.getText());
        this.fx_message_textfield.clear();
    }

    public void addInjectorReceiver(ArrayList<AbstractInjectorReceiver> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractInjectorReceiver abstractInjectorReceiver = arrayList.get(i);
            this.receiverMap.put(abstractInjectorReceiver.getKey(), abstractInjectorReceiver);
        }
    }

    private void setConnectMTButtonStatus(boolean bl) {
        this.fx_connect_btn.setDisable(bl);
        this.isbtenabled = !bl;
    }

    private void mtConnect(String string) {
        this.protocolBuilder.mtConnect(string, this.hidden_cb.isSelected());
    }

    private String checkStatus() {
        if (!this.rssiStatus) {
            MessageBox.error((String)"RSSI level is zero. Please try again later.");
            return null;
        }
        if (this.listfull) {
            MessageBox.error((String)"There are many pending connections. Can't connect anymore.");
            return null;
        }
        if (this.incoming || this.dialing) {
            MessageBox.error((String)"User is busy. Please try again later.");
            return null;
        }
        if (!this.callWaiting && this.calling) {
            MessageBox.error((String)"User is busy. Call waiting mode of emulator is off. Please try again later.");
            return null;
        }
        String string = this.fx_MT_number_tf.getText();
        if (string == null || string.length() == 0) {
            this.setConnectMTButtonStatus(false);
            return null;
        }
        return string.trim();
    }

    public void setCallWaiting(boolean bl) {
        this.callWaiting = bl;
    }

    public void setMsgReceived(boolean bl) {
        this.isMsgReceived = bl;
    }

    public void sendNetStatus(boolean bl) {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        this.protocolBuilder.sendNetStatus(bl);
        this.setRssiStatus(bl);
    }

    public boolean getRSSIStatus() {
        return this.rssiStatus;
    }

    public void setRssiStatus(boolean bl) {
        this.rssiStatus = bl;
        if (!bl) {
            this.callEnd(true);
        }
    }

    public void callEnd(boolean bl) {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList = bl ? this.fx_callList_table.getItems() : this.fx_callList_table.getSelectionModel().getSelectedItems();
        if (observableList.size() == 0) {
            return;
        }
        for (int i = 0; i < observableList.size(); ++i) {
            int n = ((String)this.fx_MT_Call_combo.getSelectionModel().getSelectedItem()).equals("CALL OK (Success)") ? 32768 : -1;
            int n2 = ((CallInfo)observableList.get(i)).getCallId();
            try {
                this.protocolBuilder.moDisconnect(n, n2);
                String string = this.fx_MO_callID_lbl.getText();
                if (string == null || string.isEmpty() || n2 != Integer.parseInt(string)) continue;
                this.resetCompomentValue();
                continue;
            }
            catch (Exception exception) {
                this.logger.warning(exception.getMessage());
                this.resetCompomentValue();
            }
        }
    }

    public void sendInitialize() {
        this.protocolBuilder.sendInitialize();
        this.isInitialized = true;
    }

    public AbstractInjectorReceiver getReceiver(long l, long l2) {
        return this.receiverMap.get(l + ":" + l2);
    }

    public void registerReceiver(String string, AbstractInjectorReceiver abstractInjectorReceiver) {
        this.receiverMap.put(string, abstractInjectorReceiver);
    }

    protected void registerReceivers() {
        CallList22Receiver callList22Receiver = new CallList22Receiver();
        CallList26Receiver callList26Receiver = new CallList26Receiver();
        CallList29Receiver callList29Receiver = new CallList29Receiver();
        CallReceiver callReceiver = new CallReceiver();
        SimDBReceiver simDBReceiver = new SimDBReceiver();
        this.registerReceiver(callList22Receiver.getKey(), callList22Receiver);
        this.registerReceiver(callList26Receiver.getKey(), callList26Receiver);
        this.registerReceiver(callList29Receiver.getKey(), callList29Receiver);
        this.registerReceiver(callReceiver.getKey(), callReceiver);
        this.registerReceiver(simDBReceiver.getKey(), simDBReceiver);
    }

    private void resetCompomentValue() {
        this.fx_MO_Call_combo.setDisable(true);
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setDisable(true);
        this.dialing = false;
        this.fx_MO_disconnect_btn.setUserData((Object)0);
        this.fx_MO_callID_lbl.setText("");
        this.fx_MO_number_lbl.setText("");
        this.fx_MO_callType_lbl.setText("");
    }

    public void refresh() {
        this.fx_callList_table.getItems().removeAll((Object[])new CallInfo[0]);
        this.fx_callList_table.setItems(this.callList);
        if (this.callList.size() == 0) {
            this.fx_MT_disconnect_btn.setDisable(true);
        }
    }

    public void connectBtStatus(boolean bl) {
        this.fx_connect_btn.setDisable(bl);
        this.isbtenabled = bl;
    }

    private boolean checkRSSI() {
        return this.rssiStatus;
    }

    private static boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9++]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    protected int get_error_code_from_ui_index(int n) {
        if (n <= 17) {
            return n;
        }
        switch (n) {
            case 18: {
                return 32769;
            }
            case 19: {
                return 32776;
            }
            case 20: {
                return 32778;
            }
            case 21: {
                return 32789;
            }
            case 22: {
                return 32790;
            }
            case 23: {
                return 32795;
            }
            case 24: {
                return 32796;
            }
            case 25: {
                return 32797;
            }
            case 26: {
                return 32798;
            }
            case 27: {
                return 32806;
            }
            case 28: {
                return 32809;
            }
            case 29: {
                return 32810;
            }
            case 30: {
                return 32815;
            }
            case 31: {
                return 32818;
            }
            case 32: {
                return 32837;
            }
            case 33: {
                return 32849;
            }
            case 34: {
                return 32864;
            }
            case 35: {
                return 32865;
            }
            case 36: {
                return 32866;
            }
            case 37: {
                return 32867;
            }
            case 38: {
                return 32879;
            }
            case 39: {
                return 32895;
            }
            case 40: {
                return 33041;
            }
            case 41: {
                return 33062;
            }
            case 42: {
                return 33068;
            }
        }
        return 0;
    }

    private void moDisconnect() {
        this.protocolBuilder.moDisconnect(2, Integer.parseInt(this.fx_MO_callID_lbl.getText()));
        this.fx_MO_Call_combo.setDisable(true);
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setDisable(true);
        this.dialing = false;
        this.fx_MO_disconnect_btn.setUserData((Object)2);
        this.fx_MO_callID_lbl.setText("");
        this.fx_MO_number_lbl.setText("");
        this.fx_MO_callType_lbl.setText("");
    }

    private void moAlert() {
        this.protocolBuilder.moAlert();
        this.fx_connect_btn.setDisable(false);
        this.fx_MO_disconnect_btn.setText("Connect");
        this.fx_MO_disconnect_btn.setUserData((Object)1);
    }

    private void moConnect() {
        this.protocolBuilder.moConnect();
        this.dialing = false;
        this.fx_MO_disconnect_btn.setText("Disonnect");
        this.fx_MO_disconnect_btn.setUserData((Object)2);
    }

    public class SimDBReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            DecodeMsg decodeMsg = new DecodeMsg();
            String[] stringArray = TelephonyController.this.protocolBuilder.parseMSG(abstractGA.getBody(), decodeMsg);
            if (stringArray.length == 0) {
                return;
            }
            TelephonyController.this.fx_received_callNumber_lbl.setText(stringArray[0]);
            TelephonyController.this.fx_received_msg_lbl.setText(stringArray[1]);
            TelephonyController.this.protocolBuilder.sendDeliveryReport(decodeMsg, stringArray[2]);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G04A01();
        }
    }

    public class CallReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            StructureGA structureGA = abstractGA.getBody();
            int n = structureGA.getInt("CALL_ID");
            int n2 = structureGA.getInt("CALL_TYPE");
            byte[] byArray = structureGA.getByteArray("CALL_NUMBER");
            String string = (byArray.length != 0 ? new String(byArray) : new String("")).trim();
            TelephonyController.this.fx_MO_callID_lbl.setText(String.valueOf(n));
            TelephonyController.this.fx_MO_number_lbl.setText(string);
            TelephonyController.this.fx_MO_callType_lbl.setText(TelephonyConstants.CALL_TYPE_LIST[n2]);
            if (TelephonyController.this.fx_MO_callType_lbl.getParent() != null) {
                TelephonyController.this.fx_MO_callType_lbl.getParent().layout();
            }
            TelephonyController.this.fx_MO_disconnect_btn.setDisable(false);
            byte[] byArray2 = structureGA.getByteArray("CALL_NUMBER");
            if (byArray2[0] == 4) {
                TelephonyController.this.dialing = true;
                TelephonyController.this.fx_MO_disconnect_btn.setText("Connect");
                TelephonyController.this.fx_MO_disconnect_btn.setUserData((Object)1);
            } else {
                TelephonyController.this.dialing = true;
                TelephonyController.this.fx_MO_disconnect_btn.setText("Alert");
                TelephonyController.this.fx_MO_disconnect_btn.setUserData((Object)0);
            }
            TelephonyController.this.fx_MO_Call_combo.setDisable(false);
            TelephonyController.this.fx_connect_btn.setDisable(true);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A21MO();
        }
    }

    public class CallList29Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            TelephonyController.this.incoming = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                int n3 = structureGA2.getInt("STAT", i) - 1;
                int n4 = structureGA2.getInt("DIR", i) - 1;
                if (n3 < 0 || n4 < 0) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 == 4 || n3 == 5) {
                    TelephonyController.this.incoming = true;
                }
                byte[] byArray = structureGA2.getByteArray("NUMBER", i);
                CallInfo callInfo = new CallInfo(structureGA2.getInt("IDX", i), n3, structureGA2.getInt("MULTIPARTY", i), n4, (byArray.length != 0 ? new String(byArray) : new String("")).trim());
                TelephonyController.this.callList.add((Object)callInfo);
                TelephonyController.this.calling = true;
            }
            TelephonyController.this.refresh();
            TelephonyController.this.listfull = (n -= n2) == 6;
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A29();
        }
    }

    public class CallList26Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            TelephonyController.this.incoming = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                int n2 = structureGA2.getInt("STAT", i) - 1;
                int n3 = structureGA2.getInt("DIR", i) - 1;
                if (n2 < 0 || n3 < 0) continue;
                byte[] byArray = structureGA2.getByteArray("NUMBER", i);
                CallInfo callInfo = new CallInfo(structureGA2.getInt("IDX", i), n2, structureGA2.getInt("MULTIPARTY", i), n3, (byArray.length != 0 ? new String(byArray) : new String("")).trim());
                if (n2 == 4 || n2 == 5) {
                    TelephonyController.this.incoming = true;
                }
                TelephonyController.this.callList.add((Object)callInfo);
                TelephonyController.this.calling = true;
            }
            TelephonyController.this.refresh();
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A26();
        }
    }

    public class CallList22Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyController.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            boolean bl = false;
            TelephonyController.this.connectBtStatus(false);
            StructureGA structureGA2 = abstractGA.getBody();
            TelephonyController.this.incoming = false;
            for (int i = 0; i < n; ++i) {
                String string;
                int n3 = structureGA2.getInt("STAT", i) - 1;
                int n4 = structureGA2.getInt("DIR", i) - 1;
                if (n3 < 0 || n4 < 0) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 == 4 || n3 == 5) {
                    TelephonyController.this.incoming = true;
                }
                byte[] byArray = structureGA2.getByteArray("NUMBER", i);
                CallInfo callInfo = new CallInfo(structureGA2.getInt("IDX", i), n3, structureGA2.getInt("MULTIPARTY", i), n4, (byArray.length != 0 ? new String(byArray) : new String("")).trim());
                String string2 = callInfo.getNumber();
                if (string2.compareTo(string = TelephonyController.this.fx_MO_number_lbl.getText()) == 0) {
                    bl = true;
                }
                TelephonyController.this.callList.add((Object)callInfo);
            }
            TelephonyController.this.refresh();
            if ((n -= n2) != 6) {
                TelephonyController.this.listfull = false;
            }
            if (n == 0) {
                TelephonyController.this.calling = false;
            }
            if (!bl) {
                TelephonyController.this.resetCompomentValue();
            }
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A22();
        }
    }
}

