/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.IProtocolBuilder;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.call.G01A07;
import org.tizen.ecp.telephony.protocol.call.G01A21MT;
import org.tizen.ecp.telephony.protocol.call.G01A22End;
import org.tizen.ecp.telephony.protocol.call.G01A23;
import org.tizen.ecp.telephony.protocol.call.G01A62;
import org.tizen.ecp.telephony.protocol.call.G02A31;
import org.tizen.ecp.telephony.protocol.sms.G04A01;
import org.tizen.ecp.telephony.protocol.sms.G04A05;
import org.tizen.ecp.telephony.protocol.sms.crytography.DecodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.EncodeMsg;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsAddressInfo;
import org.tizen.ecp.telephony.protocol.sms.crytography.SmsUserData;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.protocol.sms.crytography.TPDU_SMS_SUBMIT;
import org.tizen.ecp.utils.LogUtil;

public class ProtocolBuilder
implements IProtocolBuilder {
    Logger logger = LogUtil.getECPLogger(ProtocolBuilder.class).getLogger();

    private ProtocolBuilder() {
    }

    public static ProtocolBuilder getInstance() {
        return PB.instance;
    }

    @Override
    public boolean send(AbstractGA abstractGA) {
        return MessageSender.getInstance().sendInjectorReq("telephony", abstractGA.getGroupID(), abstractGA.getActionID(), abstractGA.makePacket());
    }

    @Override
    public boolean sendMSG(String string, short s, String string2) {
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        boolean bl = true;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER(s);
        tPDU_SMS_DELIVER.setOrgAddr(new SmsAddressInfo(string));
        ArrayList<SmsUserData> arrayList = this.getUserData(string2);
        if (arrayList.size() > 1 || tPDU_SMS_DELIVER.getPort() != -1) {
            tPDU_SMS_DELIVER.setUdhi(true);
        }
        for (SmsUserData smsUserData : arrayList) {
            tPDU_SMS_DELIVER.setUserData(smsUserData);
            int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
            bl = bl && this.makeG04A01(this.convertToByte(cArray, n3));
        }
        return bl;
    }

    private ArrayList<SmsUserData> getUserData(String string) {
        ArrayList<SmsUserData> arrayList = new ArrayList<SmsUserData>();
        int n = 60;
        int n2 = string.length() / n;
        ++n2;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SmsUserData smsUserData;
            int n4 = n3 + n > string.length() - n3 ? string.length() - n3 : n3 + n;
            try {
                smsUserData = new SmsUserData(string.substring(n3, n3 + n4).getBytes("ISO-10646-UCS-2"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                continue;
            }
            smsUserData.setHeaderCnt(1);
            smsUserData.setSMSUDH('\u0000', (short)0, (char)n2, (char)(i + 1));
            if (n2 == 1) {
                smsUserData.setHeaderCnt(0);
            }
            arrayList.add(smsUserData);
            n3 += n;
        }
        return arrayList;
    }

    @Override
    public void moAlert() {
        G01A62 g01A62 = new G01A62();
        g01A62.intialize();
        this.send(g01A62);
    }

    @Override
    public void moConnect() {
        G01A23 g01A23 = new G01A23();
        g01A23.intialize();
        this.send(g01A23);
    }

    @Override
    public void moDisconnect(int n, int n2) {
        G01A07 g01A07 = new G01A07();
        g01A07.intialize();
        StructureGA structureGA = g01A07.getBody();
        structureGA.setInt("ERROR_CAUSE_0", n & 0xFF);
        structureGA.setInt("ERROR_CAUSE_1", n >> 8 & 0xFF);
        G01A22End g01A22End = new G01A22End();
        g01A22End.intialize();
        StructureGA structureGA2 = g01A22End.getBody();
        structureGA2.setInt("CALL_ID", n2);
        this.send(g01A07);
        this.send(g01A22End);
    }

    @Override
    public void mtConnect(String string, boolean bl) {
        G01A21MT g01A21MT = new G01A21MT();
        g01A21MT.intialize();
        g01A21MT.setBody(string, bl);
        this.send(g01A21MT);
    }

    @Override
    public String[] parseMSG(StructureGA structureGA, DecodeMsg decodeMsg) {
        String[] stringArray = new String[3];
        TPDU_SMS_SUBMIT tPDU_SMS_SUBMIT = new TPDU_SMS_SUBMIT();
        byte[] byArray = structureGA.getByteArray("DATA");
        DecodeMsg decodeMsg2 = decodeMsg;
        if (byArray.length == 0 || !decodeMsg2.DecodeSmsSubmitTpdu(tPDU_SMS_SUBMIT, 500, this.convertToChar(byArray, 3, byArray.length - 3))) {
            return new String[0];
        }
        stringArray[0] = tPDU_SMS_SUBMIT.getDestAddr().getDiallingNum();
        if (decodeMsg2.isRelayedsms()) {
            stringArray[1] = String.valueOf(decodeMsg2.getSmsbuffer()).trim();
            decodeMsg2.setMinusRelayCnt();
            if (decodeMsg2.getRelay_cnt() == 0) {
                decodeMsg2.setSmsbuffer("".toCharArray());
                decodeMsg2.setSmsbuffer_index(0);
                decodeMsg2.setRelayedsms(false);
            }
        } else {
            stringArray[1] = tPDU_SMS_SUBMIT.getUserData();
        }
        stringArray[2] = String.valueOf(tPDU_SMS_SUBMIT.getUdl() < 255);
        return stringArray;
    }

    @Override
    public void sendActivation() {
        this.sendRSSILevel();
        this.sendAsk();
    }

    @Override
    public void sendRSSILevel() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    @Override
    public void sendAsk() {
        MessageSender.getInstance().sendInjectorReq("telephony", 17, 91);
    }

    @Override
    public void sendInitialize() {
        byte[] byArray = new byte[]{22, 0, 0, 0};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 65, byArray);
        byte[] byArray2 = new byte[]{0, 0, 64, 66};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 71, byArray2);
    }

    @Override
    public void sendNetStatus(boolean bl) {
        G02A31 g02A31 = new G02A31();
        g02A31.intialize();
        g02A31.setBody(bl);
        MessageSender.getInstance().sendInjectorReq("telephony", 49, 2, g02A31.makePacket());
    }

    @Override
    public void sendSMSOrMMS(int n, int n2) {
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", n);
        structureGA.setInt("DATA2", n2);
        try {
            this.send(g04A05);
        }
        catch (Exception exception) {
            this.logger.warning(exception.getMessage());
        }
    }

    private byte[] convertToByte(char[] cArray, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    private char[] convertToChar(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = n; i < byArray.length; ++i) {
            cArray[n3++] = (char)byArray[i];
            if (n3 >= n2) break;
        }
        return cArray;
    }

    private boolean makeG04A01(final byte[] byArray) {
        G04A01 g04A01 = new G04A01(){

            @Override
            protected void makeBody() {
                StructureGA structureGA = this.getBody();
                structureGA.addByteArrayItem("DATA", byArray.length);
            }
        };
        g04A01.intialize();
        StructureGA structureGA = g04A01.getBody();
        structureGA.setByteArray("DATA", byArray);
        boolean bl = true;
        try {
            this.send(g04A01);
        }
        catch (Exception exception) {
            this.logger.warning(exception.getMessage());
            bl = false;
        }
        return bl;
    }

    public void sendDeliveryReport(DecodeMsg decodeMsg, String string) {
        SmsUserData smsUserData;
        if (!decodeMsg.isDeliveryReport()) {
            return;
        }
        if (!decodeMsg.isRelayedsms() || !string.equals("true")) {
            return;
        }
        if (decodeMsg.isRelayedsms()) {
            return;
        }
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        String string2 = decodeMsg.getDeliveryReportNum_set().iterator().next();
        decodeMsg.getDeliveryReportNum_set().remove(string2);
        SmsAddressInfo smsAddressInfo2 = new SmsAddressInfo(string2);
        tPDU_SMS_DELIVER.setSmsAddressInfo(smsAddressInfo2);
        String string3 = DeviceMessages.getString("TelephonySMSDisplay.20");
        try {
            smsUserData = new SmsUserData(string3.getBytes("ISO-10646-UCS-2"), '\u0000', 0, '\u0002', '\u0001');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return;
        }
        tPDU_SMS_DELIVER.setUserData(smsUserData);
        int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
        final byte[] byArray = new String(cArray).substring(0, n3).getBytes();
        G04A01 g04A01 = new G04A01(){

            @Override
            protected void makeBody() {
                StructureGA structureGA = this.getBody();
                structureGA.addByteArrayItem("DATA", byArray.length);
            }
        };
        g04A01.intialize();
        StructureGA structureGA = g04A01.getBody();
        structureGA.setByteArray("DATA", byArray);
        try {
            Thread.sleep(1200L);
            this.send(g04A01);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class PB {
        private static final ProtocolBuilder instance = new ProtocolBuilder();

        private PB() {
        }
    }
}

