
/*
 * Copyright (c) 2014 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _FIDO_H_
#define _FIDO_H_

#include <tizen.h>

#include <fido_uaf_authenticator.h>
#include <fido_uaf_client.h>
#include <fido_uaf_types.h>

/**
 * Tizen FIDO UAF Client Framework.
 * Refer to https://fidoalliance.org/specifications/download/ about FIDO UAF.
 * Also FIDO server document needs to be referred for using end points and additional parameters.
 */

/**
 * @addtogroup CAPI_FIDO_MODULE
 * @{
 */

/* End of FIDO APIs */
/**
 * @}
 */

#endif // _FIDO_H_

