/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.ui;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import netscape.javascript.JSObject;
import org.tizen.ecp.connection.NetworkConnection;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.ui.LocationMapController;
import org.tizen.ecp.location.ui.LocationPane;
import org.tizen.ecp.utils.LogUtil;

public class LocationMap
extends Parent {
    Logger logger = LogUtil.getECPLogger(LocationPane.class).getLogger();
    LocationMapController controller;
    private JSObject doc;
    private WebEngine webEngine;
    private boolean mapInitialized;

    public LocationMap(LocationMapController locationMapController, WebView webView) {
        this.controller = locationMapController;
        this.initMap(webView);
        this.initCommunication();
    }

    private void trustAllCertificates() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            this.logger.warning(exception.getMessage());
        }
    }

    private void checkConnection() {
        String string = System.getProperty("java.net.useSystemProxies");
        this.logger.info("use system proxy: " + string);
        this.logger.info("http.proxyHost: " + System.getProperty("http.proxyHost"));
        this.logger.info("http.proxyPort: " + System.getProperty("http.proxyPort"));
        this.logger.info("https.proxyHost: " + System.getProperty("https.proxyHost"));
        this.logger.info("https.proxyPort: " + System.getProperty("https.proxyPort"));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final String string = NetworkConnection.check((String)LocationConstants.GOOGLE_MAP_URL);
                if (string != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LocationMap.this.webEngine.loadContent(string);
                        }
                    });
                }
            }
        });
        thread.start();
    }

    private void initMap(WebView webView) {
        this.trustAllCertificates();
        this.webEngine = webView.getEngine();
        this.checkConnection();
        this.mapInitialized = false;
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    LocationMap.this.mapInitialized = true;
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LocationMap.this.webEngine.load(this.getClass().getResource("SearchMap.html").toExternalForm());
            }
        });
    }

    private void initCommunication() {
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    LocationMap.this.doc = (JSObject)LocationMap.this.webEngine.executeScript("window");
                    if (LocationMap.this.doc != null) {
                        LocationMap.this.doc.setMember("LocationMapController", LocationMap.this.controller);
                        LocationMap.this.controller.mapView.setDisable(false);
                    }
                }
            }
        });
    }

    public void executeJS(final String string) {
        if (this.mapInitialized) {
            this.doc.eval(string);
        } else {
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                    if (state2 == Worker.State.SUCCEEDED) {
                        LocationMap.this.doc.eval(string);
                    }
                }
            });
        }
    }
}

