#ifndef _EFL_UI_TEXTPATH_EO_H_
#define _EFL_UI_TEXTPATH_EO_H_

#ifndef _EFL_UI_TEXTPATH_EO_CLASS_TYPE
#define _EFL_UI_TEXTPATH_EO_CLASS_TYPE

typedef Eo Efl_Ui_Textpath;

#endif

#ifndef _EFL_UI_TEXTPATH_EO_TYPES
#define _EFL_UI_TEXTPATH_EO_TYPES

typedef enum
{
  EFL_UI_TEXTPATH_DIRECTION_CW = 0,
  EFL_UI_TEXTPATH_DIRECTION_CCW
} Efl_Ui_Textpath_Direction;


#endif
/** Efl Ui Textpath class
 *
 * @ingroup Efl_Ui_Textpath
 */
#define EFL_UI_TEXTPATH_CLASS efl_ui_textpath_class_get()

EAPI const Eo_Class *efl_ui_textpath_class_get(void) EINA_CONST;

/**
 * @brief The ability to fit the text within the path. Set it to EINA_TRUE to
 * let text occupy only portion same as its size. Otherwise, text will occupied
 * the whole path. By default, it is EINA_TRUE.
 *
 * @param[in] obj The object.
 * @param[in] autofit
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI void  elm_obj_textpath_autofit_set(Eina_Bool autofit);

/** The ability to fit the text within the path. Set it to EINA_TRUE to let
 * text occupy only portion same as its size. Otherwise, text will occupied the
 * whole path. By default, it is EINA_TRUE.
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI Eina_Bool  elm_obj_textpath_autofit_get(void);

/**
 * @brief The number of slices. The larger the number of slice_num is, The
 * better the text follows the path.
 *
 * @param[in] obj The object.
 * @param[in] slice_no
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI void  elm_obj_textpath_slice_number_set(int slice_no);

/** The number of slices. The larger the number of slice_num is, The better the
 * text follows the path.
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI int  elm_obj_textpath_slice_number_get(void);

/**
 * @brief Control the ellipsis behavior of the textpath.
 *
 * @param[in] obj The object.
 * @param[in] ellipsis To ellipsis text or not
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI void  elm_obj_textpath_ellipsis_set(Eina_Bool ellipsis);

/**
 * @brief Control the ellipsis behavior of the textpath.
 *
 * @param[in] obj The object.
 *
 * @return To ellipsis text or not
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI Eina_Bool  elm_obj_textpath_ellipsis_get(void);

/**
 * @brief Set a circle with given center, radius, and start angle.
 *
 * @param[in] obj The object.
 * @param[in] x
 * @param[in] y
 * @param[in] radius
 * @param[in] start_angle
 * @param[in] direction
 *
 * @ingroup Efl_Ui_Textpath
 */
EOAPI void  elm_obj_textpath_circle_set(double x, double y, double radius, double start_angle, Efl_Ui_Textpath_Direction direction);


#endif
