/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.gyro;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.tizen.ecp.control.TizenTextField;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.axis.accelerometer.AccConstants;
import org.tizen.ecp.sensor.axis.fxml.FXMLSensorViewController;
import org.tizen.ecp.sensor.axis.fxml.SliderChangeListener;
import org.tizen.ecp.sensor.axis.gyro.GyroFileOperation;
import org.tizen.ecp.sock.MessageSender;

public class GyroViewController
extends FXMLSensorViewController {
    private DecimalFormat df = new DecimalFormat("0");
    private boolean isSend = true;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.initialize();
        this.fxNameLab.setText("Gyro");
        this.fxXTxt.setMaxLen(4);
        this.fxYTxt.setMaxLen(4);
        this.fxZTxt.setMaxLen(4);
        this.fxXUnitLab.setText("[degrees/sec]");
        this.fxXUnitLab.setMinHeight(40.0);
        this.fxYUnitLab.setText("[degrees/sec]");
        this.fxYUnitLab.setMinHeight(40.0);
        this.fxZUnitLab.setText("[degrees/sec]");
        this.fxZUnitLab.setMinHeight(40.0);
        this.createSlider(this.fxXSlider);
        this.createSlider(this.fxYSlider);
        this.createSlider(this.fxZSlider);
        this.fxXTxt.setText(this.df.format(this.fxXSlider.getValue()));
        this.fxYTxt.setText(this.df.format(this.fxYSlider.getValue()));
        this.fxZTxt.setText(this.df.format(this.fxZSlider.getValue()));
        this.setFileOperation(new GyroFileOperation());
        this.addListener();
    }

    private void addListener() {
        this.fxXSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxXTxt, this.df));
        this.fxYSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxYTxt, this.df));
        this.fxZSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxZTxt, this.df));
    }

    @Override
    protected void onEnterToTextField(TizenTextField tizenTextField, Slider slider) {
        String string = tizenTextField.getText();
        try {
            Integer n = Integer.parseInt(string);
            if (n < -573 || n > 573) {
                throw new Exception();
            }
            slider.setValue((double)n.intValue());
        }
        catch (Exception exception) {
            String string2 = AccConstants.INFO_RANGE_OUT_BEGIN + -573 + AccConstants.INFO_RANGE_OUT_TO + 573 + ".";
            MessageBox.error((String)"Emulator Control Panel", (String)string2);
            tizenTextField.setText(this.df.format(slider.getValue()));
            return;
        }
    }

    private void createSlider(Slider slider) {
        slider.setMin(-573.0);
        slider.setMax(573.0);
        slider.setValue(0.0);
    }

    @Override
    public void sendMessage() {
        if (!this.isSend) {
            return;
        }
        int n = (int)Math.round(this.fxXSlider.getValue());
        int n2 = (int)Math.round(this.fxYSlider.getValue());
        int n3 = (int)Math.round(this.fxZSlider.getValue());
        InjectorMessage injectorMessage = new InjectorMessage((double)n, (double)n2, (double)n3);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "4\n" + injectorMessage.getMessage());
    }

    @Override
    public void setStatus(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        this.isSend = false;
        String[] stringArray = string.split(",");
        double d = Math.round(Double.parseDouble(stringArray[0]));
        double d2 = Math.round(Double.parseDouble(stringArray[1]));
        double d3 = Math.round(Double.parseDouble(stringArray[2]));
        this.fxXSlider.setValue(d);
        this.fxYSlider.setValue(d2);
        this.fxZSlider.setValue(d3);
        this.isSend = true;
    }
}

