/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.accelerometer;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class SensorAccelCLI
extends AbstractEmulatorCLI {
    private int ACCEL_ADJUST = 100000;
    private String TYPE_SENSOR = "sensor";
    double g = 9.80665;
    @Argument(required=true, index=0)
    double xValue;
    @Argument(required=true, index=1)
    double yValue;
    @Argument(required=true, index=2)
    double zValue;

    public SensorAccelCLI() {
        this.messageType = this.TYPE_SENSOR;
    }

    private boolean checkRange(double d) {
        return d >= -2.0 && d <= 2.0;
    }

    public int execute() {
        if (!this.checkRange(this.xValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorAccelCLI.1"));
            return 25;
        }
        if (!this.checkRange(this.yValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorAccelCLI.2"));
            return 25;
        }
        if (!this.checkRange(this.zValue)) {
            OutputUtil.println((String)DeviceMessages.getString("SensorAccelCLI.3"));
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(this.xValue * this.g * (double)this.ACCEL_ADJUST, this.yValue * this.g * (double)this.ACCEL_ADJUST, this.zValue * this.g * (double)this.ACCEL_ADJUST);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "1\n" + injectorMessage.getMessage());
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            MessageSender.getInstance().sendDeviceReq("sensor", 15, 110);
            this.stopRunning();
        }
    }
}

