/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.cli;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.location.LocationEventMode;
import org.tizen.ecp.location.LocationInjector;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class LocationCoordinateCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    double latitude;
    @Argument(required=true, index=1)
    double longitude;
    @Argument(required=true, index=2)
    double altitude;
    @Argument(required=true, index=3)
    double accuracy;

    public void printHelp() {
        super.printHelp();
    }

    private boolean checkValues(double d, double d2, double d3, double d4) {
        int n = -90;
        int n2 = 90;
        int n3 = -180;
        int n4 = 180;
        int n5 = -300;
        int n6 = 100000;
        int n7 = 100000;
        boolean bl = false;
        if (d > (double)n2 || d < (double)n) {
            return false;
        }
        if (d2 > (double)n4 || d2 < (double)n3) {
            return false;
        }
        if (d3 > (double)n6 || d3 < (double)n5) {
            return false;
        }
        return !(d4 > (double)n7) && !(d4 < (double)bl);
    }

    public LocationCoordinateCLI() {
        this.messageType = this.TYPE_SENSOR = DeviceMessages.getString("LocationCoordinateCLI.0");
    }

    public int execute() {
        if (!this.checkValues(this.latitude, this.longitude, this.altitude, this.accuracy)) {
            OutputUtil.printError((String)DeviceMessages.getString("LocationCoordinateCLI.1"));
            return 25;
        }
        if (!LocationInjector.getInstance().setMode("2", true)) {
            OutputUtil.printFail();
            return 128;
        }
        LocationInjector.getInstance().injectLocation(this.latitude, this.longitude, this.altitude, this.accuracy);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 120);
        this.startRunning();
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        long l = injectorNtf.getAction();
        if (120L != l) {
            return;
        }
        String string = injectorNtf.getData().toStringUtf8();
        LocationEventMode locationEventMode = null;
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        for (LocationEventMode locationEventMode2 : LocationEventMode.values()) {
            if (!locationEventMode2.toString().equals(stringArray[0])) continue;
            locationEventMode = locationEventMode2;
            break;
        }
        if (locationEventMode == LocationEventMode.MANUALMODE) {
            if (Double.toString(this.latitude).equals(stringArray[1]) && Double.toString(this.longitude).equals(stringArray[2]) && Double.toString(this.altitude).equals(stringArray[3]) && Double.toString(this.accuracy).equals(stringArray[4])) {
                OutputUtil.printOK();
            } else {
                OutputUtil.printFail();
            }
            this.stopRunning();
        }
    }
}

