/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.cli;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.telephony.cli.TelephonyMessage;
import org.tizen.ecp.telephony.cli.TelephonyStringResources;
import org.tizen.ecp.telephony.cli.call.CallErrorCode;
import org.tizen.ecp.telephony.cli.call.CallEvent;
import org.tizen.ecp.telephony.cli.call.CallEventType;
import org.tizen.ecp.telephony.cli.call.CallItem;
import org.tizen.ecp.telephony.cli.call.CallStatus;
import org.tizen.ecp.telephony.cli.call.CallType;
import org.tizen.ecp.telephony.cli.call.MobileType;
import org.tizen.ecp.telephony.cli.sms.TelephonySMSData;
import org.tizen.ecp.telephony.protocol.AbstractGA;
import org.tizen.ecp.telephony.protocol.AbstractInjectorReceiver;
import org.tizen.ecp.telephony.protocol.ProtocolBuilder;
import org.tizen.ecp.telephony.protocol.StructureGA;
import org.tizen.ecp.telephony.protocol.call.G01A21MO;
import org.tizen.ecp.telephony.protocol.call.G01A22;
import org.tizen.ecp.telephony.protocol.call.G01A26;
import org.tizen.ecp.telephony.protocol.call.G01A29;
import org.tizen.ecp.utils.LogUtil;

public class TelephonyData
implements ILsn {
    private static TelephonyData instance = new TelephonyData();
    Logger logger = LogUtil.getECPLogger(TelephonyData.class).getLogger();
    private boolean listfull = false;
    private boolean incoming = false;
    private boolean dialing = false;
    private boolean calling = false;
    boolean isbtenabled = true;
    private boolean callWaiting = true;
    private CallEvent callEvent = null;
    private static ArrayList<AbstractInjectorReceiver> receiverList = new ArrayList();
    private HashMap<String, AbstractInjectorReceiver> receiverMap = new HashMap();

    public static TelephonyData getInstance() {
        return instance;
    }

    public void createData() {
        this.registerReceivers();
        this.addInjectorReceiver(receiverList);
    }

    public HashMap<String, AbstractInjectorReceiver> getReceiverMap() {
        return this.receiverMap;
    }

    public void addInjectorReceiver(ArrayList<AbstractInjectorReceiver> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractInjectorReceiver abstractInjectorReceiver = arrayList.get(i);
            this.receiverMap.put(abstractInjectorReceiver.getKey(), abstractInjectorReceiver);
        }
    }

    public void registerReceiver(String string, AbstractInjectorReceiver abstractInjectorReceiver) {
        this.receiverMap.put(string, abstractInjectorReceiver);
    }

    public void removeInjectorReceiver() {
        this.receiverMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CallItem> getCallItemList() {
        TelephonyData telephonyData = this;
        synchronized (telephonyData) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                this.logger.info(interruptedException.getMessage());
            }
        }
        if (this.callEvent != null) {
            return this.callEvent.getCallItemList();
        }
        return null;
    }

    public CallEvent getCallEvent() {
        return this.callEvent;
    }

    protected void registerReceivers() {
        CallList22Receiver callList22Receiver = new CallList22Receiver();
        CallList26Receiver callList26Receiver = new CallList26Receiver();
        CallList29Receiver callList29Receiver = new CallList29Receiver();
        CallReceiver callReceiver = new CallReceiver();
        this.registerReceiver(callList22Receiver.getKey(), callList22Receiver);
        this.registerReceiver(callList26Receiver.getKey(), callList26Receiver);
        this.registerReceiver(callList29Receiver.getKey(), callList29Receiver);
        this.registerReceiver(callReceiver.getKey(), callReceiver);
    }

    public boolean checkNumber(String string) {
        if (string == null) {
            OutputUtil.printError((String)TelephonyStringResources.NumberIsEmpty);
            return false;
        }
        if (string.length() > 15) {
            OutputUtil.printError((String)TelephonyStringResources.NumberIsTooLong);
            return false;
        }
        Pattern pattern = Pattern.compile("[^0-9++]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            OutputUtil.printError((String)TelephonyStringResources.NumberFormatError);
            return false;
        }
        return true;
    }

    public boolean calling(String string, boolean bl) throws IOException {
        this.connectBtStatus(false);
        if (!TelephonyMessage.getInstance().getRssiStatus()) {
            OutputUtil.printError((String)TelephonyStringResources.RSSIIsZero);
            return false;
        }
        if (this.listfull) {
            OutputUtil.printError((String)TelephonyStringResources.ListFull);
            return false;
        }
        if (this.incoming || this.dialing) {
            OutputUtil.printError((String)TelephonyStringResources.IncomingCall);
            return false;
        }
        if (!this.callWaiting && this.calling) {
            OutputUtil.printError((String)TelephonyStringResources.NowBusy);
            return false;
        }
        if (!this.checkNumber(string)) {
            return false;
        }
        this.logger.info("send call");
        ProtocolBuilder.getInstance().mtConnect(string, bl);
        return true;
    }

    public boolean calling(String string) throws IOException {
        return this.calling(string, false);
    }

    private CallStatus findCallStatus(int n) {
        for (CallStatus callStatus : CallStatus.values()) {
            if (callStatus.getID() != n) continue;
            return callStatus;
        }
        return null;
    }

    private CallType findCallType(int n) {
        for (CallType callType : CallType.values()) {
            if (callType.getID() != n) continue;
            return callType;
        }
        return null;
    }

    private MobileType findMobileType(int n) {
        for (MobileType mobileType : MobileType.values()) {
            if (mobileType.getID() != n) continue;
            return mobileType;
        }
        return null;
    }

    public boolean isDailing() {
        return this.dialing;
    }

    public void setDailing(boolean bl) {
        this.dialing = bl;
    }

    public void connectBtStatus(boolean bl) {
        this.isbtenabled = bl;
    }

    public void fireCallEvent(AbstractGA abstractGA) {
        this.logger.info("fireCallEvent");
        this.connectBtStatus(true);
        StructureGA structureGA = abstractGA.getBody();
        CallEvent callEvent = new CallEvent();
        callEvent.setEventType(CallEventType.INCOMING);
        callEvent.setCallID(structureGA.getInt("CALL_ID"));
        callEvent.setCallType(this.findCallType(structureGA.getInt("CALL_TYPE")));
        byte[] byArray = structureGA.getByteArray("CALL_NUMBER");
        if (byArray.length != 0) {
            callEvent.setCallNumber(new String(byArray).trim());
            byte by = byArray[0];
            callEvent.setCallStatus(this.findCallStatus(by));
        } else {
            callEvent.setCallNumber("");
            callEvent.setCallStatus(null);
        }
        this.dialing = true;
        this.callEvent = callEvent;
    }

    public void fireCallListEvent(AbstractGA abstractGA, CallEventType callEventType) {
        this.logger.info("fireCallListEvent");
        StructureGA structureGA = abstractGA.getHeader();
        StructureGA structureGA2 = abstractGA.getBody();
        this.connectBtStatus(true);
        int n = structureGA.getInt("COUNT");
        CallEvent callEvent = new CallEvent();
        callEvent.setEventType(callEventType);
        callEvent.setCallItemList(new ArrayList<CallItem>());
        this.incoming = false;
        for (int i = 0; i < n; ++i) {
            CallItem callItem = new CallItem();
            callItem.setId(structureGA2.getInt("IDX", i));
            callItem.setStatus(this.findCallStatus(structureGA2.getInt("STAT", i)));
            callItem.setMultiParty(structureGA2.getInt("MULTIPARTY", i) == 1);
            callItem.setMobileType(this.findMobileType(structureGA2.getInt("DIR", i)));
            byte[] byArray = structureGA2.getByteArray("NUMBER", i);
            if (byArray.length != 0) {
                callItem.setNumber(new String(byArray).trim());
            } else {
                callItem.setNumber("");
            }
            callItem.setNumber(new String(structureGA2.getByteArray("NUMBER", i)).trim());
            if (callItem.getStatus() == null || callItem.getStatus() == CallStatus.NONE) {
                ++n;
                continue;
            }
            if (callItem.getStatus() == CallStatus.INCOMING || callItem.getStatus() == CallStatus.WAITING) {
                this.incoming = true;
            }
            callEvent.getCallItemList().add(callItem);
            this.calling = true;
        }
        if (callEvent.getCallItemList().isEmpty()) {
            this.incoming = false;
            this.calling = false;
            this.listfull = false;
        } else {
            this.listfull = callEvent.getCallItemList().size() == 6;
        }
        this.callEvent = callEvent;
    }

    public boolean sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)interruptedException.getMessage());
            return false;
        }
        return true;
    }

    public boolean disconnectCall(int n) {
        return this.disconnectCall(n, CallErrorCode.Success);
    }

    public boolean disconnectCall(int n, CallErrorCode callErrorCode) {
        boolean bl = false;
        if (this.callEvent != null && this.callEvent.getCallItemList() != null) {
            for (CallItem callItem : this.callEvent.getCallItemList()) {
                if (callItem.getId() != n) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            OutputUtil.printError((String)TelephonyStringResources.NumberNotFound);
            return false;
        }
        ProtocolBuilder.getInstance().moDisconnect(callErrorCode.value(), n);
        this.dialing = false;
        return true;
    }

    public AbstractInjectorReceiver getReceiver(long l, long l2) {
        return this.receiverMap.get(l + ":" + l2);
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        try {
            AbstractInjectorReceiver abstractInjectorReceiver;
            byte[] byArray = null;
            String string2 = "";
            long l = injectorNtf.getAction();
            long l2 = injectorNtf.getGroup();
            long l3 = injectorNtf.getLength();
            this.logger.info("groupId: " + l2 + ", actionId:" + l);
            if (l3 != 0L) {
                byArray = new byte[(int)l3];
                string2 = injectorNtf.getData().toStringUtf8();
                byArray = string2.getBytes();
            }
            if (l2 == 3L && l == 73L) {
                if (byArray == null) {
                    this.logger.info("buf is null returned");
                    return;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != -1) continue;
                }
            } else {
                if (l2 == 4L && l == 12L) {
                    this.logger.info("send message received");
                    TelephonySMSData.getInstance().fireMsgReceived(true);
                    return;
                }
                if (l2 == 15L && l == 104L) {
                    if (string2.equals("0")) {
                        TelephonyMessage.getInstance().sendNetStatus(false);
                    } else {
                        TelephonyMessage.getInstance().sendNetStatus(true);
                    }
                }
            }
            if ((abstractInjectorReceiver = this.getReceiver(l2, l)) == null) {
                this.logger.info("cannot find receiver. receiver is null");
                return;
            }
            if (l3 == 0L) {
                abstractInjectorReceiver.analyzePacket();
            } else if (byArray != null) {
                abstractInjectorReceiver.analyzePacket(byArray);
            }
            abstractInjectorReceiver.run(abstractInjectorReceiver.getTransferObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean connectCall() {
        if (this.callEvent == null || this.callEvent.getCallItemList() == null || this.callEvent.getCallItemList().isEmpty()) {
            OutputUtil.printError((String)TelephonyStringResources.NotExistCall);
            return false;
        }
        this.logger.info("connect call");
        this.dialing = false;
        ProtocolBuilder.getInstance().moConnect();
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
    }

    public class CallReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyData.this.fireCallEvent(abstractGA);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A21MO();
        }
    }

    public class CallList29Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyData.this.fireCallListEvent(abstractGA, CallEventType.LIST29);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A29();
        }
    }

    public class CallList26Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyData.this.fireCallListEvent(abstractGA, CallEventType.LIST26);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A26();
        }
    }

    public class CallList22Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyData.this.fireCallListEvent(abstractGA, CallEventType.LIST22);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A22();
        }
    }
}

