/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.heartrate;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.tizen.ecp.control.TizenSpinner;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class HeartRatePane
extends ECPPopupPane {
    private static Logger logger = LogUtil.getECPLogger(HeartRatePane.class).getLogger();
    private TizenSpinner hrmSpinner;
    private TizenSpinner rriSpinner;

    public Pane create() {
        VBox vBox = new VBox();
        HBox hBox = new HBox();
        HBox hBox2 = new HBox();
        Label label = new Label("bpm");
        label.getStyleClass().add((Object)"titleLabel");
        label.setMinSize(40.0, 24.0);
        label.setAlignment(Pos.CENTER_LEFT);
        this.hrmSpinner = new TizenSpinner(0.0, 220.0, 100.0, 1.0);
        this.hrmSpinner.getEditor().setPrefSize(50.0, 24.0);
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 12.0, 0.0, 40.0));
        HBox.setMargin((Node)this.hrmSpinner, (Insets)new Insets(0.0, 42.0, 0.0, 0.0));
        HBox.setHgrow((Node)this.hrmSpinner, (Priority)Priority.SOMETIMES);
        hBox.getChildren().add((Object)label);
        hBox.getChildren().add((Object)this.hrmSpinner);
        Label label2 = new Label("ms");
        label2.getStyleClass().add((Object)"titleLabel");
        label2.setMinSize(40.0, 24.0);
        label2.setAlignment(Pos.CENTER_LEFT);
        this.rriSpinner = new TizenSpinner(0, 5000, 600, 1);
        this.rriSpinner.getEditor().setPrefSize(50.0, 24.0);
        HBox.setMargin((Node)label2, (Insets)new Insets(0.0, 12.0, 0.0, 40.0));
        HBox.setMargin((Node)this.rriSpinner, (Insets)new Insets(0.0, 42.0, 0.0, 0.0));
        HBox.setHgrow((Node)this.rriSpinner, (Priority)Priority.SOMETIMES);
        hBox2.getChildren().add((Object)label2);
        hBox2.getChildren().add((Object)this.rriSpinner);
        VBox.setMargin((Node)hBox, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        vBox.getChildren().add((Object)hBox);
        vBox.getChildren().add((Object)hBox2);
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 118);
    }

    public void onShow() {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 118);
        this.hrmSpinner.valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                HeartRatePane.this.sendMessage();
            }
        });
        this.rriSpinner.valueProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                HeartRatePane.this.sendMessage();
            }
        });
    }

    private void sendMessage() {
        int n = (int)(this.hrmSpinner.getValue() * 10.0);
        int n2 = (int)this.rriSpinner.getValue();
        InjectorMessage injectorMessage = new InjectorMessage(0.0, (double)n, (double)n2);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "22\n" + injectorMessage.getMessage());
        this.setCardDescription((double)n / 10.0 + " " + "BPM" + StringResources.NEW_LINE + n2 + " " + "ms");
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        int n = -1;
        int n2 = -1;
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        if (118 == deviceNtf.getAction()) {
            String string = deviceNtf.getData().toStringUtf8();
            String[] stringArray = string.split(", ");
            try {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
            this.setCardDescription((double)n / 10.0 + " " + "BPM" + StringResources.NEW_LINE + n2 + " " + "ms");
            if (this.hrmSpinner != null && this.rriSpinner != null) {
                this.hrmSpinner.setValue((double)n / 10.0);
                this.rriSpinner.setValue((double)n2);
            }
        }
    }
}

