/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import com.google.protobuf.GeneratedMessage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.json.simple.JSONObject;
import org.tizen.ecp.control.ButtonToggleEvent;
import org.tizen.ecp.control.TizenToggleButton;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCConstants;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCUtil;
import org.tizen.ecp.nfc.cli.NFCEventType;
import org.tizen.ecp.nfc.cli.NFCTagType;
import org.tizen.ecp.nfc.ui.NFCDialog;
import org.tizen.ecp.nfc.ui.NFCUIUtil;
import org.tizen.ecp.nfc.ui.RecordFormat;
import org.tizen.ecp.nfc.ui.TagType;
import org.tizen.ecp.nfc.ui.TizenRemoteFileDialog;
import org.tizen.ecp.nfc.ui.TypeName;
import org.tizen.ecp.utils.LogUtil;

public class NFCController
implements Initializable {
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private VBox vBox;
    @FXML
    private GridPane inputGrid;
    @FXML
    private ComboBox<String> typeNameFormatCombo;
    private final ObservableList<String> typeNameFormatComboData = FXCollections.observableArrayList();
    @FXML
    private ComboBox<String> typeNameCombo;
    private final ObservableList<String> typeNameComboData = FXCollections.observableArrayList();
    @FXML
    private TextField typeNameText;
    @FXML
    private TextField idText;
    @FXML
    private TextField payloadText;
    @FXML
    private Button mediaFileButton;
    @FXML
    private Button addButton;
    @FXML
    private Button editButton;
    @FXML
    private Button removeButton;
    @FXML
    private GridPane recordGrid;
    @FXML
    private ComboBox<String> recordCombo;
    private final ObservableList<String> recordComboData = FXCollections.observableArrayList();
    @FXML
    private Label recordLabel;
    @FXML
    private HBox tagTypeHBox;
    @FXML
    private ComboBox<String> tagTypeCombo;
    private final ObservableList<String> tagTypeComboData = FXCollections.observableArrayList();
    @FXML
    private Button p2pDiscoveredButton;
    @FXML
    private Button p2pDetachedButton;
    @FXML
    private Button p2pSendButton;
    private TizenToggleButton tagAttachButton;
    Logger logger = LogUtil.getECPLogger(NFCController.class).getLogger();
    private final ArrayList<String> TypeNameList = TypeName.getInstance().getList();
    private final ArrayList<String> TagTypeList = TagType.getInstance().getList();
    private final ArrayList<String> RecordFormatList = RecordFormat.getInstance().getList();
    private int nTotalLength = 0;
    private final int nMaxNDFEMessageLength = 4096;
    private ArrayList<NDEFRecord> RecordList = new ArrayList();
    private final NDEFRecord oldRecord = new NDEFRecord(NDEFFormat.EMPTY, "", "", "");
    private boolean bCheckTypeNameText = true;
    private boolean bCheckIDText = true;
    private boolean bCheckPayloadText = true;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.initNDEFMessageView();
        this.initNDEFTagView();
        this.initP2PView();
        this.inputGrid.setGridLinesVisible(false);
    }

    @FXML
    void onAddClick(ActionEvent actionEvent) {
        this.addRecord();
    }

    @FXML
    void onEditClick(ActionEvent actionEvent) {
        this.editRecord();
    }

    @FXML
    void onRemoveClick(ActionEvent actionEvent) {
        this.removeRecord();
    }

    @FXML
    void onP2PDetachedClick(ActionEvent actionEvent) {
        this.clickP2PDetached();
    }

    @FXML
    void onP2PDiscoveredClick(ActionEvent actionEvent) {
        this.clickP2PDiscovered();
    }

    @FXML
    void onP2PSendClick(ActionEvent actionEvent) {
        this.clickP2PSend();
    }

    @FXML
    void onSelectMediaFileClick(ActionEvent actionEvent) {
        String string = new TizenRemoteFileDialog().open();
        if (string != null) {
            this.typeNameText.setDisable(false);
            this.typeNameText.setEditable(false);
            this.payloadText.setDisable(false);
            this.payloadText.setEditable(false);
            this.typeNameText.setText(NFCUtil.checkFileType(string));
            this.payloadText.setText(string);
        }
    }

    @FXML
    void onIDModify(KeyEvent keyEvent) {
        this.checkLength(this.idText, 256);
        if (!this.bCheckIDText) {
            this.bCheckIDText = true;
            return;
        }
        try {
            NFCUtil.checkInvalidCharacters(this.idText.getText());
        }
        catch (NFCEventException nFCEventException) {
            MessageBox.confirm((String)NFCConstants.DIALOG_TITLE_INFO, (String)nFCEventException.getMessage());
            this.idText.setText(this.oldRecord.getId());
            return;
        }
        this.oldRecord.setId(this.idText.getText());
    }

    @FXML
    void onTypeNameFormatSelect(ActionEvent actionEvent) {
    }

    void setOnTypeNameFormatSelected() {
        this.typeNameFormatCombo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2 == null) {
                    return;
                }
                int n = NFCController.this.typeNameFormatCombo.getSelectionModel().getSelectedIndex();
                if (n != -1) {
                    NFCController.this.checkRecordFormat(n);
                    NFCController.this.typeNameText.setText("");
                    NFCController.this.typeNameCombo.getSelectionModel().select(0);
                    NFCController.this.idText.setText("");
                    NFCController.this.payloadText.setText("");
                }
            }
        });
    }

    @FXML
    void onTypeNameModify(KeyEvent keyEvent) {
        this.checkLength(this.idText, 256);
        if (!this.bCheckTypeNameText) {
            this.bCheckTypeNameText = true;
            return;
        }
        try {
            NFCUtil.checkInvalidCharacters(this.payloadText.getText());
        }
        catch (NFCEventException nFCEventException) {
            MessageBox.confirm((String)NFCConstants.DIALOG_TITLE_INFO, (String)nFCEventException.getMessage());
            this.typeNameText.setText(this.oldRecord.getTypeName());
            return;
        }
        this.oldRecord.setTypeName(this.typeNameText.getText());
    }

    @FXML
    void onPayloadModify(KeyEvent keyEvent) {
        this.checkLength(this.idText, 1024);
        if (!this.bCheckPayloadText) {
            this.bCheckPayloadText = true;
            return;
        }
        try {
            NFCUtil.checkInvalidCharacters(this.payloadText.getText());
        }
        catch (NFCEventException nFCEventException) {
            MessageBox.confirm((String)NFCConstants.DIALOG_TITLE_INFO, (String)nFCEventException.getMessage());
            this.payloadText.setText(this.oldRecord.getPayload());
            return;
        }
        this.oldRecord.setPayload(this.payloadText.getText());
    }

    @FXML
    void onRecordSelect(ActionEvent actionEvent) {
        this.selectRecord();
    }

    private void initNDEFTagView() {
        this.tagAttachButton = new TizenToggleButton("Attach", "Detach");
        this.tagAttachButton.setOn(false);
        this.tagTypeComboData.addAll(this.TagTypeList);
        this.tagTypeCombo.setItems(this.tagTypeComboData);
        this.tagTypeCombo.getSelectionModel().select(0);
        this.tagTypeHBox.getChildren().add((Object)this.tagAttachButton);
        this.tagAttachButton.setOnSelected((EventHandler)new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent buttonToggleEvent) {
                if (buttonToggleEvent.isSelected()) {
                    NFCController.this.clickTagDiscovered();
                } else {
                    NFCController.this.clickTagDetached();
                }
            }
        });
    }

    private void initP2PView() {
        this.p2pDiscoveredButton.setDisable(false);
        this.p2pDetachedButton.setDisable(true);
        this.p2pSendButton.setDisable(true);
    }

    private void initNDEFMessageView() {
        this.typeNameComboData.addAll(this.TypeNameList);
        this.typeNameCombo.setItems(this.typeNameComboData);
        this.typeNameCombo.getSelectionModel().select(0);
        this.typeNameFormatComboData.addAll(this.RecordFormatList);
        this.typeNameFormatCombo.setItems(this.typeNameFormatComboData);
        this.setOnTypeNameFormatSelected();
        this.typeNameFormatCombo.getSelectionModel().select(0);
        this.recordCombo.setItems(this.recordComboData);
    }

    private void selectRecord() {
        int n = this.recordCombo.getSelectionModel().getSelectedIndex();
        if (n != -1) {
            NDEFRecord nDEFRecord = this.RecordList.get(n);
            this.logger.info("SelectedRecord");
            this.logger.info("type: " + nDEFRecord.getTypeName());
            this.logger.info("id: " + nDEFRecord.getId());
            this.logger.info("payload: " + nDEFRecord.getPayload());
            this.checkRecordFormat(nDEFRecord.getFormat());
            this.typeNameFormatCombo.getSelectionModel().select(nDEFRecord.getFormat());
            if (nDEFRecord.getFormat() == 1) {
                if (nDEFRecord.getTypeName().compareTo("U") == 0) {
                    this.typeNameCombo.getSelectionModel().select(0);
                } else {
                    this.typeNameCombo.getSelectionModel().select(1);
                }
                this.typeNameText.setText("");
            } else {
                this.typeNameCombo.getSelectionModel().select(0);
                this.typeNameText.setText(nDEFRecord.getTypeName());
            }
            this.idText.setText(nDEFRecord.getId());
            this.payloadText.setText(nDEFRecord.getPayload());
        }
    }

    private void checkRecordFormat(int n) {
        switch (n) {
            case 0: {
                this.typeNameCombo.setDisable(true);
                this.typeNameText.setDisable(true);
                this.idText.setDisable(true);
                this.payloadText.setDisable(true);
                this.mediaFileButton.setDisable(true);
                break;
            }
            case 1: {
                this.typeNameCombo.setDisable(false);
                this.typeNameCombo.getSelectionModel().select(0);
                this.typeNameText.setDisable(true);
                this.idText.setDisable(false);
                this.payloadText.setDisable(false);
                this.payloadText.setEditable(true);
                this.mediaFileButton.setDisable(true);
                break;
            }
            case 2: {
                this.typeNameCombo.setDisable(true);
                this.typeNameText.setDisable(true);
                this.idText.setDisable(false);
                this.payloadText.setDisable(true);
                this.mediaFileButton.setDisable(false);
                break;
            }
            case 3: {
                this.typeNameCombo.setDisable(true);
                this.typeNameText.setDisable(false);
                this.typeNameText.setEditable(true);
                this.idText.setDisable(false);
                this.payloadText.setDisable(true);
                this.mediaFileButton.setDisable(true);
                break;
            }
            case 4: {
                this.typeNameCombo.setDisable(true);
                this.typeNameText.setDisable(false);
                this.typeNameText.setEditable(true);
                this.idText.setDisable(false);
                this.payloadText.setDisable(false);
                this.payloadText.setEditable(true);
                this.mediaFileButton.setDisable(true);
                break;
            }
            case 5: {
                this.typeNameCombo.setDisable(true);
                this.typeNameText.setDisable(true);
                this.idText.setDisable(false);
                this.payloadText.setDisable(false);
                this.payloadText.setEditable(true);
                this.mediaFileButton.setDisable(true);
                break;
            }
        }
        this.bCheckTypeNameText = false;
        this.bCheckIDText = false;
        this.bCheckPayloadText = false;
    }

    private void addRecord() {
        if (this.RecordList.size() >= 5) {
            MessageBox.confirm((String)NFCConstants.DIALOG_TITLE_INFO, (String)NFCErrorString.RecordCountIsMax);
            return;
        }
        NDEFRecord nDEFRecord = new NDEFRecord();
        this.setRecordValue(nDEFRecord);
        this.RecordList.add(nDEFRecord);
        int n = NFCUIUtil.checkRecordlistMaxLength(this.RecordList, 4096);
        if (n == 0) {
            this.RecordList.remove(nDEFRecord);
            return;
        }
        this.nTotalLength = n;
        this.recordLabel.setText(String.format(NFCConstants.RECORD_LABEL_FORMAT, this.nTotalLength, 4096));
        this.recordComboData.add((Object)(NFCConstants.RECORD_ITEM + this.RecordList.indexOf(nDEFRecord)));
        this.recordCombo.getSelectionModel().clearSelection();
    }

    private void addRecords(List<NDEFRecord> list) {
        int n = 0;
        this.RecordList = new ArrayList();
        for (NDEFRecord nDEFRecord : list) {
            this.logger.info("addRecord");
            this.logger.info("type: " + nDEFRecord.getTypeName());
            this.logger.info("id: " + nDEFRecord.getId());
            this.logger.info("payload: " + nDEFRecord.getPayload());
            this.RecordList.add(nDEFRecord);
            int n2 = NFCUIUtil.checkRecordlistMaxLength(this.RecordList, 4096);
            if (n2 == 0) {
                this.RecordList.remove(nDEFRecord);
                return;
            }
            this.nTotalLength = n2;
            this.recordComboData.add((Object)(NFCConstants.RECORD_ITEM + n++));
        }
        this.recordLabel.setText(String.format(NFCConstants.RECORD_LABEL_FORMAT, this.nTotalLength, 4096));
        this.recordCombo.getSelectionModel().clearSelection();
    }

    private void editRecord() {
        int n = this.recordCombo.getSelectionModel().getSelectedIndex();
        if (n != -1) {
            NDEFRecord nDEFRecord;
            NDEFRecord nDEFRecord2 = nDEFRecord = this.RecordList.get(n);
            this.setRecordValue(nDEFRecord);
            int n2 = NFCUIUtil.checkRecordlistMaxLength(this.RecordList, 4096);
            if (n2 == 0) {
                nDEFRecord = nDEFRecord2;
                return;
            }
            this.nTotalLength = n2;
            this.recordLabel.setText(String.format(NFCConstants.RECORD_LABEL_FORMAT, this.nTotalLength, 4096));
        }
    }

    private void removeRecord() {
        int n = this.recordCombo.getSelectionModel().getSelectedIndex();
        if (n != -1) {
            this.RecordList.remove(n);
            this.recordComboData.clear();
            for (int i = 0; i < this.RecordList.size(); ++i) {
                this.recordComboData.add((Object)(NFCConstants.RECORD_ITEM + i));
            }
            this.recordCombo.getSelectionModel().clearSelection();
        }
        this.nTotalLength = NFCUIUtil.checkRecordlistMaxLength(this.RecordList, 4096);
        this.recordLabel.setText(String.format(NFCConstants.RECORD_LABEL_FORMAT, this.nTotalLength, 4096));
        this.typeNameText.setText("");
        this.typeNameCombo.getSelectionModel().select(0);
        this.idText.setText("");
        this.payloadText.setText("");
    }

    private void removeAllRecord(int n) {
        this.recordComboData.clear();
        this.recordCombo.getSelectionModel().clearSelection();
        this.nTotalLength = NFCUIUtil.checkRecordlistMaxLength(this.RecordList, 4096);
        this.recordLabel.setText(String.format(NFCConstants.RECORD_LABEL_FORMAT, this.nTotalLength, 4096));
        this.typeNameText.setText("");
        this.typeNameCombo.getSelectionModel().select(0);
        this.idText.setText("");
        this.payloadText.setText("");
    }

    private void setRecordValue(NDEFRecord nDEFRecord) {
        int n = this.typeNameFormatCombo.getSelectionModel().getSelectedIndex();
        nDEFRecord.setNdefFormat(NDEFFormat.find(n));
        if (n == 1) {
            nDEFRecord.setTypeName(this.TypeNameList.get(this.typeNameCombo.getSelectionModel().getSelectedIndex()));
        } else if (this.typeNameText.getText() == null || this.typeNameText.getText().isEmpty()) {
            nDEFRecord.setTypeName("Null");
        } else {
            nDEFRecord.setTypeName(this.typeNameText.getText());
        }
        if (this.idText.getText() == null || this.idText.getText().isEmpty()) {
            nDEFRecord.setId("Null");
        } else {
            nDEFRecord.setId(this.idText.getText());
        }
        if (this.payloadText.getText() == null || this.payloadText.getText().isEmpty()) {
            nDEFRecord.setPayload("Null");
        } else {
            nDEFRecord.setPayload(this.payloadText.getText());
        }
    }

    public List<NDEFRecord> getRecordList() {
        return this.RecordList;
    }

    public void setRecordList(List<NDEFRecord> list) {
        this.removeAllRecord(list.size());
        this.addRecords(list);
    }

    public void setRecordDisableState() {
        this.typeNameFormatCombo.setDisable(true);
        this.checkRecordFormat(0);
        this.recordCombo.setDisable(true);
        this.addButton.setDisable(true);
        this.editButton.setDisable(true);
        this.removeButton.setDisable(true);
    }

    public void setRecordEnableState() {
        this.typeNameFormatCombo.setDisable(false);
        this.checkRecordFormat(this.typeNameFormatCombo.getSelectionModel().getSelectedIndex());
        this.typeNameCombo.getSelectionModel().select(0);
        this.recordCombo.setDisable(false);
        this.addButton.setDisable(false);
        this.editButton.setDisable(false);
        this.removeButton.setDisable(false);
    }

    private NFCTagType getTagType() {
        return NFCTagType.find(this.tagTypeCombo.getSelectionModel().getSelectedIndex());
    }

    private void clickTagDiscovered() {
        if (this.recordComboData.size() == 0) {
            NFCDialog.openInfoDialog(NFCErrorString.RecordCountIsZero);
            this.tagAttachButton.setOn(false);
            return;
        }
        boolean bl = NFCUIUtil.sendMessage(NFCEventType.TAG_DISCOVERED, this.getTagType(), this.RecordList);
        if (bl) {
            this.setRecordDisableState();
            this.tagTypeCombo.setDisable(true);
            this.p2pDiscoveredButton.setDisable(true);
            this.p2pDetachedButton.setDisable(true);
            this.p2pSendButton.setDisable(true);
        } else {
            this.tagAttachButton.setOn(false);
        }
    }

    private void clickTagDetached() {
        boolean bl = NFCUIUtil.sendMessage(NFCEventType.TAG_DETACHED, this.getTagType(), this.RecordList);
        if (bl) {
            this.setRecordEnableState();
            this.tagTypeCombo.setDisable(false);
            this.tagAttachButton.setDisable(false);
            this.p2pDiscoveredButton.setDisable(false);
            this.p2pDetachedButton.setDisable(true);
            this.p2pSendButton.setDisable(true);
        }
    }

    private void clickP2PDiscovered() {
        boolean bl = NFCUIUtil.sendMessage(NFCEventType.P2P_DISCOVERED, this.getTagType(), this.RecordList);
        if (bl) {
            this.tagTypeCombo.setDisable(true);
            this.tagAttachButton.setDisable(true);
            this.p2pDiscoveredButton.setDisable(true);
            this.p2pDetachedButton.setDisable(false);
            this.p2pSendButton.setDisable(false);
        }
    }

    private void clickP2PDetached() {
        boolean bl = NFCUIUtil.sendMessage(NFCEventType.P2P_DETACHED, this.getTagType(), this.RecordList);
        if (bl) {
            this.setRecordEnableState();
            this.tagTypeCombo.setDisable(false);
            this.tagAttachButton.setDisable(false);
            this.p2pDiscoveredButton.setDisable(false);
            this.p2pDetachedButton.setDisable(true);
            this.p2pSendButton.setDisable(true);
            this.p2pDiscoveredButton.requestFocus();
        }
    }

    private void clickP2PSend() {
        if (this.RecordList.size() == 0) {
            NFCDialog.openInfoDialog(NFCErrorString.RecordCountIsZero);
            return;
        }
        boolean bl = NFCUIUtil.sendMessage(NFCEventType.P2P_SEND, this.getTagType(), this.RecordList);
        if (bl) {
            this.setRecordDisableState();
            this.tagTypeCombo.setDisable(true);
            this.tagAttachButton.setDisable(true);
            this.p2pDiscoveredButton.setDisable(true);
            this.p2pDetachedButton.setDisable(false);
            this.p2pSendButton.setDisable(true);
        } else {
            this.setRecordEnableState();
            this.tagTypeCombo.setDisable(false);
            this.p2pDiscoveredButton.setDisable(false);
            this.p2pDetachedButton.setDisable(true);
            this.p2pSendButton.setDisable(true);
        }
    }

    void handleEventProc(String string, JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"return");
        this.logger.info("message:" + string2);
        if (string2 != null && !string2.contains("virtio-nfc-device") && !string2.contains("virtio-maru-nfc-pci")) {
            this.tagAttachButton.setDisable(true);
            this.p2pDiscoveredButton.setDisable(true);
        }
    }

    void handleStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        String string = deviceNtf.getData().toStringUtf8();
        this.logger.info("value:" + string);
        if (string != null) {
            String[] stringArray = string.split(":");
            int n = Integer.valueOf(stringArray[0]);
            NFCEventType nFCEventType = NFCEventType.find(n);
            if (nFCEventType == null) {
                return;
            }
            switch (nFCEventType) {
                case P2P_SEND: {
                    this.setRecordList(NFCUtil.makeNDEFMessage(stringArray[1]));
                    this.setRecordDisableState();
                    this.tagTypeCombo.setDisable(true);
                    this.tagAttachButton.setDisable(true);
                    this.p2pDiscoveredButton.setDisable(true);
                    this.p2pDetachedButton.setDisable(false);
                    this.p2pSendButton.setDisable(true);
                    break;
                }
                case P2P_DISCOVERED: {
                    this.tagTypeCombo.setDisable(true);
                    this.tagAttachButton.setDisable(true);
                    this.tagAttachButton.setOn(false);
                    this.p2pDiscoveredButton.setDisable(true);
                    this.p2pDetachedButton.setDisable(false);
                    this.p2pSendButton.setDisable(false);
                    break;
                }
                case P2P_DETACHED: {
                    this.setRecordEnableState();
                    this.tagTypeCombo.setDisable(false);
                    this.tagAttachButton.setDisable(false);
                    this.tagAttachButton.setOn(false);
                    this.p2pDiscoveredButton.setDisable(false);
                    this.p2pDetachedButton.setDisable(true);
                    this.p2pSendButton.setDisable(true);
                    break;
                }
                case TAG_DETACHED: {
                    this.setRecordEnableState();
                    this.tagTypeCombo.setDisable(false);
                    this.tagAttachButton.setDisable(false);
                    this.tagAttachButton.setOn(false);
                    this.p2pDiscoveredButton.setDisable(false);
                    this.p2pDetachedButton.setDisable(true);
                    this.p2pSendButton.setDisable(true);
                    break;
                }
                case TAG_DISCOVERED: {
                    List<NDEFRecord> list = NFCUtil.makeNDEFMessage(stringArray[1]);
                    String[] stringArray2 = stringArray[1].split(",");
                    int n2 = Integer.parseInt(stringArray2[0]);
                    this.logger.info("tagType: " + n2);
                    NFCTagType nFCTagType = NFCTagType.find(n2);
                    if (nFCTagType == NFCTagType.TYPE1) {
                        this.tagTypeCombo.getSelectionModel().select(1);
                    } else if (nFCTagType == NFCTagType.TYPE2) {
                        this.tagTypeCombo.getSelectionModel().select(2);
                    } else if (nFCTagType == NFCTagType.TYPE3) {
                        this.tagTypeCombo.getSelectionModel().select(3);
                    } else if (nFCTagType == NFCTagType.TYPE4) {
                        this.tagTypeCombo.getSelectionModel().select(4);
                    } else {
                        this.logger.severe("Tag type is wrong: " + (Object)((Object)nFCTagType));
                    }
                    this.setRecordList(list);
                    this.setRecordDisableState();
                    this.tagTypeCombo.setDisable(true);
                    this.tagAttachButton.setOn(true);
                    this.tagAttachButton.setDisable(false);
                    this.p2pDiscoveredButton.setDisable(true);
                    this.p2pDetachedButton.setDisable(true);
                    this.p2pSendButton.setDisable(true);
                    break;
                }
            }
        } else {
            this.logger.severe("Received data is null!");
        }
    }

    private void checkLength(TextField textField, int n) {
        if (textField.getText() != null && textField.getText().length() > n) {
            String string = textField.getText().substring(0, n);
            textField.setText(string);
        }
    }
}

