/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.earjack.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import javafx.scene.layout.Pane;
import org.tizen.ecp.earjack.ui.EarJackModel;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class EarJackPane
extends ECPPopupPane {
    private EarJackModel model = new EarJackModel();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 103);
    }

    public void onShow() {
        int n = this.model.getStatus().get();
        if (n == 1) {
            this.model.getThreeWire().setSelected(true);
        } else if (n == 3) {
            this.model.getFourWire().setSelected(true);
        } else if (n == 0) {
            this.model.getDisconnect().setSelected(true);
        }
    }

    public Pane create() {
        Pane pane = null;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/earjack/ui/EarJack.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[]{this.model});
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return pane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 103 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction()) {
            String string = injectorNtf.getData().toStringUtf8();
            if (string.equals(Integer.toString(1))) {
                this.model.setStatus(1);
                this.setCardDescription("3 Wire");
            } else if (string.equals(Integer.toString(3))) {
                this.model.setStatus(3);
                this.setCardDescription("4 Wire");
            } else {
                this.model.setStatus(0);
                this.setCardDescription("Disconnect");
            }
        }
    }
}

