/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.cli;

import com.google.protobuf.GeneratedMessage;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.cli.NFCCLIHelper;
import org.tizen.ecp.sock.MessageSender;

public class NFCStatusCLI
extends AbstractEmulatorCLI {
    public NFCStatusCLI() {
        this.messageType = "nfc";
    }

    public void printHelp() {
        super.printHelp();
    }

    public int execute() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
        this.startRunning();
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        NFCCLIHelper nFCCLIHelper = null;
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        String string = deviceNtf.getData().toStringUtf8();
        try {
            nFCCLIHelper = new NFCCLIHelper(string);
        }
        catch (NFCEventException nFCEventException) {
            OutputUtil.printError((String)nFCEventException.getMessage());
            this.returnValue = 1;
            this.stopRunning();
            return;
        }
        nFCCLIHelper.printCurrentNFCStatus();
        this.stopRunning();
    }
}

