/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rssi.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.rssi.ui.RSSIController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class RSSIPane
extends ECPPopupPane {
    private static Logger logger = LogUtil.getECPLogger(RSSIPane.class).getLogger();
    RSSIController controller;

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    public void onShow() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    public Pane create() {
        AnchorPane anchorPane;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/rssi/ui/RSSI.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
        try {
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.controller = (RSSIController)eCPFXMLLoader.getController();
        return anchorPane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        String string;
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 104 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction() && (string = injectorNtf.getData().toStringUtf8()) != null && !string.isEmpty()) {
            int n;
            if (this.controller != null) {
                this.controller.setLevel(string);
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n == 0) {
                this.setCardDescription("No Signal");
            } else if (n > 0 && n <= 2) {
                this.setCardDescription("Normal");
            } else if (n > 2 && n <= 4) {
                this.setCardDescription("Good");
            } else {
                logger.warning("Unsupported level. 0~4 : " + n);
            }
        }
    }
}

