/*
 * Copyright (c) 2020 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __EFL_EXTENSION_POPUP_H__
#define __EFL_EXTENSION_POPUP_H__

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup CAPI_EFL_EXTENSION_POPUP_MODULE Efl Extension Popup
 * @ingroup CAPI_EFL_EXTENSION_COMMON_UI_MODULE
 * @brief Eext Popup has a circle scroller and the content of Eext Popup is controlled
 *        by rotary event
 *
 * @{
 */

/**
 * @WEARABLE_ONLY
 * @brief Add a new eext popup. The scroller of eext popup
 *        is controlled by the rotary event.
 *
 * @param[in] parent The parent object
 * @return A new eext popup handle, otherwise @c NULL if it cannot be created
 *
 * @since_tizen 5.5
 */
EAPI Evas_Object* eext_popup_add(Evas_Object *parent);

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* __EFL_EXTENSION_POPUP_H__ */
