#ifndef _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_H_
#define _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_H_

#ifndef _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_CLASS_TYPE
#define _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_CLASS_TYPE

typedef Eo Efl_Wearable_Position_Manager_Circle_List;

#endif

#ifndef _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_TYPES
#define _EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Implementation of @ref Efl_Ui_Position_Manager_Entity for a circle
 * list
 *
 * Every item in the list will get at least his minsize applied, changes to the
 * misize are listened to and change the layout of all items. This supports the
 * vertical and horizontal orientation.
 *
 * @ingroup Efl_Wearable_Position_Manager_Circle_List
 */
#define EFL_WEARABLE_POSITION_MANAGER_CIRCLE_LIST_CLASS efl_wearable_position_manager_circle_list_class_get()

EWAPI const Efl_Class *efl_wearable_position_manager_circle_list_class_get(void) EINA_CONST;

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Return the item in given position.
 *
 * @param[in] obj The object.
 * @param[in] pos Position in canvas coordinates.
 *
 * @return The id of the item in that position.
 *
 * @ingroup Efl_Wearable_Position_Manager_Circle_List
 */
EOAPI int efl_wearable_position_manager_circle_list_positioned_item_get(Eo *obj, Eina_Position2D pos);
#endif /* EFL_BETA_API_SUPPORT */
#endif /* EFL_BETA_API_SUPPORT */

#endif
