/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceManager;
import org.cfeclipse.cfml.snippets.properties.CFMLPropertyManager;
import org.cfeclipse.cfml.snippets.util.CFPluginImages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SnippetPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.cfeclipse.cfml.snippets";
    private static SnippetPlugin plugin;
    private PreferenceStore propertyStore;
    private ResourceBundle resourceBundle;
    private CFMLPropertyManager fPropertyManager;
    private CFMLPreferenceManager fPreferenceManager;

    public SnippetPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("plugin");
        }
        catch (MissingResourceException x) {
            x.printStackTrace(System.err);
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CFPluginImages.initCFPluginImages();
        this.propertyStore = new PreferenceStore(String.valueOf(SnippetPlugin.getDefault().getStateLocation().toString()) + "/properties.ini");
        this.fPreferenceManager = new CFMLPreferenceManager();
        try {
            this.fPropertyManager = new CFMLPropertyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
        String defaultSnippetPath = String.valueOf(SnippetPlugin.getDefault().getStateLocation().toString()) + "/snippets";
        File f = new File(defaultSnippetPath);
        if (!f.exists()) {
            f.mkdir();
        }
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SnippetPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return SnippetPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public PreferenceStore getPropertyStore() {
        return this.propertyStore;
    }

    public CFMLPropertyManager getPropertyManager() {
        return this.fPropertyManager;
    }

    public CFMLPreferenceManager getPreferenceManager() {
        return this.fPreferenceManager;
    }

    protected void initializeDefaultPluginPreferences() {
        this.fPreferenceManager.initializeDefaultValues();
    }
}

