/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.properties.CFMLPropertyManager;
import org.eclipse.swt.widgets.MessageBox;

public class SnipKeyCombos {
    private Properties keyCombos = new Properties();
    private String keyComboFilePath = "";
    private String snippetFilePath = "";
    private static String HEADER_TEXT = "These key combos are used by the cfeclipse plugin.";

    public SnipKeyCombos() {
        CFMLPropertyManager propertyManager = SnippetPlugin.getDefault().getPropertyManager();
        this.snippetFilePath = new File(propertyManager.getSnippetsPath()).toString();
        this.keyComboFilePath = String.valueOf(this.snippetFilePath) + File.separatorChar + "keyCombos.properties";
        this.loadKeyCombos();
    }

    public String getKeyCombosFilePath() {
        return this.keyComboFilePath;
    }

    private void loadKeyCombos() {
        try {
            FileInputStream input = new FileInputStream(this.keyComboFilePath);
            this.keyCombos.load(input);
        }
        catch (IOException iOException) {
            try {
                FileOutputStream output = new FileOutputStream(this.keyComboFilePath);
                this.keyCombos.store(output, HEADER_TEXT);
            }
            catch (IOException ex) {
                MessageBox dialog = new MessageBox(null, 1);
                dialog.setMessage("Error opening keyCombos : " + this.keyComboFilePath);
                ex.printStackTrace();
            }
        }
    }

    public void setKeyCombo(String sequence, String snippetFile) {
        this.keyCombos.setProperty(sequence, snippetFile);
        try {
            FileOutputStream output = new FileOutputStream(this.keyComboFilePath);
            this.keyCombos.store(output, HEADER_TEXT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getKeyCombo(String sequence) {
        return this.keyCombos.getProperty(sequence);
    }

    public void clearKeyCombo(String sequence) {
        this.keyCombos.remove(sequence);
    }

    public String getSnippetFolder() {
        return this.snippetFilePath;
    }

    public String getSequence(String fileName) {
        if (this.keyCombos.containsValue(fileName)) {
            Enumeration<?> e = this.keyCombos.propertyNames();
            while (e.hasMoreElements()) {
                String sequence = e.nextElement().toString();
                if (!this.keyCombos.getProperty(sequence).equals(fileName)) continue;
                return sequence;
            }
        }
        return null;
    }
}

