/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceManager;
import org.cfeclipse.cfml.snippets.properties.CFMLPropertyManager;
import org.cfeclipse.cfml.snippets.views.snips.SnippetObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SnipReader {
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    private Document document = null;
    private String snipDescription;
    private String snipStartBlock;
    private String snipEndBlock;
    private boolean useAsTemplate = false;
    File snippetFile;
    private String templateExtension;

    public SnipReader() {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setIgnoringComments(true);
            this.factory.setIgnoringElementContentWhitespace(true);
            this.factory.setCoalescing(true);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace(System.err);
        }
    }

    public void read(String fileName) {
        this.snippetFile = fileName != null ? new File(fileName) : new File("");
        if (!this.snippetFile.exists()) {
            CFMLPropertyManager propertyManager = SnippetPlugin.getDefault().getPropertyManager();
            this.snippetFile = new File(String.valueOf(propertyManager.getSnippetsPath()) + fileName);
        }
        if (this.snippetFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.snippetFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                bis.mark(0);
                if ((char)bis.read() != '<') {
                    bis.reset();
                    bis.read();
                    bis.read();
                    bis.read();
                } else {
                    bis.reset();
                }
                bis.mark(0);
                try {
                    this.document = this.builder.parse(bis);
                    this.parseDocument();
                }
                catch (SAXException saxx) {
                    saxx.printStackTrace(System.err);
                    this.snipDescription = saxx.getMessage();
                }
                bis.close();
            }
            catch (IOException iox) {
                iox.printStackTrace(System.err);
                this.snipDescription = iox.getMessage();
            }
        }
    }

    private void parseDocument() {
        if (this.document == null) {
            return;
        }
        this.parseSnipDescription();
        this.parseSnipStartBlock();
        this.parseSnipEndBlock();
        this.parseSnipUseAsTemplate();
        this.parseTemplateExtension();
    }

    private void parseSnipDescription() {
        this.snipDescription = "";
        this.snipDescription = this.getValue("help", 0);
        if (this.snipDescription.length() == 0) {
            NamedNodeMap attributes;
            NodeList nodes = this.document.getElementsByTagName("snippet");
            if (nodes.getLength() == 0) {
                return;
            }
            Node workingNode = nodes.item(0);
            if (workingNode.getNodeName().equalsIgnoreCase("snippet") && (workingNode = (attributes = workingNode.getAttributes()).getNamedItem("name")) != null) {
                this.snipDescription = workingNode.getNodeValue();
            }
        }
    }

    private void parseSnipUseAsTemplate() {
        NamedNodeMap attributes;
        this.useAsTemplate = false;
        NodeList nodes = this.document.getElementsByTagName("snippet");
        if (nodes.getLength() == 0) {
            return;
        }
        Node workingNode = nodes.item(0);
        if (workingNode.getNodeName().equalsIgnoreCase("snippet") && (workingNode = (attributes = workingNode.getAttributes()).getNamedItem("filetemplate")) != null) {
            String isFileTemplate = workingNode.getNodeValue();
            this.useAsTemplate = "true".equalsIgnoreCase(isFileTemplate);
        }
    }

    private void parseTemplateExtension() {
        NamedNodeMap attributes;
        this.templateExtension = "cfm";
        NodeList nodes = this.document.getElementsByTagName("snippet");
        if (nodes.getLength() == 0) {
            return;
        }
        Node workingNode = nodes.item(0);
        if (workingNode.getNodeName().equalsIgnoreCase("snippet") && (workingNode = (attributes = workingNode.getAttributes()).getNamedItem("extension")) != null) {
            this.templateExtension = workingNode.getNodeValue();
        }
    }

    private void parseSnipStartBlock() {
        this.snipStartBlock = this.getValue("starttext", 0);
        if (this.snipStartBlock.length() == 0) {
            this.snipStartBlock = this.getValue("insertText", 0);
        }
    }

    private void parseSnipEndBlock() {
        this.snipEndBlock = this.getValue("endtext", 0);
        if (this.snipEndBlock.length() == 0) {
            this.snipEndBlock = this.getValue("insertText", 1);
        }
    }

    private String getValue(String key, int iteration) {
        short nodetype = 0;
        try {
            nodetype = this.document.getElementsByTagName(key).item(iteration).getFirstChild().getNodeType();
        }
        catch (Exception exception) {
            return "";
        }
        String val = null;
        if (nodetype == 3) {
            val = ((Text)this.document.getElementsByTagName(key).item(iteration).getFirstChild()).getData();
        } else if (nodetype == 4) {
            CDATASection cds = (CDATASection)this.document.getElementsByTagName(key).item(iteration).getFirstChild();
            val = cds.getNodeValue();
            if (val.endsWith(" ")) {
                val = val.substring(0, val.length() - 1);
            }
        } else {
            val = "";
        }
        return val;
    }

    public void performIndent(String indentString) {
        int i;
        CFMLPreferenceManager preferenceManager = SnippetPlugin.getDefault().getPreferenceManager();
        int tabWidth = preferenceManager.tabWidth();
        boolean insertSpacesForTabs = preferenceManager.insertSpacesForTabs();
        if (tabWidth < 1) {
            tabWidth = 4;
        }
        if (!insertSpacesForTabs) {
            String spaces = "";
            i = 0;
            while (i < tabWidth) {
                spaces = String.valueOf(spaces) + " ";
                ++i;
            }
            indentString = indentString.replaceAll("\t", spaces);
            int tabcount = indentString.length() / tabWidth;
            int spacecount = indentString.length() % tabWidth;
            indentString = "";
            i = 0;
            while (i < tabcount) {
                indentString = String.valueOf(indentString) + "\t";
                ++i;
            }
            i = 0;
            while (i < spacecount) {
                indentString = String.valueOf(indentString) + " ";
                ++i;
            }
        } else {
            indentString = "";
            i = 0;
            while (i < indentString.length()) {
                indentString = String.valueOf(indentString) + " ";
                ++i;
            }
        }
        String[] start = this.snipStartBlock.split("[\\n\\r]");
        this.snipStartBlock = start[0];
        i = 1;
        while (i < start.length) {
            this.snipStartBlock = String.valueOf(this.snipStartBlock) + "\n" + indentString + start[i];
            ++i;
        }
        String[] end = this.snipEndBlock.split("[\\n\\r]");
        this.snipEndBlock = end[0];
        i = 1;
        while (i < end.length) {
            this.snipEndBlock = String.valueOf(this.snipEndBlock) + "\n" + indentString + end[i];
            ++i;
        }
    }

    public SnippetObject getSnippet() {
        SnippetObject snippet = new SnippetObject();
        snippet.setDescription(this.getSnipDescription());
        snippet.setStartBlock(this.getSnipStartBlock());
        snippet.setEndBlock(this.getSnipEndBlock());
        snippet.setName(this.snippetFile.getName());
        return snippet;
    }

    public String getSnipDescription() {
        if (this.snipDescription == null) {
            this.snipDescription = "";
        }
        return this.snipDescription;
    }

    public String getSnipStartBlock() {
        if (this.snipStartBlock == null || this.snipStartBlock.trim().length() == 0) {
            this.snipStartBlock = "";
        }
        return this.snipStartBlock;
    }

    public String getSnipEndBlock() {
        if (this.snipEndBlock == null || this.snipEndBlock.trim().length() == 0) {
            this.snipEndBlock = "";
        }
        return this.snipEndBlock;
    }

    public boolean isFileTemplate() {
        return this.useAsTemplate;
    }

    public String getTemplateExtension() {
        return this.templateExtension;
    }
}

