/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceManager;
import org.cfeclipse.cfml.snippets.properties.ProjectPropertyStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.Workbench;

public class CFMLPropertyManager {
    private CFMLPreferenceManager preferenceManager = SnippetPlugin.getDefault().getPreferenceManager();
    private ArrayList listeners = new ArrayList();

    public IPreferenceStore getStore(IProject project) {
        return new ProjectPropertyStore(project);
    }

    public void initializeDefaultValues(IProject project) {
        ProjectPropertyStore store = new ProjectPropertyStore(project);
        store.setDefault("_snippetsPath", this.preferenceManager.snippetsPath());
    }

    public String snippetsPath(IProject project) {
        ProjectPropertyStore store = new ProjectPropertyStore(project);
        String snippetsPath = store.getString("_snippetsPath").trim();
        if (snippetsPath.length() == 0 && (snippetsPath = this.preferenceManager.snippetsPath()).length() == 0) {
            return this.defaultSnippetsPath();
        }
        return snippetsPath;
    }

    public String defaultSnippetsPath() {
        return this.preferenceManager.snippetsPath();
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        HashSet<IResource> result = new HashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = (IResource)this.getAdapter(o, IResource.class);
            if (resource == null) continue;
            result.add(resource);
        }
        return result.toArray(new IResource[result.size()]);
    }

    private Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    public String getSnippetsPath() {
        IStructuredSelection currentSelection = this.getSelection();
        if (currentSelection == null) {
            return this.defaultSnippetsPath();
        }
        IResource[] currentResource = this.getSelectedResources(currentSelection);
        if (currentResource.length == 0) {
            return this.defaultSnippetsPath();
        }
        return this.snippetsPath(currentResource[0].getProject());
    }

    public void setSnippetsPath(String path, IProject project) {
        ProjectPropertyStore store = new ProjectPropertyStore(project);
        this.firePropertyChangeEvent(store, "_snippetsPath", store.getString("_snippetsPath"), path);
        store.setValue("_snippetsPath", path);
    }

    public void setComponentRoot(String root, IProject project) {
        ProjectPropertyStore store = new ProjectPropertyStore(project);
        store.setValue("componentRoot", root);
    }

    protected IStructuredSelection getSelection() {
        ISelection partSelection;
        if (Workbench.getInstance().getActiveWorkbenchWindow().getActivePage() == null) {
            return null;
        }
        if (Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActivePart() == null) {
            return null;
        }
        IWorkbenchPartSite site = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        if (site != null && site.getSelectionProvider() != null && (partSelection = site.getSelectionProvider().getSelection()) != null) {
            if (partSelection instanceof IStructuredSelection) {
                return (IStructuredSelection)partSelection;
            }
            if (partSelection instanceof ITextSelection) {
                if (site.getWorkbenchWindow().getActivePage() == null || site.getWorkbenchWindow().getActivePage().getActiveEditor() == null) {
                    return null;
                }
                IResource resource = ResourceUtil.getResource((IEditorInput)site.getWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput());
                if (resource == null) {
                    return null;
                }
                return new StructuredSelection((Object)resource);
            }
        }
        return null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void firePropertyChangeEvent(Object srcObj, String name, Object oldValue, Object newValue) {
        Iterator listenerIter = this.listeners.iterator();
        PropertyChangeEvent event = new PropertyChangeEvent(srcObj, name, oldValue, newValue);
        while (listenerIter.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listenerIter.next();
            listener.propertyChange(event);
        }
    }
}

